﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers
{
    public class MaterialDidactico_FormatoController : Controller
    {
        //
        // GET: /MaterialDidactico_Formato/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidactico_Formato()
        {
            var model = db.MaterialDidactico_Formato;
            return PartialView("_pvMaterialDidactico_Formato", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_FormatoAddNew(Nova.Models.MaterialDidactico_Formato item)
        {
            var model = db.MaterialDidactico_Formato;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvMaterialDidactico_Formato", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_FormatoUpdate(Nova.Models.MaterialDidactico_Formato item)
        {
            var model = db.MaterialDidactico_Formato;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdFormato == item.IdFormato);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvMaterialDidactico_Formato", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidactico_FormatoDelete(System.Int16 IdFormato)
        {
            var model = db.MaterialDidactico_Formato;
            if (IdFormato != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdFormato == IdFormato);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                                       
                    
                }
            }


            return PartialView("_pvMaterialDidactico_Formato", model.ToList());
        }
    }
}
