﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class MaterialDidacticoTrabajadorAsignaturaController : Controller
    {
        //
        // GET: /MaterialDidacticoTrabajadorAsignatura/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvMaterialDidacticoTrabajadorAsignatura()
        {
            var model = db.MaterialDidactico_stTrabajadorAsignatura;
            return PartialView("_pvMaterialDidacticoTrabajadorAsignatura", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidacticoTrabajadorAsignaturaAddNew(Nova.Models.MaterialDidactico_stTrabajadorAsignatura item)
        {
            var model = db.MaterialDidactico_stTrabajadorAsignatura;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvMaterialDidacticoTrabajadorAsignatura", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidacticoTrabajadorAsignaturaUpdate(Nova.Models.MaterialDidactico_stTrabajadorAsignatura item)
        {
            var model = db.MaterialDidactico_stTrabajadorAsignatura;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdTrabajadorAsignatura == item.IdTrabajadorAsignatura);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvMaterialDidacticoTrabajadorAsignatura", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidacticoTrabajadorAsignaturaDelete(System.Int16 IdTrabajadorAsignatura)
        {
            var model = db.MaterialDidactico_stTrabajadorAsignatura;
            if (IdTrabajadorAsignatura != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdTrabajadorAsignatura == IdTrabajadorAsignatura);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvMaterialDidacticoTrabajadorAsignatura", model.ToList());
        }
    }
}
