﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Capacitacion
{
    public class MaterialDidacticoConvocatoriaController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        // GET: MaterialDidacticoConvocatoria
        public ActionResult Index()
        {
            return View();
        }

        [ValidateInput(false)]
        public ActionResult pvMaterialDidacticoConvocatoria()
        {
            var model = db.MaterialDidactico_ctConvocatoria;
            return PartialView("_pvMaterialDidacticoConvocatoria", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidacticoConvocatoriaAddNew(Nova.Models.MaterialDidactico_ctConvocatoria item)
        {
            var model = db.MaterialDidactico_ctConvocatoria;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_pvMaterialDidacticoConvocatoria", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidacticoConvocatoriaUpdate(Nova.Models.MaterialDidactico_ctConvocatoria item)
        {

            var model = db.MaterialDidactico_ctConvocatoria;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvocatoria == item.IdConvocatoria);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvMaterialDidacticoConvocatoria", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvMaterialDidacticoConvocatoriaDelete(System.Byte IdConvocatoria)
        {
            var model = db.MaterialDidactico_ctConvocatoria;
            if (IdConvocatoria != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdConvocatoria == IdConvocatoria);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvMaterialDidacticoConvocatoria", model.ToList());
        }
    }
}