﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Data.SqlClient;
using System.Configuration;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DevExpress.XtraLayout.Filtering.Templates;
using Nova.Models.Kardex;
using WebGrease.Activities;
using System.Web.UI.WebControls;
using Seguridad;
using System.Net.Sockets;
using System.Runtime.InteropServices.ComTypes;
using DevExpress.CodeParser;
using DevExpress.Utils.About;
using DevExpress.XtraEditors.Filtering.Templates;
using DevExpress.Utils.Extensions;

namespace Nova.Controllers.Kardex
{
    public class Kardex_DocumentosExpedienteController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";







        // GET: KardexGradoAcademico
        public ActionResult Index()
        {
            //Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //var kardex_GradoAcademicodapper= (List<Kardex_GradoAcademicoFotografia>)dp.connection.Query<Kardex_GradoAcademicoFotografia>(query);
            var kardex_GradoAcademico = db.Kardex_GradoAcademico.Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia); ;
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "Crear Grado Académico";
            ViewBag.TituloSwal = "Eliminar Grado Académico";
            ViewBag.PreguntaSwal = "¿Está seguro de eliminar el Grado Académico?";
            //dp.Close();
            return View(kardex_GradoAcademico.ToList());
        }

        // GET: KardexGradoAcademico/Details/5

        //public ActionResult Details(int id)
        public ActionResult Details()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DocumentosExpediente.Where(z => z.IdKardex == IdKardex));
        }

        // GET: KardexGradoAcademico/Create
        public ActionResult Create()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");
            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string querytipodocumento;

            //querytipodocumento = @"Select * from bdNova.dbo.Kardex_TipoDocumento Tp where 
            //                     Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                     from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";


            querytipodocumento = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
								 INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
								 inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
								 where Tp.IdConvenioLaboral=@IdConvenioLaboral and Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
                                 from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";


            var todastipodocumento = (List<Kardex_TipoDocumento>)dpcg.connection.Query<Kardex_TipoDocumento>(querytipodocumento, new { IdConvenioLaboral, IdKardex });

            dpcg.Close();

            ViewBag.IdKardex = db.vwDatosAspirantesTrabajadores.Where(z => z.IdKardex == IdKardex).FirstOrDefault().IdKardex;
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumento, "IdKardexTipoDocumento", "DocumentoExpediente");
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar");
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdKardexDocumentosExpediente,IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,NombreArchivo,FechaRegistro")] Kardex_DocumentosExpediente kardex_DocumentosExpediente,int IdCicloEscolar, HttpPostedFileBase upload)
        {


            Kardex_GradoAcademico kardex_GradoAcademico = new Kardex_GradoAcademico();
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            //kardex_GradoAcademicoFotografia.AbreviaturaProfesion = kardex_GradoAcademicoFotografia.AbreviaturaProfesion.ToUpper();
            //kardex_GradoAcademicoFotografia.NivelEstudioDescripcion = kardex_GradoAcademicoFotografia.NivelEstudioDescripcion.ToUpper();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            string CicloEscolar = Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(z => z.IdCicloEscolar == IdCicloEscolar).FirstOrDefault().CicloEscolar;

            //oficialia_stAnexoDocumentoEntradaTemporal.UsuarioFechaAnexo = usuarioactual;

            if (ModelState.IsValid)
            {

                //var RegistrosRepetidos = db.Kardex_DocumentosExpediente.Where(g => g.IdKardexDocumentosExpediente == kardex_DocumentosExpediente.IdKardexDocumentosExpediente).ToArray();
                //int valor = RegistrosRepetidos.Count();
                //if (valor > 0)
                //{


                //    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                //}

            

                //else
                //{
                                       
                    try
                    {
                        if (upload != null && upload.ContentLength > 0)

                        {

                            byte[] imagenData = null;
                            string tipoarchivo = "";
                            using (var binaryArchivo = new BinaryReader(upload.InputStream))
                            {
                                imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                                tipoarchivo = upload.ContentType;
                            }
                            //kardex_GradoAcademicoFotografia.Archivo = imagenData;
                            //kardex_GradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                            //kardex_GradoAcademicoFotografia.NombreArchivo = upload.FileName;

                       
                            using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                                //Escribir Datos de los archivos
                                    string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar) " +
                                     "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "')";


                                var rowsAffectedDoc=  dp.connection.Execute(sqlQueryDoc);

                                string sql = @"SELECT Max(IdKardexDocumentosExpediente)
                                                FROM bdNova.dbo.Kardex_DocumentosExpediente";
                                int idKardexDocumentosExpediente = dp.connection.ExecuteScalar<int>(sql);

                                //Escribir archivo 

                                string sql01 = "Insert Into bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador (IdKardex ,Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexDocumentosExpediente) " +
                                     "Values(@IdKardex,@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexDocumentosExpediente)  ";

                                DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));
                               
                                var parameters = new {IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo= upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = idKardexDocumentosExpediente };
                                var rowsAffectedImg01 = dp.connection.ExecuteScalar(sql01, parameters);

                               

                                dp.Close();
                                trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                        }
                       
                        else 
                        {
                            
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                            //Escribir Datos de los archivos
                            string sqlQueryDoc = "Insert Into bdNova.dbo.Kardex_DocumentosExpediente (IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar) " +
                             "Values(" + kardex_DocumentosExpediente.IdKardex + "," + kardex_DocumentosExpediente.IdKardexTipoDocumento + "," + IdConveniolaboraltrabajadorcategoria + ",'" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + DateTime.Now.ToString("yyyy/MM/dd") + "','" + CicloEscolar + "')";
                            var rowsAffectedDoc = dp.connection.Execute(sqlQueryDoc);
                            dp.Close();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                        }
                       
                        
                    }

                    
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                //}



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }






        public FileResult VerInfo(int idgradoacademico)
        {
            var archivosanexo = db.Kardex_stGradoAcademicoFotografia.Where(x => x.IdKardexGradoAcademico == idgradoacademico).FirstOrDefault();

            if (archivosanexo.TipoDocumento == "application/pdf")
            {
                return File(archivosanexo.Archivo, "application/pdf");

            }
            else if (archivosanexo.TipoDocumento == "application/msword")
            {
                return File(archivosanexo.Archivo, "application/msword");
            }

            else if (archivosanexo.TipoDocumento == "image/jpeg")
            {
                return File(archivosanexo.Archivo, "image/jpeg");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.ms-excel")
            {
                return File(archivosanexo.Archivo, "application/vnd.ms-excel");
            }
            else if (archivosanexo.TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            }

            return File(archivosanexo.Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }


        public FileResult DescargarInfo(int idkardexdocumentosexpedientetrabajador)
        {
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string queryexpedientetrabajador;

            queryexpedientetrabajador = @"select* from bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador
            where bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador.IdKardexDocumentosExpedienteTrabajador = @idkardexdocumentosexpedientetrabajador";
            var todosexpedientes = (List<Kardex_DocumentosExpedienteTrabajador>)dpcg.connection.Query<Kardex_DocumentosExpedienteTrabajador>(queryexpedientetrabajador, new { idkardexdocumentosexpedientetrabajador });
            dpcg.Close();

            if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/pdf")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/pdf", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".pdf");

            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/msword")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/msword", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".doc");
            }

            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "image/jpeg")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "image/jpeg", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".jpg");
            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/vnd.ms-excel")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.ms-excel", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".xls");
            }


            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/octet-stream")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/octet-stream", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".zip");
            }
            else if (todosexpedientes.FirstOrDefault().TipoDocumento == "application/vnd.openxmlformats-officedocument.wordprocessingml.document")
            {
                return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".docx");
            }
            
            return File(todosexpedientes.FirstOrDefault().Archivo, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Descarga_" + todosexpedientes.FirstOrDefault().NombreArchivo + ".xlsx");

            //string modalidad = "Poa_Mir" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";


        }

        // GET: KardexGradoAcademico/Edit/5
        public ActionResult Edit(int id)
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            ViewBag.IdKardex = IdKardex;
            ViewBag.IdKardexDocumentosExpediente = id;

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(query);
    
            string querytipodocumento;

            querytipodocumento = @"Select * from (Select * from bdNova.dbo.Kardex_TipoDocumento Tp
                                     where Tp.IdKardexTipoDocumento in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
                                           from bdNova.dbo.Kardex_DocumentosExpediente )) a
                                    inner join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardexTipoDocumento = b.IdKardexTipoDocumento
                                    where b.IdKardex=@IdKardex";

            var todastipodocumento = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(querytipodocumento, new { IdKardex });

            int TipoDocumento = todastipodocumento.Where(z=> z.IdKardexDocumentosExpediente== id).FirstOrDefault().IdKardexTipoDocumento;


            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string querytipodocumentos;

            //querytipodocumento = @"Select * from bdNova.dbo.Kardex_TipoDocumento Tp where 
            //                     Tp.IdKardexTipoDocumento not in (select  bdNova.dbo.Kardex_DocumentosExpediente.IdKardexTipoDocumento 
            //                     from bdNova.dbo.Kardex_DocumentosExpediente where bdNova.dbo.Kardex_DocumentosExpediente.IdKardex=@IdKardex )";


            querytipodocumentos = @"SELECT *  FROM bdNova.dbo.Kardex_stTipoDocumentoConvenio Tp
								 INNER JOIN  bdNova.dbo.Kardex_TipoDocumento a on a.IdKardexTipoDocumento = Tp.IdKardexTipoDocumento
								 inner join  bdNova.dbo.Catalogos_ctConvenioLaboral b on b.IdConvenioLaboral = Tp.IdConvenioLaboral
								 where Tp.IdConvenioLaboral=@IdConvenioLaboral ";


            var todastipodocumentos = (List<Kardex_TipoDocumento>)dp.connection.Query<Kardex_TipoDocumento>(querytipodocumentos, new { IdConvenioLaboral });

            string queryciclo;

            queryciclo = @"select a.IdCicloEscolar, b.CicloEscolar from bdCtlEscSeg.dbo.ctCicloescolar a
                            inner join bdNova.dbo.Kardex_DocumentosExpediente b on a.Nombre=b.CicloEscolar
                            where b.IdKardexDocumentosExpediente=@id";

            var todasciclo = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryciclo, new { id });

            int idciclo = todasciclo.FirstOrDefault().IdCicloEscolar;



            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            var valorkardex_DocumentosExpediente = kardex_DocumentosExpediente.Where(z=> z.IdKardex==id).FirstOrDefault();
            if (kardex_DocumentosExpediente == null)
            {
                return HttpNotFound();
            }
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_GradoAcademico.IdKardex);
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            //ViewBag.IdKardexTipoDocumento = new SelectList(db.Kardex_TipoDocumento.ToList(), "IdKardexTipoDocumento", "DocumentoExpediente", db.Kardex_TipoDocumento.Find(TipoDocumento).IdKardexTipoDocumento);
            ViewBag.IdKardexTipoDocumento = new SelectList(todastipodocumentos.ToList(), "IdKardexTipoDocumento", "DocumentoExpediente", todastipodocumentos.Where(x => x.IdKardexTipoDocumento == TipoDocumento).FirstOrDefault().IdKardexTipoDocumento);
            ViewBag.IdCicloEscolar = new SelectList(Nova.Models.Kardex.cicloescolar.GetCiclosEscolares(), "IdCicloEscolar", "CicloEscolar", Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(a=> a.IdCicloEscolar == idciclo).FirstOrDefault().IdCicloEscolar);
            dp.Close();
            return PartialView();
        
            //return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdKardexDocumentosExpediente,IdKardex,IdKardexTipoDocumento,IdConvenioLaboralTrabajadorCategoriaRegistro,FechaActualizacion,FechaEntrega,CicloEscolar,NombreArchivo,FechaRegistro")] Kardex_DocumentosExpediente kardex_DocumentosExpediente, int IdCicloEscolar, HttpPostedFileBase upload)
        {
                string msj = "El Grado académico ha sido editado existosamente!";
          
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            //kardex_GradoAcademico.AbreviaturaProfesion=kardex_GradoAcademico.AbreviaturaProfesion.ToUpper();
            //kardex_GradoAcademico.NivelEstudioDescripcion=kardex_GradoAcademico.NivelEstudioDescripcion.ToUpper();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            string CicloEscolar = Nova.Models.Kardex.cicloescolar.GetCiclosEscolares().Where(z => z.IdCicloEscolar == IdCicloEscolar).FirstOrDefault().CicloEscolar;
            DateTime Fecha = Convert.ToDateTime(DateTime.Now.ToString("yyyy/MM/dd"));

            if (ModelState.IsValid)
            {
             
                try
                {

                    if (upload != null && upload.ContentLength > 0)
                    {
                        byte[] imagenData = null;
                        string tipoarchivo = "";
                        using (var binaryArchivo = new BinaryReader(upload.InputStream))
                        {
                            imagenData = binaryArchivo.ReadBytes(upload.ContentLength);
                            tipoarchivo = upload.ContentType;

                        }
                        //kardex_stGradoAcademicoFotografia.Archivo = imagenData;
                        //kardex_stGradoAcademicoFotografia.TipoDocumento = tipoarchivo;
                        //kardex_stGradoAcademicoFotografia.NombreArchivo = upload.FileName;


                           using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos
                                    

                            string sqlupdateQuery = @"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = "+ IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar+"' WHERE IdKardexDocumentosExpediente = "+ kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            
                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);
                         


                            string sql = @"SELECT IdKardexDocumentosExpediente
                                           FROM bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador
										   where IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";
                            int idKardexDocumentosExpediente = dp.connection.ExecuteScalar<int>(sql);

                            ////Escribir archivo 
                            
                            if (idKardexDocumentosExpediente != 0)
                            {
                                var rowsAffectedDocFile = dp.connection.Execute("UPDATE bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador SET IdKardex=@IdKardex, Archivo= @Archivo, TipoDocumento = @TipoDocumento, NombreArchivo=@NombreArchivo, FechaRegistro=@FechaRegistro, IdKardexDocumentosExpediente=@IdKardexDocumentosExpediente WHERE IdKardexDocumentosExpediente = @IdKardexDocumentosExpediente01", new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente, IdKardexDocumentosExpediente01 = kardex_DocumentosExpediente.IdKardexDocumentosExpediente });
                            }
                            else
                            {
                                string sqlinsert = "Insert Into bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador (IdKardex ,Archivo,TipoDocumento,NombreArchivo,FechaRegistro,IdKardexDocumentosExpediente) " +
                                   "Values(@IdKardex,@Archivo,@TipoDocumento,@NombreArchivo,@FechaRegistro,@IdKardexDocumentosExpediente)  ";                                

                                var parameters = new { IdKardex = kardex_DocumentosExpediente.IdKardex, Archivo = imagenData, TipoDocumento = tipoarchivo, NombreArchivo = upload.FileName, FechaRegistro = Fecha, IdKardexDocumentosExpediente = kardex_DocumentosExpediente.IdKardexDocumentosExpediente };
                                var rowsAffectedImg01 = dp.connection.ExecuteScalar(sqlinsert, parameters);

                            }
                            
                            


                            dp.Close();
                                trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                        }

                    else 
                    {
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

                            //Escribir Datos de los archivos

                            string sqlupdateQuery = @"UPDATE bdNova.dbo.Kardex_DocumentosExpediente SET IdKardex =" + kardex_DocumentosExpediente.IdKardex + ",IdKardexTipoDocumento=" + kardex_DocumentosExpediente.IdKardexTipoDocumento + ",IdConvenioLaboralTrabajadorCategoriaRegistro = " + IdConveniolaboraltrabajadorcategoria + ",FechaActualizacion='" + DateTime.Now.ToString("yyyy/MM/dd") + "',FechaEntrega='" + DateTime.Now.ToString("yyyy/MM/dd") + "',CicloEscolar='" + CicloEscolar + "' WHERE IdKardexDocumentosExpediente = " + kardex_DocumentosExpediente.IdKardexDocumentosExpediente + "";

                            var rowsAffectedDoc = dp.connection.Execute(sqlupdateQuery);


                            dp.Close();
                            trans.Complete();
                            return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });
                        }

                            


                    }
                       
                   
                       
                        
                    }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {

                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                        var sqlDeleteExp= "DELETE bdNova.dbo.Kardex_DocumentosExpediente WHERE IdKardexDocumentosExpediente ="+ id +"";

                        var rowsAffectedExp = dp.connection.Execute(sqlDeleteExp);

                        var sqlDeleteArchivo = "DELETE bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador WHERE IdKardexDocumentosExpediente = "+ id +"";


                        var rowsAffectedArch = dp.connection.Execute(sqlDeleteArchivo);

                        dp.Close();
                        trans.Complete();
                    }
                    //db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
