﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.XtraBars.Ribbon;
using DevExpress.Pdf;
using Nova.Libraries;
//using DevExpress.Web;
using DevExpress.Web.Mvc;
using System.Web.UI;
using Rotativa;
using System.Drawing;
using System.IO;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using System.Web.Helpers;

using System.Transactions;
using DevExpress.XtraRichEdit;
using DevExpress.XtraPrinting;
using Dapper;
using System.Net;

namespace Nova.Controllers.Kardex
{
    public class DatosPersonalesController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();



        [ValidateInput(false)]
        public ActionResult AvanceTrabajadores()
        {
            var model = db.Kardex_ctDatosPersonales;

            return PartialView("_reportetrabajadores", model.ToList());
            //return PartialView("_pvCategorias", Session["Datos"]);
        }


        public ActionResult ReporteTrabajadores()
        {
            return View();
        }


        public ActionResult Curriculum()
        {
            return View();
        }

        [AllowAnonymous]
        public ActionResult VerCurriculums()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = @"select IdKardex
                            ,NombreCompleto=replace (ApellidoPaterno,' ','')+ replace (ApellidoMaterno,' ','')+ replace (Nombre,' ','')
                            ,Nombre,ApellidoPaterno,ApellidoMaterno,ConvenioLaboral
                            ,UbicacionFisica
                            from vwDatosAspirantesTrabajadores
                            where EstatusTrabajador='ALTA' and RestringirMenu is null 
                            and ConvenioLaboral in ('MANDO MEDIO Y SUPERIOR','CONFIANZA') 
                            order by ApellidoPaterno,ApellidoMaterno,Nombre";

            var trabajadores = (List<Kardex_ctDatosPersonales.CurriculumFiles>)dp.connection.Query<Kardex_ctDatosPersonales.CurriculumFiles>(query);
            dp.Close();



            string[] filePaths = Directory.GetFiles(Server.MapPath("~/Content/Curriculums/Publicos"));
            List<Kardex_ctDatosPersonales.CurriculumFiles> files = new List<Kardex_ctDatosPersonales.CurriculumFiles>();
            foreach (string filePath in filePaths)
            {
                var extension = Path.GetExtension(filePath);
                if (extension != ".pdf")
                {
                    var Datos = trabajadores.Where(t => t.NombreCompleto.Replace("Á", "A").Replace("É", "E").Replace("Í", "I").Replace("Ó", "O").Replace("Ú", "U").Replace("À", "A").Replace("È", "E").Replace("Ì", "I").Replace("Ò", "O").Replace("Ù", "U") == Path.GetFileNameWithoutExtension(filePath).Replace("Á", "A").Replace("É", "E").Replace("Í", "I").Replace("Ó", "O").Replace("Ú", "U").Replace("À", "A").Replace("È", "E").Replace("Ì", "I").Replace("Ò", "O").Replace("Ù", "U")).FirstOrDefault();

                    try
                    {
                        files.Add(new Kardex_ctDatosPersonales.CurriculumFiles
                        {
                         FileName = Path.GetFileName(filePath)
                        ,Nombre = Datos.Nombre
                        ,ApellidoPaterno = Datos.ApellidoPaterno
                        ,ApellidoMaterno = Datos.ApellidoMaterno
                        ,IdKardex = Datos.IdKardex
                        ,UbicacionFisica = Datos.UbicacionFisica
                        ,ConvenioLaboral = Datos.ConvenioLaboral
                        });
                    }
                    catch (Exception)
                    {

                        files.Add(new Kardex_ctDatosPersonales.CurriculumFiles { FileName = Path.GetFileName(filePath) });
                    }
                }
            }

            return View(files);
        }
        [AllowAnonymous]
        public FileResult DescargarCurriculum(string fileName)
        {
            string path = Server.MapPath("~/Content/Curriculums/Publicos/") + fileName;
            var extension = Path.GetExtension(path);
            if (extension != ".pdf")
            {
                using (RichEditDocumentServer wordProcessor = new RichEditDocumentServer())
                {
                    wordProcessor.LoadDocument(path, DocumentFormat.OpenXml);
                    PdfExportOptions options = new PdfExportOptions();
                    path = Path.ChangeExtension(path, ".pdf");

                    wordProcessor.ExportToPdf(path, options);
                }
            }
            return File(path, "application/pdf", Path.GetFileName(path));

        }

        public ActionResult DownloadFormato()
        {
            var usuarioDatos = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales;
            string actualPath = Server.MapPath("~/Content/Curriculums/Formato/CVPublico.docx");

            string nombre = usuarioDatos.Nombre.Replace(" ", "");
            string apPaterno = usuarioDatos.ApellidoPaterno.Replace(" ", "");
            string apMaterno = usuarioDatos.ApellidoMaterno.Replace(" ", "");
            string fnameUser = apPaterno + apMaterno + nombre;

            return File(actualPath, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", Server.UrlEncode(fnameUser + ".docx"));
        }

        [HttpPost]
        public ActionResult UploadCurriculum()
        {
            var usuarioDatos= Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales;
            string nombre = usuarioDatos.Nombre.Replace(" ", "");
            string apPaterno = usuarioDatos.ApellidoPaterno.Replace(" ", "");
            string apMaterno = usuarioDatos.ApellidoMaterno.Replace(" ", "");
            string fnameUser = apPaterno + apMaterno + nombre;
            
            if (Request.Files.Count > 0)
            {
                try
                {
                    HttpFileCollectionBase files = Request.Files;
                    for (int i = 0; i < files.Count; i++)
                    {

                        HttpPostedFileBase file = files[i];
                        string fname = String.Empty;
                        var tipoarchivo = file.ContentType;

                        if (tipoarchivo == "application/vnd.openxmlformats-officedocument.wordprocessingml.document" || tipoarchivo == "application/msword")
                        {
                            // Checking for Internet Explorer  
                            if (Request.Browser.Browser.ToUpper() == "IE" || Request.Browser.Browser.ToUpper() == "INTERNETEXPLORER")
                            {
                                string[] testfiles = file.FileName.Split(new char[] { '\\' });
                                fname = testfiles[testfiles.Length - 1];
                            }
                            else
                            {
                                fname = file.FileName;
                            }
                            fnameUser = Path.Combine(Server.MapPath("~/Content/Curriculums/Publicos"), fnameUser);
                            fname = fnameUser + ".docx";
                            file.SaveAs(fname);
                        }
                        else { throw new ArgumentException("Archivo no válido, debe ser de tipo WORD (*.doc | *.docx)"); }

                      
                    }
                    return Json("Archivo guardado!");
                }
                catch (Exception ex)
                {
                    throw new ArgumentException(ex.Message);
                    //return Json("error:" + ex.Message);
                }
            }
            else
            {
                throw new ArgumentException("No hay archivos seleccionados");
                //return Json("error: No hay archivos seleccionados");
            }
        }
        //
        // GET: /DatosPersonales/

        public ActionResult Index()
        {
            //  return View(db.Kardex_ctDatosPersonales.ToList());
            return RedirectToAction("Index", "Home");
        }


        //public ActionResult Paso2(int id,string email,string check,string isPost=null)
        //{
        //    ViewBag.Id = id;
        //    ViewBag.email = email;
        //    ViewBag.check = check;
        //    ViewBag.IsPost = isPost;
        //    if (Kardex_ctDatosPersonales.getProcesoCompletado(id) == true)
        //    {
        //        return View("terminado");
        //    }
        //    else
        //    {
        //        string codificado = Cifrado.Encrypt(email + id.ToString());

        //        if (HttpUtility.HtmlDecode(check) == codificado)
        //        {
        //            if (isPost!=null)
        //            MessageBox.Show(ViewData, TipoMensaje.Success, "Los datos Personales se han grabado exitosamente");



        //            return View();
        //        }
        //        else

        //            return View("NoAutorizado");
        //    }

        //}

        //
        // GET: /DatosPersonales/Details/5

        public ActionResult Details(int id = 0)
        {
            Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
            if (kardex_ctdatospersonales == null)
            {
                return HttpNotFound();
            }
            return View(kardex_ctdatospersonales);
        }



        //
        // GET: /DatosPersonales/Edit/5

        public ActionResult CuentaBanco()
        {
            int IdTrabajador = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador;
            //throw new Exception("Ocurrió un error específico en esta acción.");
            var model = Kardex_ctDatosPersonales.GetCuentasPago(db.Kardex_stTrabajadorCuentas, IdTrabajador);
            DateTime FechaIngreso = DateTime.Parse("2024-04-30");
            DateTime FechaActual = DateTime.Now;
            if (FechaActual.Date > FechaIngreso)
            {
                throw new Exception("La fecha de actualización de los datos bancarios ha vencido");
            }

            if (model.FirstOrDefault().IdInstitucionFinanciera != 1)
            {

                throw new Exception("La actualización de los datos bancarios solo es para las personas que tiene cuenta en Citibanamex");
            }


            ViewBag.IdTrabajador = IdTrabajador;
            Session["IdTrabajador"] = IdTrabajador;

            return View(model.ToList());
        }

        public ActionResult EditBanco(int? id)
        {

            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_stTrabajadorCuentas kardex_stTrabajadorCuentas = db.Kardex_stTrabajadorCuentas.Find(id);
            if (kardex_stTrabajadorCuentas == null)
            {
                return HttpNotFound();
            }

            ViewBag.IdTrabajador = Convert.ToInt16(Session["IdTrabajador"]);
            ViewBag.IdInstitucionFinanciera = new SelectList(db.Catalogos_ctInstitucionFinanciera, "IdInstitucionFinanciera", "InstitucionFinanciera", kardex_stTrabajadorCuentas.IdInstitucionFinanciera);
            ViewBag.IdFormaDePago = new SelectList(db.Catalogos_ctFormaDePago, "IdFormaDePago", "FormaDePago", kardex_stTrabajadorCuentas.IdFormaDePago);
            ViewBag.IdTipoCuentaPago = new SelectList(db.Catalogos_ctTipoCuentaPago, "IdTipoCuentaPago", "TipoCuentaPago", kardex_stTrabajadorCuentas.IdTipoCuentaPago);
            kardex_stTrabajadorCuentas.NumeroCuenta = null;
            return View(kardex_stTrabajadorCuentas);
        }

        // POST: Propiedades/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult EditBanco([Bind(Include = "IdTrabajadorCuentas, IdInstitucionFinanciera, IdTrabajador, IdFormaDePago, EsVigente, NumeroCuenta, IdTipoCuentaPago")] Kardex_stTrabajadorCuentas kardex_stTrabajadorCuentas)
        {

            // var existevigentePortipo = db.Kardex_stTrabajadorCuentas.Where(g =>
            //g.IdTrabajador == kardex_stTrabajadorCuentas.IdTrabajador && g.EsVigente == true && g.IdFormaDePago == kardex_stTrabajadorCuentas.IdFormaDePago).FirstOrDefault();

            // if (existevigentePortipo != null && kardex_stTrabajadorCuentas.EsVigente)
            // {
            //     return Json(new { Valid = false, Message = "Ya existe una cuenta vigente para este forma de pago, desactive primero la cuenta vigente para poder agregar una nueva" });
            // }

            if (ModelState.IsValid)
            {

                try
                {
                    kardex_stTrabajadorCuentas.IdTipoCuentaPago = 2;
                    db.Entry(kardex_stTrabajadorCuentas).State = EntityState.Modified;
                    db.SaveChanges();
                    //Kardex_stTrabajadorCuentas model = db.Kardex_stTrabajadorCuentas.Include(w => w.Kardex_ctTrabajador.Kardex_ctDatosPersonales).Where(q => q.IdTrabajadorCuentas == kardex_stTrabajadorCuentas.IdTrabajadorCuentas).FirstOrDefault();

                    //SendPushNotification("Se ha editado una cuenta de pago para: " + model.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + model.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno, TypePushNotification.success, "Nómina");
                    return Json(new { Valid = true, Message = "Registro guardado satisfactoriamente." });
                }
                catch (Exception e)
                {

                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }

                return Json(new { Valid = true, Message = "Registro guardado satisfactoriamente." });



            }
            ViewBag.IdInstitucionFinanciera = new SelectList(db.Catalogos_ctInstitucionFinanciera, "IdInstitucionFinanciera", "InstitucionFinanciera", kardex_stTrabajadorCuentas.IdInstitucionFinanciera);
            ViewBag.IdFormaDePago = new SelectList(db.Catalogos_ctFormaDePago, "IdFormaDePago", "FormaDePago", kardex_stTrabajadorCuentas.IdFormaDePago);
            ViewBag.IdTipoCuentaPago = new SelectList(db.Catalogos_ctTipoCuentaPago, "IdTipoCuentaPago", "TipoCuentaPago", kardex_stTrabajadorCuentas.IdTipoCuentaPago);

            return Json(new { Valid = true, Message = "Registro guardado satisfactoriamente." });


        }

        // GET: /CuentasPago/



        //
        // GET: /DatosPersonales/Create

        public ActionResult Create()
        {
            Kardex_ctDatosPersonales model = new Kardex_ctDatosPersonales(); ;
            ViewBag.TipoSangre = new SelectList(db.Catalogos_ctTipoSangre, "IdTipoSangre", "Tipo");
            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");
            //ViewBag.ItemIDList = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");
            ViewBag.IdKardex = 0;
            model.FechaNacimiento = DateTime.Now;
            return View(model);
        }

        //
        // POST: /DatosPersonales/Create

        [HttpPost]
        public ActionResult Create(Kardex_ctDatosPersonales kardex_ctdatospersonales)
        {
            ViewBag.IdKardex = 0;

            ViewBag.TipoSangre = new SelectList(db.Catalogos_ctTipoSangre, "IdTipoSangre", "Tipo");
            kardex_ctdatospersonales.ProcesoCompletado = false;

            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");

            ViewBag.urlimage = "";
            ViewBag.IdLocalidadNacimientoText = "";
            ViewBag.IdLocalidadViveText = "";



            if (Request["IdLocalidadNacimientoText"] != "")
                ViewBag.IdLocalidadNacimientoText = Request["IdLocalidadNacimientoText"];

            if (Request["IdLocalidadViveText"] != "")
                ViewBag.IdLocalidadViveText = Request["IdLocalidadViveText"];


            if (kardex_ctdatospersonales.ValidaModelo().IsValid)
            {


                if (ModelState.IsValid)
                {


                    db.Kardex_ctDatosPersonales.Add(kardex_ctdatospersonales);


                    try
                    {
                        db.SaveChanges();
                        Kardex_ctDatosPersonalesFotografias kdf = new Kardex_ctDatosPersonalesFotografias();
                        kdf.IdKardex = kardex_ctdatospersonales.IdKardex;
                        if (Request.Files[0].FileName != "")
                        {
                            //var image = new WebImage(Request.Files[0].InputStream); 
                            //var Height = image.Height; 
                            //var Width = image.Width; 

                            //    int Top = ConvertToInt.ConvertToInt32(Request["hfimgcrop_top"]);
                            //int Left = ConvertToInt.ConvertToInt32(Request["hfimgcrop_left"]);
                            //int Bottom = ConvertToInt.ConvertToInt32(Request["hfimgcrop_bottom"]);
                            //int Right = ConvertToInt.ConvertToInt32(Request["hfimgcrop_right"]);


                            //    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));


                            var image = new WebImage(Request.Files[0].InputStream);

                            var Height = image.Height;
                            var Width = image.Width;

                            decimal Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                            decimal Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                            decimal Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                            decimal Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);



                            //      width: Math.round(rx * boundx) + 'px',
                            //height: Math.round(ry * boundy) + 'px',
                            //marginLeft: '-' + Math.round(rx * c.x) + 'px',
                            //marginTop: '-' + Math.round(ry * c.y) + 'px'


                            image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));

                            image.Resize(220, 228, true, true);


                            kdf.Fotografia = image.GetBytes();




                        }
                        else
                            if (Request["hfUrlImage"] != null)
                                if (Request["hfUrlImage"] != "" && Request["hfUrlImage"].IndexOf("getFotografia") == -1)
                                {
                                kdf.Fotografia = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
                                    ViewBag.urlimage = Request["hfUrlImage"];
                                }
                        db.Kardex_ctDatosPersonalesFotografias.Add(kdf);
                        db.SaveChanges();
    
                    }
                    catch (Exception e)
                    {
                        throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
                    }

                    //return RedirectToAction("Index");
                    MessageBox.Show(ViewData, TipoMensaje.Success, "Registro Grabado con éxito ");

                }
                else
                {
                    var errors = ModelState.Select(x => x.Value.Errors)
                                .Where(y => y.Count > 0)
                                .ToList();
                }
            }
            else
                MessageBox.Show(ViewData, TipoMensaje.Warning, kardex_ctdatospersonales.ValidaModelo().Mensaje);

            return View(kardex_ctdatospersonales);
        }

        //
        // GET: /DatosPersonales/Edit/5



        public ActionResult Perfil()
        {


            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

            ViewBag.adscripcion = Seguridad.Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;

            ViewBag.IdKardex = IdKardex;
            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");

            ViewBag.TipoSangre = new SelectList(db.Catalogos_ctTipoSangre, "IdTipoSangre", "Tipo");
            ViewBag.Discapacidades = new SelectList(db.Catalogos_ctDiscapacidades, "IdDiscapacidad", "Discapacidad");
            ViewBag.LenguasIndigenas = new SelectList(db.Catalogos_ctLenguasIndigenas, "IdLenguasIndigenas", "LenguasIndigenas");
            ViewBag.PueblosIndigenas = new SelectList(db.Catalogos_ctPueblosIndigenas, "IdPueblosIndigenas", "PueblosIndigenas");
            ViewBag.dllEstadoCivil = new SelectList(db.Kardex_EstadoCivil, "IdEstadoCivil", "EstadoCivil");
            Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(IdKardex);
            Kardex_ctDatosPersonalesFotografias kdpk = db.Kardex_ctDatosPersonalesFotografias.Where(z=>z.IdKardex==IdKardex).FirstOrDefault();
            if(kdpk!=null)
                ViewBag.urlimage = kdpk.Fotografia;

            ViewBag.IdLocalidadNacimientoText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoNacimiento, kardex_ctdatospersonales.IdMunicipioNacimiento, kardex_ctdatospersonales.IdLocalidadNacimiento);


            ViewBag.IdLocalidadViveText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoVive, kardex_ctdatospersonales.IdMunicipioVive, kardex_ctdatospersonales.IdLocalidadVive);

            // kardex_ctdatospersonales.CorreoElectronico = email;

            if (kardex_ctdatospersonales == null)
            {
                return HttpNotFound();
            }
            return View("EditPerfil", kardex_ctdatospersonales);



        }

      
        //    public ActionResult Edit(int id ,string email,string check)
        //{


        //    ViewBag.Id = id;
        //    ViewBag.email = email;
        //    ViewBag.check = check;

        //    if (Kardex_ctDatosPersonales.getProcesoCompletado(id) == true)
        //    {
        //        return View("terminado");
        //    }
        //    else
        //    {
        //        string codificado = Cifrado.Encrypt(email + id.ToString());

        //        if (HttpUtility.UrlDecode(check) == codificado)
        //        {
        //            ViewBag.IdKardex = id;
        //            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");


        //            Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
        //            ViewBag.urlimage = kardex_ctdatospersonales.Fotografia;


        //            ViewBag.IdLocalidadNacimientoText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoNacimiento, kardex_ctdatospersonales.IdMunicipioNacimiento, kardex_ctdatospersonales.IdLocalidadNacimiento);


        //            ViewBag.IdLocalidadViveText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoVive, kardex_ctdatospersonales.IdMunicipioVive, kardex_ctdatospersonales.IdLocalidadVive);

        //            kardex_ctdatospersonales.CorreoElectronico = email;

        //            if (kardex_ctdatospersonales == null)
        //            {
        //                return HttpNotFound();
        //            }
        //            return View(kardex_ctdatospersonales);
        //        }
        //        else
        //            //throw new Exception(" Los parametros de la página a la que esta accesando no son válidos");

        //            return View("NoAutorizado");
        //    }

        //}


        public ActionResult Terminar(int id, string email, string check)
        {

            string codificado = Cifrado.Encrypt(email + id.ToString());

            if (HttpUtility.HtmlDecode(check) == codificado)
            {
                ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");
                ViewBag.IdKardex = id;

                Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
                Kardex_ctDatosPersonalesFotografias kdpk = db.Kardex_ctDatosPersonalesFotografias.Where(z=>z.IdKardex==id).FirstOrDefault();
                ViewBag.urlimage = kdpk.Fotografia;

                kardex_ctdatospersonales.ProcesoCompletado = true;

                db.SaveChanges();

                ViewBag.IdLocalidadNacimientoText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoNacimiento, kardex_ctdatospersonales.IdMunicipioNacimiento, kardex_ctdatospersonales.IdLocalidadNacimiento);


                ViewBag.IdLocalidadViveText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_ctdatospersonales.IdEstadoVive, kardex_ctdatospersonales.IdMunicipioVive, kardex_ctdatospersonales.IdLocalidadVive);

                if (kardex_ctdatospersonales == null)
                {
                    return HttpNotFound();
                }
                //return View(kardex_ctdatospersonales);

                return new ViewAsPdf(kardex_ctdatospersonales) { CustomSwitches = " --header-center  \" COLEGIO DE ESTUDIOS CIENTÍFICOS Y TECNOLÓGICOS DEL ESTADO DE OAXACA\" --footer-center \"Página [page] de [topage]\" --page-size Letter --footer-line --header-line " };
            }
            else
                //throw new Exception(" Los parametros de la página a la que esta accesando no son válidos");

                return View("NoAutorizado");


        }
        //
        // POST: /DatosPersonales/Edit/5
 

        [HttpPost]
        public ActionResult EditPerfil(Kardex_ctDatosPersonales kardex_ctdatospersonales)
        {
            Int32 idk = kardex_ctdatospersonales.IdKardex;

            byte[] foto = db.Kardex_ctDatosPersonalesFotografias.Where(e => e.IdKardex == idk).Select(f => f.Fotografia).SingleOrDefault();

            ViewBag.adscripcion = Seguridad.Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;

            kardex_ctdatospersonales.ProcesoCompletado = true;
            //kardex_ctdatospersonales.IdeEmpleadoAnt = -1;

            ViewBag.TipoSangre = new SelectList(db.Catalogos_ctTipoSangre, "IdTipoSangre", "Tipo");
            ViewBag.Discapacidades = new SelectList(db.Catalogos_ctDiscapacidades, "IdDiscapacidad", "Discapacidad");
            ViewBag.LenguasIndigenas = new SelectList(db.Catalogos_ctLenguasIndigenas, "IdLenguasIndigenas", "LenguasIndigenas");
            ViewBag.PueblosIndigenas = new SelectList(db.Catalogos_ctPueblosIndigenas, "IdPueblosIndigenas", "PueblosIndigenas");

            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");
            ViewBag.IdKardex = kardex_ctdatospersonales.IdKardex;
            ViewBag.dllEstadoCivil = new SelectList(db.Kardex_EstadoCivil, "IdEstadoCivil", "EstadoCivil");
            ViewBag.urlimage = "";
            ViewBag.IdLocalidadNacimientoText = "";
            ViewBag.IdLocalidadViveText = "";

            if (Request["IdLocalidadNacimientoText"] != "")
                ViewBag.IdLocalidadNacimientoText = Request["IdLocalidadNacimientoText"];

            if (Request["IdLocalidadViveText"] != "")
                ViewBag.IdLocalidadViveText = Request["IdLocalidadViveText"];


            if (kardex_ctdatospersonales.ValidaModelo().IsValid)
            {

                if (ModelState.IsValid)
                {
                    TransactionOptions transactionoptions1 = new TransactionOptions();
                    transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;

                    try
                    {

                        using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                        {

                            string cambiomail = "";
                            if (Request["hfemailoriginal"] != kardex_ctdatospersonales.CorreoElectronico)
                            {
                                cambiomail = " Estimado Usuario ha cambiado su correo electronico, por lo que deberá de volver a ACTIVAR SU CUENTA, para poder ingresar nuevamente al sistema";

                                db.Entry(kardex_ctdatospersonales).State = System.Data.Entity.EntityState.Modified;
                                db.SaveChanges();

                                var usuariokardex = db.UsuarioKardex.Where(r => r.IdKardex == kardex_ctdatospersonales.IdKardex).FirstOrDefault();
                                if (usuariokardex != null)
                                {
                                    var aspnetusers = db.AspNetUsers.Where(r => r.Id == usuariokardex.Id).FirstOrDefault();
                                    var permisos = db.GrupoRolAplicacionUsuarioKardex.Where(r => r.IdUsuarioKardex == usuariokardex.IdUsuarioKardex).ToList();


                                    db.GrupoRolAplicacionUsuarioKardex.RemoveRange(db.GrupoRolAplicacionUsuarioKardex.Where(r => r.IdUsuarioKardex == usuariokardex.IdUsuarioKardex));


                                    db.Entry(usuariokardex).State = System.Data.Entity.EntityState.Deleted;
                                    db.Entry(aspnetusers).State = System.Data.Entity.EntityState.Deleted;



                                    db.SaveChanges();

                                }

                            }
                            else
                            {
                                db.Entry(kardex_ctdatospersonales).State = System.Data.Entity.EntityState.Modified;
                                //db.Kardex_ctDatosPersonales.Add(kardex_ctdatospersonales);
                                db.SaveChanges();
                            }
                            Kardex_ctDatosPersonalesFotografias kdpk = new Kardex_ctDatosPersonalesFotografias();
                            bool EsFotoNueva = false;
                            var fotoKardex = db.Kardex_ctDatosPersonalesFotografias.Where(z => z.IdKardex == kardex_ctdatospersonales.IdKardex).FirstOrDefault();

                            if (fotoKardex != null)
                                kdpk.IdKardex = fotoKardex.IdKardex;
                            else
                            {
                                kdpk.IdKardex = kardex_ctdatospersonales.IdKardex;
                                EsFotoNueva = true;
                            }


                            if (Request.Files[0].FileName != "")
                            {

                                var image = new WebImage(Request.Files[0].InputStream);


                                var Height = image.Height;
                                var Width = image.Width;

                                decimal Top = 0;
                                decimal Left = 0;
                                decimal Bottom = 0;
                                decimal Right = 0;

                                if (Request["hfimgcrop_top"] != "")
                                {
                                    Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                                    Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                                    Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                                    Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);

                                    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));
                                }


                                //      width: Math.round(rx * boundx) + 'px',
                                //height: Math.round(ry * boundy) + 'px',
                                //marginLeft: '-' + Math.round(rx * c.x) + 'px',
                                //marginTop: '-' + Math.round(ry * c.y) + 'px'



                                //image.Resize(220, 228, true, true);

                                image.Resize(600, 600, true, true);


                                kdpk.Fotografia = image.GetBytes();
                            }
                            else

                            //if (Request["hfUrlImage"] != null)
                            //    if (Request["hfUrlImage"] != "")
                            //    {
                            //        kardex_ctdatospersonales.Fotografia = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
                            //        ViewBag.urlimage = Request["hfUrlImage"];
                            //    }
                            {

                                kdpk.Fotografia = foto;
                            }

                            if (EsFotoNueva)
                            {
                                db.Kardex_ctDatosPersonalesFotografias.Add(kdpk);
                                db.SaveChanges();
                            }
                            else
                            {
                                fotoKardex.Fotografia = kdpk.Fotografia;

                                db.Entry(fotoKardex).State = System.Data.Entity.EntityState.Modified;
                                db.SaveChanges();
                            }
                            Seguridad.Identidad.ResetSingleton();
                            string codificado = Cifrado.Encrypt(kardex_ctdatospersonales.CorreoElectronico + kardex_ctdatospersonales.IdKardex.ToString());


                            MessageBox.Show(ViewData, TipoMensaje.Information, "Los datos Personales se han grabado exitosamente." + cambiomail);
                            scope.Complete();
                        }
                    }
                    catch (Exception ex)
                    {

                        throw new  Exception( ExceptionExtensions.GetOriginalException(ex).Message);
                    }

                    // return RedirectToAction("Paso2", "DatosPersonales", new { id = kardex_ctdatospersonales.IdKardex, email = kardex_ctdatospersonales.CorreoElectronico, check = codificado ,isPost="1"});
                    return View("EditPerfil", kardex_ctdatospersonales);
                    //return RedirectToAction("Perfil");
                }
                else
                {
                    var errors = ModelState.Select(x => x.Value.Errors)
                             .Where(y => y.Count > 0)
                             .ToList();


                }
            }
            else
                MessageBox.Show(ViewData, TipoMensaje.Warning, kardex_ctdatospersonales.ValidaModelo().Mensaje);


            return View("EditPerfil", kardex_ctdatospersonales);
        }

        //
        // GET: /DatosPersonales/Delete/5

        public ActionResult Delete(int id = 0)
        {
            ViewBag.IdPais = new SelectList(db.Catalogos_ctPais, "IdPais", "Pais");

            Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
            if (kardex_ctdatospersonales == null)
            {
                return HttpNotFound();
            }
            return View(kardex_ctdatospersonales);
        }

        //
        // POST: /DatosPersonales/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {
            Kardex_ctDatosPersonales kardex_ctdatospersonales = db.Kardex_ctDatosPersonales.Find(id);
            db.Kardex_ctDatosPersonales.Remove(kardex_ctdatospersonales);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }

        //public ActionResult CallbacksImageUpload(IEnumerable<UploadedFile> ucCallbacks)
        //{
        //    return null;
        //}

        public ActionResult UploadControlCallbackAction()
        {
            UploadControlExtension.GetUploadedFiles("Fotografia", UploadControlDemosHelper.UploadControlValidationSettings, UploadControlDemosHelper.uc_FileUploadComplete);
            return null;
        }

          [AllowAnonymous]
        public ActionResult getFotografia(int id)
        {
            byte[] image = Kardex_ctDatosPersonales.getFotografia(id);
            if (image == null)
                //return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.jpg"), "image/jpg");
                return File("~/App_Themes/Nova/img/user.jpg", "image/jpg");
            else
            {

                //using (MemoryStream ms = new MemoryStream(image))
                //{
                //    Bitmap img = (Bitmap)Image.FromStream(ms);
                //    return File(BitmapToByteArray(img), "image/jpg");
                //}
                Image miimagen = byteArrayToImage(image);

                //miimagen.Save(@"C:\imagenes\test.jpg", System.Drawing.Imaging.ImageFormat.Jpeg);


                return File(ToStream(miimagen, ImageFormat.Jpeg), "image/jpg");
            }
            //return File(image, "image/jpg");
        }

[AllowAnonymous]
        public ActionResult getFotografiaConvenio(int id)
        {
            byte[] image = Kardex_ctDatosPersonales.getFotografiaConvenio(id);
            if (image == null)
                //return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.jpg"), "image/jpg");
                return File("~/App_Themes/Nova/img/user.jpg", "image/jpg");
            else
            {

                //using (MemoryStream ms = new MemoryStream(image))
                //{
                //    Bitmap img = (Bitmap)Image.FromStream(ms);
                //    return File(BitmapToByteArray(img), "image/jpg");
                //}
                Image miimagen = byteArrayToImage(image);

                //miimagen.Save(@"C:\imagenes\test.jpg", System.Drawing.Imaging.ImageFormat.Jpeg);


                return File(ToStream(miimagen, ImageFormat.Jpeg), "image/jpg");
            }
            //return File(image, "image/jpg");
        }
        public Image byteArrayToImage(byte[] byteArrayIn)
        {
            MemoryStream ms = new MemoryStream(byteArrayIn);
            Image returnImage = Image.FromStream(ms);
            return returnImage;
        }

        public Stream ToStream(Image image, ImageFormat formaw)
        {
            var stream = new System.IO.MemoryStream();
            image.Save(stream, formaw);
            stream.Position = 0;
            return stream;
        }
        //Then you can use the following

        //var stream = myImage.ToStream(ImageFormat.Gif);

        public byte[] BitmapToByteArray(Bitmap bitmap)
        {

            BitmapData bmpdata = bitmap.LockBits(new Rectangle(0, 0, bitmap.Width, bitmap.Height), ImageLockMode.ReadOnly, bitmap.PixelFormat);
            int numbytes = bmpdata.Stride * bitmap.Height;
            byte[] bytedata = new byte[numbytes];
            IntPtr ptr = bmpdata.Scan0;

            Marshal.Copy(ptr, bytedata, 0, numbytes);

            bitmap.UnlockBits(bmpdata);

            return bytedata;
        }


        public ActionResult Terminado(int id, string email, string check)
        {

            ViewBag.Id = id;
            ViewBag.email = email;
            ViewBag.check = check;
            return View();
        }

        public ActionResult GenerarCredenciales()
        {
            //var areas =  db.Kardex_ctDatosPersonales.GroupBy(d => d.LaboraFisicamente, (key, g) => new { LaboraFisicamente = key }).ToList();
            //SelectListItem lista = new SelectListItem();
            //foreach (var item in areas)
            //{
            //    lista.Text = item.LaboraFisicamente;
            //    lista.Value= item.LaboraFisicamente;

            //}

            //var areas = db.Catalogos_ctEstructuraOrganica.ToList().Select(u => new SelectListItem
            //{
            //    //Text = u.FirstName + " " + u.LastName,
            //    Text = u.EstructuraOrganica,
            //    Value = u.EstructuraOrganica
            //});


            //var areas = db.Kardex_ctDatosPersonales.GroupBy(d => d.LaboraFisicamente, (key, g) => new { LaboraFisicamente = key }).OrderBy(k => k.LaboraFisicamente).ToList().Select(u => new SelectListItem
            //{
            //    //Text = u.FirstName + " " + u.LastName,
            //    Text = u.LaboraFisicamente,
            //    Value = u.LaboraFisicamente
            //});
             //ViewBag.Areas = (IEnumerable<SelectListItem>)areas;

            var areas = ((from s in db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA" && t.RestringirMenu == null)
                          select s.UbicacionFisica).Distinct().OrderBy(x => x)).ToList();


            ViewBag.Areas = new SelectList(areas);

           
            return View();
        }


        public ActionResult GenerarCredencialesId()
        {

            var nombres = ((from s in db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA" && t.RestringirMenu == null)
                            select s.NombreCompleto).Distinct().OrderBy(x => x)).ToList();


            ViewBag.Areas = new SelectList(nombres);


            return View();
        }
        public ActionResult GenerarGafetes()
        {
          

            var areas = ((from s in db.vwDatosAspirantesTrabajadores.Where(t => t.EstatusTrabajador == "ALTA")
                          select s.UbicacionFisica).Distinct().OrderBy(x => x)).ToList();


            ViewBag.Areas = new SelectList(areas);


            return View();
        }



        public ActionResult ImprimirCredencial(int IdKardex)
        {
            List<Convenios_stConvenioLaboralTrabajadorCategoria> model;

            //List<Kardex_ctDatosPersonales> model = db.Kardex_ctDatosPersonales.Where(s => s.IdKardex == IdKardex).ToList();

            if (Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.UsuarioKardex.FirstOrDefault().EsSuperUsuario)
                model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => q.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex == IdKardex).ToList();
                else
                    model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex==IdKardex).ToList();
            DateTime vigencia = new DateTime(2016, 12, 1);
            int anio = vigencia.Year;

            int anioactual = DateTime.Now.Year;
            int mes = DateTime.Now.Month;

            if (anio < anioactual)
                anioactual = anio;

            int aniofin = anioactual + 6;

            //if (mes>7)
            //    aniofin = aniofin - 1;



            string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            ViewBag.fechavigencia = fechavigencia;



            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 10;
            m.Left = 0;
            m.Right = 0;
            m.Top = 35;


            return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "Credencial_" + IdKardex.ToString() + ".pdf" };





            //DateTime vigencia = new DateTime(2016, 1, 31);
            //int anio = vigencia.Year;

            //int anioactual = DateTime.Now.Year;
            //int mes = DateTime.Now.Month;

            //if (anio < anioactual)
            //    anioactual = anio;

            //int aniofin = anioactual + 3;

            ////if (mes>7)
            ////    aniofin = aniofin - 1;



            //string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            //ViewBag.fechavigencia = fechavigencia;



            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 10;
            //m.Left = 0;
            //m.Right = 0;
            //m.Top = 55;
            //return new ViewAsPdf("ImprimirCredenciales", model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Credencial_" + IdKardex + ".pdf" };

            //  return View(model);
        }


        public ActionResult ImprimirCredencialHtml(int IdKardex)
        {
            List<Convenios_stConvenioLaboralTrabajadorCategoria> model;

            //List<Kardex_ctDatosPersonales> model = db.Kardex_ctDatosPersonales.Where(s => s.IdKardex == IdKardex).ToList();

            model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex == IdKardex).ToList();
            DateTime vigencia = new DateTime(2016, 12, 1);
            int anio = vigencia.Year;

            int anioactual = DateTime.Now.Year;
            int mes = DateTime.Now.Month;

            if (anio < anioactual)
                anioactual = anio;

            int aniofin = anioactual + 6;

            //if (mes>7)
            //    aniofin = aniofin - 1;



            string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            ViewBag.fechavigencia = fechavigencia;



             return View("imprimircredencial",model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 10;
            //m.Left = 0;
            //m.Right = 0;
            //m.Top = 35;


           // return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "Credencial_" + IdKardex.ToString() + ".pdf" };





            //DateTime vigencia = new DateTime(2016, 1, 31);
            //int anio = vigencia.Year;

            //int anioactual = DateTime.Now.Year;
            //int mes = DateTime.Now.Month;

            //if (anio < anioactual)
            //    anioactual = anio;

            //int aniofin = anioactual + 3;

            ////if (mes>7)
            ////    aniofin = aniofin - 1;



            //string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            //ViewBag.fechavigencia = fechavigencia;



            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 10;
            //m.Left = 0;
            //m.Right = 0;
            //m.Top = 55;
            //return new ViewAsPdf("ImprimirCredenciales", model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Credencial_" + IdKardex + ".pdf" };

            //  return View(model);
        }

        public ActionResult ImprimirCredenciales(string labora, bool Esbase)
        {

            List<Convenios_stConvenioLaboralTrabajadorCategoria> model;

         

            if (Esbase)
                model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("BASE") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
            else
                //model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("CONFIANZA") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
            model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral != ("CONTRATO") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
            //List<Kardex_ctDatosPersonales> model = db.Kardex_ctDatosPersonales.Where(s => s.LaboraFisicamente.Contains(labora)).ToList();



            DateTime vigencia = new DateTime(2016, 12, 1);
            int anio = vigencia.Year;

            int anioactual = DateTime.Now.Year;
            int mes = DateTime.Now.Month;

            if (anio < anioactual)
                anioactual = anio;

            int aniofin = anioactual + 6;

            //if (mes>7)
            //    aniofin = aniofin - 1;



            string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            ViewBag.fechavigencia = fechavigencia;



            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 10;
            m.Left = 0;
            m.Right = 0;
            m.Top = 0;


            return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Credenciales_" + labora + ".pdf" };

             //return View(model);
        }

        public ActionResult ImprimirGafetes(string labora )
        {

            List<Convenios_stConvenioLaboralTrabajadorCategoria> model;
            //string AreaLabora = Seguridad.Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;
            int idcltcrealizo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now)&& q.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ProcesoCompletado==true && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
             IEnumerable<int> gafetesimpresos = from h in model
                                  from a in db.Kardex_ctTrabajadorGafetes
                                  where (h.IdConvenioLaboralTrabajadorCategoria == a.IdConvenioLaboralTrabajadorCategoria) &&
                                        (h.IdEstructuraOrganica == a.IdEstructuraOrganica)
                                  select a.IdConvenioLaboralTrabajadorCategoria;
            List<Convenios_stConvenioLaboralTrabajadorCategoria> ListaParaImprimir;
            //model2 = model.Except(gafetesimpresos);
            ListaParaImprimir = model.Where(t => !gafetesimpresos.Contains(t.IdConvenioLaboralTrabajadorCategoria)).ToList();
            //model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica== AreaLabora).ToList();

            var idesestructura = (from a in ListaParaImprimir
                                  select new
                                  {
                                      idcltc = a.IdConvenioLaboralTrabajadorCategoria,
                                      idestructura = a.IdEstructuraOrganica
                                  });
          
            List<Kardex_ctTrabajadorGafetes> listagafetes = new List<Kardex_ctTrabajadorGafetes>();

            TransactionOptions transactionoptions = new TransactionOptions();
            transactionoptions.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions))
            {
                try
                {
                    foreach (var item in idesestructura)
                    {
                        Kardex_ctTrabajadorGafetes kardexgafetes = new Kardex_ctTrabajadorGafetes();

                        kardexgafetes.IdConvenioLaboralTrabajadorCategoria = item.idcltc;
                        kardexgafetes.IdEstructuraOrganica = item.idestructura;
                        kardexgafetes.IdConvenioLaboralTrabajadorCategoriaRealizo = idcltcrealizo;
                        kardexgafetes.Año = DateTime.Now.Year;
                        kardexgafetes.FechaRealizo = DateTime.Now;
                        kardexgafetes.Mes = Convert.ToString(DateTime.Now.Month);
                        listagafetes.Add(kardexgafetes);

                    }

                    db.Kardex_ctTrabajadorGafetes.AddRange(listagafetes);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new {  Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                scope.Complete();
            }
                //Kardex_ctTrabajadorGafetes kardex_cttrabajadorgafetes = new Kardex_ctTrabajadorGafetes();
                //foreach (var item in idesestructura)
                //{

                //    kardex_cttrabajadorgafetes.IdConvenioLaboralTrabajadorCategoria = item.idcltc;


                //}


                //if (Esbase)
                //    model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("BASE") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
                //else
                //    model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("CONFIANZA") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
                ////List<Kardex_ctDatosPersonales> model = db.Kardex_ctDatosPersonales.Where(s => s.LaboraFisicamente.Contains(labora)).ToList();



                DateTime vigencia = new DateTime(2016, 12, 1);
            int anio = vigencia.Year;

            int anioactual = DateTime.Now.Year;
            int mes = DateTime.Now.Month;

            if (anio < anioactual)
                anioactual = anio;

            int aniofin = anioactual + 6;

            //if (mes>7)
            //    aniofin = aniofin - 1;



            string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            ViewBag.fechavigencia = fechavigencia;



            //return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 10;
            m.Left = 0;
            m.Right = 0;
            m.Top = 20;


            return new ViewAsPdf(ListaParaImprimir) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Gafetes_" + labora + ".pdf" };

            //return View(model);
        }

        public ActionResult ImprimirGafeteTrabajador()
        {

            List<Convenios_stConvenioLaboralTrabajadorCategoria> model;
            int idconveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

            //if (Esbase)
            //    model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("BASE") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
            //else
            //    model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("CONFIANZA") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
            ////List<Kardex_ctDatosPersonales> model = db.Kardex_ctDatosPersonales.Where(s => s.LaboraFisicamente.Contains(labora)).ToList();
           
            model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.IdConvenioLaboralTrabajadorCategoria == idconveniolaboraltrabajadorcategoria).ToList();

            DateTime vigencia = new DateTime(2016, 12, 1);
            int anio = vigencia.Year;

            int anioactual = DateTime.Now.Year;
            int mes = DateTime.Now.Month;

            if (anio < anioactual)
                anioactual = anio;

            int aniofin = anioactual + 6;

            //if (mes>7)
            //    aniofin = aniofin - 1;



            string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            ViewBag.fechavigencia = fechavigencia;



            //return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 10;
            m.Left = 0;
            m.Right = 0;
            m.Top = 30;


            return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Portrait, PageMargins = m, FileName = "Gafete" + idconveniolaboraltrabajadorcategoria + ".pdf" };

            //return View(model);
        }



        public ActionResult ImprimirCredencialesReverso(string labora, bool Esbase)
        {
             List<Convenios_stConvenioLaboralTrabajadorCategoria> model;
             if (Esbase)
                 model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("BASE") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
             else
                 model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("CONFIANZA") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
            
                  //List<Kardex_ctDatosPersonales> model = db.Kardex_ctDatosPersonales.Where(s => s.LaboraFisicamente.Contains(labora)).ToList();



            DateTime vigencia = new DateTime(2016, 12, 1);
            int anio = vigencia.Year;

            int anioactual = DateTime.Now.Year;
            int mes = DateTime.Now.Month;

            if (anio < anioactual)
                anioactual = anio;

            int aniofin = anioactual + 6;

            //if (mes>7)
            //    aniofin = aniofin - 1;



            string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            ViewBag.fechavigencia = fechavigencia;



            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 10;
            return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "CredencialesReverso_" + labora + ".pdf" };
            // return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m};
            //  return View(model);
        }


        public ActionResult ImprimirGafetesReverso(string labora, bool Esbase)
        {
            List<Convenios_stConvenioLaboralTrabajadorCategoria> model;
            if (Esbase)
                model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("BASE") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();
            else
                model = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(q => (q.FechaTermino == null || q.FechaTermino >= DateTime.Now) && q.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == ("CONFIANZA") && q.Catalogos_ctEstructuraOrganica.EstructuraOrganica.Contains(labora)).ToList();

            //List<Kardex_ctDatosPersonales> model = db.Kardex_ctDatosPersonales.Where(s => s.LaboraFisicamente.Contains(labora)).ToList();



            DateTime vigencia = new DateTime(2016, 12, 1);
            int anio = vigencia.Year;

            int anioactual = DateTime.Now.Year;
            int mes = DateTime.Now.Month;

            if (anio < anioactual)
                anioactual = anio;

            int aniofin = anioactual + 6;

            //if (mes>7)
            //    aniofin = aniofin - 1;



            string fechavigencia = anioactual.ToString() + " - " + aniofin.ToString();
            ViewBag.fechavigencia = fechavigencia;



            // return View(model);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 0;
            m.Right = 0;
            m.Top = 10;
            return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = "CredencialesReverso_" + labora + ".pdf" };
            // return new ViewAsPdf(model) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m};
            //  return View(model);
        }





    }


    public class UploadControlDemosHelper
    {

        public const string UploadDirectory = "/Content/UploadControl/UploadFolder/";

        public static readonly DevExpress.Web.UploadControlValidationSettings UploadControlValidationSettings = new DevExpress.Web.UploadControlValidationSettings
        {
            AllowedFileExtensions = new string[] { ".jpg", ".jpeg", ".jpe", ".gif", ".bmp", },
            MaxFileSize = 20971520,
        };



        public static void uc_FileUploadComplete(object sender, DevExpress.Web.FileUploadCompleteEventArgs e)
        {
            if (e.UploadedFile.IsValid)
            {
                string resultFilePath = HttpContext.Current.Request.MapPath(UploadDirectory + e.UploadedFile.FileName);
                e.UploadedFile.SaveAs(resultFilePath, true);//Code Central Mode - Uncomment This Line
                IUrlResolutionService urlResolver = sender as IUrlResolutionService;
                if (urlResolver != null)
                {
                    //e.CallbackData = urlResolver.ResolveClientUrl(UploadDirectory + e.UploadedFile.FileName);
                    e.CallbackData = String.Format(HttpContext.Current.Request.IsSecureConnection ? "https://{0}{1}{2}" : "http://{0}{1}{2}", HttpContext.Current.Request.Url.Host, (HttpContext.Current.Request.Url.IsDefaultPort ? "" : ":" + HttpContext.Current.Request.Url.Port), UploadDirectory + e.UploadedFile.FileName);
                }
            }
        }


    }
}