﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using DevExpress.Web;
using DevExpress.Web.Mvc;
using System.Web.UI;

namespace Nova.Controllers.Kardex
{
    public class DatosFamiliaresController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        //
        // GET: /DatosFamiliares/

        public ActionResult Index()
        {
            var kardex_stdatosfamiliares = db.Kardex_stDatosFamiliares.Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_ctParentesco);
            return View(kardex_stdatosfamiliares.ToList());
        }

        //
        // GET: /DatosFamiliares/Details/5

        public ActionResult Details(int id = 0)
        {
            Kardex_stDatosFamiliares kardex_stdatosfamiliares = db.Kardex_stDatosFamiliares.Find(id);
            if (kardex_stdatosfamiliares == null)
            {
                return HttpNotFound();
            }
            return View(kardex_stdatosfamiliares);
        }

        //
        // GET: /DatosFamiliares/Create

        //public ActionResult Create(int IdKardex,  string email, string check)
        //{
        //    ViewBag.Id = IdKardex;
        //    ViewBag.email = email;
        //    ViewBag.check = check;

        //    if (Kardex_ctDatosPersonales.getProcesoCompletado(IdKardex) == true)
        //    {
        //        return View("terminado");
        //    }
        //    else
        //    {
        //        string codificado = Cifrado.Encrypt(email + IdKardex.ToString());

        //        if (HttpUtility.HtmlDecode(check) == codificado)
        //        {
        //            Kardex_stDatosFamiliares kd = new Kardex_stDatosFamiliares();

        //            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");
        //            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco");


        //            return View(kd);
        //        }
        //        else
        //            return View("NoAutorizado");
        //    }
        //}

        public ActionResult Create(int IdKardex)
        {
            ViewBag.Id = IdKardex;




            Kardex_stDatosFamiliares kd = new Kardex_stDatosFamiliares();
            kd.FechaNacimiento = DateTime.Now;
            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");
            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco");


            return View(kd);


        }

        public ActionResult Agregar()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex; ;
            ViewBag.Id = IdKardex;





            Kardex_stDatosFamiliares kd = new Kardex_stDatosFamiliares();

            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");
            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco");
            kd.FechaNacimiento = DateTime.Now;

            return View("Agregar", kd);


        }
        ////
        // POST: /DatosFamiliares/Create



        [HttpPost]
        public ActionResult Create(Kardex_stDatosFamiliares kardex_stdatosfamiliares)
        {
            int ide = ConvertToInt.ConvertToInt32(Request["Id"]);
            ViewBag.Id = ide;
            ViewBag.email = Request["email"];
            ViewBag.check = Request["check"];

            ViewBag.IdLocalidadDomicilioText = "";

            if (Request["IdLocalidadDomicilioText "] != "")

                ViewBag.IdLocalidadDomicilioText = Request["IdLocalidadDomicilioText "];

            if (kardex_stdatosfamiliares.ValidaModelo().IsValid)
            {


                if (ModelState.IsValid)
                {
                    db.Kardex_stDatosFamiliares.Add(kardex_stdatosfamiliares);
                    db.SaveChanges();

                    return RedirectToAction("EditSucces", new { idKardex = ide, email = Request["email"], check = Request["check"] });
                }
            }
            else
                MessageBox.Show(ViewData, TipoMensaje.Warning, kardex_stdatosfamiliares.ValidaModelo().Mensaje);
            //else
            //{
            //    MessageBox.Show(ViewData, TipoMensaje.Error, ModelState.Values.SelectMany(v => v.Errors).ToString());
            //}

            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_stdatosfamiliares.IdKardex);
            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco", kardex_stdatosfamiliares.IdParentesco);
            return View(kardex_stdatosfamiliares);
        }


        [HttpPost]
        public ActionResult Agregar(Kardex_stDatosFamiliares kardex_stdatosfamiliares)
        {
            int ide = ConvertToInt.ConvertToInt32(Request["Id"]);
            ViewBag.Id = ide;
            ViewBag.email = Request["email"];
            ViewBag.check = Request["check"];

            kardex_stdatosfamiliares.IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

            ViewBag.IdLocalidadDomicilioText = "";

            if (Request["IdLocalidadDomicilioText "] != "")

                ViewBag.IdLocalidadDomicilioText = Request["IdLocalidadDomicilioText "];

            if (kardex_stdatosfamiliares.ValidaModelo().IsValid)
            {


                if (ModelState.IsValid)
                {
                    db.Kardex_stDatosFamiliares.Add(kardex_stdatosfamiliares);
                    db.SaveChanges();

                    return RedirectToAction("Perfil");
                }
            }
            else
                MessageBox.Show(ViewData, TipoMensaje.Warning, kardex_stdatosfamiliares.ValidaModelo().Mensaje);
            //else
            //{
            //    MessageBox.Show(ViewData, TipoMensaje.Error, ModelState.Values.SelectMany(v => v.Errors).ToString());
            //}

            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_stdatosfamiliares.IdKardex);
            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco", kardex_stdatosfamiliares.IdParentesco);
            return View("Agregar", kardex_stdatosfamiliares);
        }

        //
        // GET: /DatosFamiliares/Edit/5

        //public ActionResult Edit(int id ,string email,string check)

        //{
        //     ViewBag.Id = id;
        //    ViewBag.email = email;
        //    ViewBag.check = check;

        //    if (Kardex_ctDatosPersonales.getProcesoCompletado(id) == true)
        //    {
        //        return View("terminado");
        //    }
        //    else
        //    {
        //        string codificado = Cifrado.Encrypt(email + id.ToString());

        //        if (HttpUtility.HtmlDecode(check) == codificado)
        //        {


        //            List<Kardex_stDatosFamiliares> x = db.Kardex_ctDatosPersonales.Find(id).Kardex_stDatosFamiliares.ToList();
        //            if (x.Count ==0)
        //            {
        //                //return HttpNotFound();
        //                return RedirectToAction("Create", new { IdKardex = id, email = email, check = check });
        //            }
        //            else
        //            {

        //                ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP",id);
        //                ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco");
        //                //   return View(kardex_stdatosfamiliares);
        //                return RedirectToAction("EditSucces", new { idKardex = id, email = email, check = check });
        //            }

        //        }
        //        else
        //            return View("NoAutorizado");
        //    }

        //}

        public ActionResult Perfil()
        {
            ViewBag.Id = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex; ;


            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");



            //List<Kardex_stDatosFamiliares> x = db.Kardex_ctDatosPersonales.Find(id).Kardex_stDatosFamiliares.ToList();
            //if (x.Count == 0)
            //{
            //    //return HttpNotFound();
            //    return RedirectToAction("Create", new { IdKardex = id });
            //}
            //else
            //{

            //    ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", id);
            //    ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco");
            //    //   return View(kardex_stdatosfamiliares);
            //    return RedirectToAction("EditSucces", new { idKardex = id});
            int idkardeusuario = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Kardex_stDatosFamiliares model = db.Kardex_stDatosFamiliares.Where(r => r.IdKardex == idkardeusuario).FirstOrDefault();
            if (model != null)
            {
                ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco", model.IdParentesco);
                ViewBag.IdParent = model.IdParentesco;
                ViewBag.IdLocalidadDomicilioText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(model.IdEstadoDomicilio, model.IdMunicipioDomicilio, model.IdLocalidadDomicilio);
            }
            else
            {
                ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco", 0);
                ViewBag.IdParent = 0;
                ViewBag.IdLocalidadDomicilioText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(0, 0, 0);
            }
            ViewBag.IdKardex = idkardeusuario;
            
            // ViewBag.Id = model.IdKardex;

           



            return View("EditPerfil", model);



        }

        public ActionResult EditPerfil(int id, int IdKardex)
        {
            ViewBag.Id = id;


            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");



            //List<Kardex_stDatosFamiliares> x = db.Kardex_ctDatosPersonales.Find(id).Kardex_stDatosFamiliares.ToList();
            //if (x.Count == 0)
            //{
            //    //return HttpNotFound();
            //    return RedirectToAction("Create", new { IdKardex = id });
            //}
            //else
            //{

            //    ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", id);
            //    ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco");
            //    //   return View(kardex_stdatosfamiliares);
            //    return RedirectToAction("EditSucces", new { idKardex = id});
            Kardex_stDatosFamiliares model = db.Kardex_stDatosFamiliares.Where(r => r.IdKardex == IdKardex && r.IdKardexFamiliares == id).FirstOrDefault();

            if (model == null)
            {
                return HttpNotFound();
            }

            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco", model.IdParentesco);
            ViewBag.IdParent = model.IdParentesco;

            ViewBag.IdKardex = model.IdKardex;
            ViewBag.Id = model.IdKardex;

            ViewBag.IdLocalidadDomicilioText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(model.IdEstadoDomicilio, model.IdMunicipioDomicilio, model.IdLocalidadDomicilio);



            return View("EditPerfil", model);



        }

       
        [HttpPost]
        public ActionResult EditPerfil(Kardex_stDatosFamiliares kardex_stdatosfamiliares)
        {
            if (ModelState.IsValid)
            {
                db.Entry(kardex_stdatosfamiliares).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Perfil");

            }
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_stdatosfamiliares.IdKardex);
            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco", kardex_stdatosfamiliares.IdParentesco);
            ViewBag.IdKardex = kardex_stdatosfamiliares.IdKardex;
            ViewBag.Id = kardex_stdatosfamiliares.IdKardex;
            ViewBag.IdLocalidadDomicilioText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_stdatosfamiliares.IdEstadoDomicilio, kardex_stdatosfamiliares.IdMunicipioDomicilio, kardex_stdatosfamiliares.IdLocalidadDomicilio);

            ViewBag.IdParent = kardex_stdatosfamiliares.IdParentesco;

            return View(kardex_stdatosfamiliares);
        }
        //
        // GET: /DatosFamiliares/Delete/5

        //public ActionResult Delete(int id , int idkardex ,string email, string check)
        //{
        //     ViewBag.Id = id;
        //    ViewBag.email = email;
        //    ViewBag.check = check;

        //    if (Kardex_ctDatosPersonales.getProcesoCompletado(id) == true)
        //    {
        //        return View("terminado");
        //    }
        //    else
        //    {
        //        string codificado = Cifrado.Encrypt(email + idkardex.ToString());

        //        if (HttpUtility.HtmlDecode(check) == codificado)
        //        {
        //            Kardex_stDatosFamiliares kardex_stdatosfamiliares = db.Kardex_stDatosFamiliares.Find(id);
        //            if (kardex_stdatosfamiliares == null)
        //            {
        //                return HttpNotFound();
        //            }
        //            return View(kardex_stdatosfamiliares);
        //        }
        //        else
        //            return View("NoAutorizado");
        //    }
        //}

        //
        // POST: /DatosFamiliares/Delete/5

        [HttpGet, ActionName("Delete")]
        public ActionResult Delete(int id, int IdKardex)
        {
            Kardex_stDatosFamiliares kardex_stdatosfamiliares = db.Kardex_stDatosFamiliares.Where(f => f.IdKardexFamiliares == id && f.IdKardex == IdKardex).FirstOrDefault();
            if (kardex_stdatosfamiliares == null)
            {
                return HttpNotFound();
            }

            db.Kardex_stDatosFamiliares.Remove(kardex_stdatosfamiliares);
            db.SaveChanges();
            //return RedirectToAction("EditSucces", new { idKardex = kardex_stdatosfamiliares.IdKardex, email = Request["email"], check = Request["check"] });
            return RedirectToAction("Perfil");
            //return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }

        public ActionResult GridViewPartial(int idKardex)
        {

            ViewData["idKardex"] = idKardex;

            return PartialView("_pvGridDatosFamiliares");
        }

        public ActionResult EditSucces(int idKardex, string isPost = null)
        {
            if (isPost != null)
                MessageBox.Show(ViewData, TipoMensaje.Success, "Registro Grabado con éxito ");

            ViewData["idKardex"] = idKardex;
            ViewBag.Id = idKardex;

            return View("EditSucces");
        }

        public ActionResult Edit(int id, int IdKardex)
        {
            ViewBag.Id = id;


            ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP");



            //List<Kardex_stDatosFamiliares> x = db.Kardex_ctDatosPersonales.Find(id).Kardex_stDatosFamiliares.ToList();
            //if (x.Count == 0)
            //{
            //    //return HttpNotFound();
            //    return RedirectToAction("Create", new { IdKardex = id });
            //}
            //else
            //{

            //    ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", id);
            //    ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco");
            //    //   return View(kardex_stdatosfamiliares);
            //    return RedirectToAction("EditSucces", new { idKardex = id});
            Kardex_stDatosFamiliares model = db.Kardex_stDatosFamiliares.Where(r => r.IdKardex == IdKardex && r.IdKardexFamiliares == id).FirstOrDefault();

            if (model == null)
            {
                return HttpNotFound();
            }

            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco", model.IdParentesco);
            ViewBag.IdParent = model.IdParentesco;

            ViewBag.IdKardex = model.IdKardex;
            ViewBag.Id = model.IdKardex;

            ViewBag.IdLocalidadDomicilioText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(model.IdEstadoDomicilio, model.IdMunicipioDomicilio, model.IdLocalidadDomicilio);



            return View(model);



        }

        [HttpPost]
        public ActionResult Edit(Kardex_stDatosFamiliares kardex_stdatosfamiliares)
        {
            if (ModelState.IsValid)
            {
                db.Entry(kardex_stdatosfamiliares).State = System.Data.Entity.EntityState.Modified;

                //SendPushNotification(" Editó la información de datos familiares " + kardex_stdatosfamiliares.Nombre + " " + kardex_stdatosfamiliares.ApellidoPaterno, TypePushNotification.success, "Nómina");

                db.SaveChanges();
                return RedirectToAction("Perfil", new { IdKardex = kardex_stdatosfamiliares.IdKardex });

            }
            //ViewBag.IdKardex = new SelectList(db.Kardex_ctDatosPersonales, "IdKardex", "CURP", kardex_stdatosfamiliares.IdKardex);
            ViewBag.IdParentesco = new SelectList(db.Kardex_ctParentesco, "IdParentesco", "Parentesco", kardex_stdatosfamiliares.IdParentesco);
            ViewBag.IdKardex = kardex_stdatosfamiliares.IdKardex;
            ViewBag.Id = kardex_stdatosfamiliares.IdKardex;
            ViewBag.IdLocalidadDomicilioText = Kardex_ctDatosPersonales.getLocalidadMunicipioEstado(kardex_stdatosfamiliares.IdEstadoDomicilio, kardex_stdatosfamiliares.IdMunicipioDomicilio, kardex_stdatosfamiliares.IdLocalidadDomicilio);

            ViewBag.IdParent = kardex_stdatosfamiliares.IdParentesco;

            return View(kardex_stdatosfamiliares);
        }




    }
}