﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Kardex
{
    public class AsignarCorreoOficialController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: AsignarCorreoOficial
        public ActionResult Index(int IdConvenioLaboralTrabajadorCategoria = 0)
        {
            Convenios_stConvenioLaboralTrabajadorCategoria convenio = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(IdConvenioLaboralTrabajadorCategoria);
            Kardex_ctTrabajador kardex_stTrabajador = db.Kardex_ctTrabajador.Find(convenio.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador);

            return View(kardex_stTrabajador);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Index([Bind(Include = "IdTrabajador,IdKardex,FechaAsignacion,CorreoOficial")] Kardex_ctTrabajador kardex_ctTrabajador)
        {



            bool valid = false;
            if (ModelState.IsValid)
            {
                try
                {
                    db.Entry(kardex_ctTrabajador).State = EntityState.Modified;
                    db.SaveChanges();
                    valid = true;

                }
                catch (Exception e)
                {
                    return HttpNotFound();
                }

            }

            Kardex_ctTrabajador kardex_ctTrabajador2 = db.Kardex_ctTrabajador.Find(kardex_ctTrabajador.IdTrabajador);


            if (valid)
            {
                int idConvenioCategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Convenios_stConvenioLaboralTrabajador.IdTrabajador == kardex_ctTrabajador2.IdTrabajador).Select(s => s.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                return RedirectToAction("Index", new { IdConvenioLaboralTrabajadorCategoria = idConvenioCategoria });
            }
            else
            {
                kardex_ctTrabajador2.CorreoOficial = kardex_ctTrabajador.CorreoOficial;
            }

            var errorList = ModelState.Values.SelectMany(v => v.Errors).Select(v => v.ErrorMessage + " " + v.Exception).ToList();
            foreach (var er in errorList)
            {
                ModelState.AddModelError(string.Empty, er.ToString());
            }



            return View(kardex_ctTrabajador2);
        }

    }
}