﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Transactions;
using Seguridad;
using System.Net.Mail;


namespace Nova.Controllers
{
    public class JustificarFaltasController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdIncidenciaTrabajador, b.IdConvenioLaboralTrabajadorCategoria, b.IdTrabajador, b.RelacionLaboral, b.Nombre, b.ApellidoPaterno,b.ApellidoMaterno, a.FechaTermino as FechaFalta, c.IncidenciaJustificacion
                        , a.DescripcionJustificacion , a.IdConvenioLaboralTrabajadorCategoriaJustifico,(select nombre +' '+ ApellidoPaterno + ' ' + ApellidoMaterno from vwDatosAspirantesTrabajadores Where IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoriaJustifico) as Justifico, a.FechaJustificacion,b.UbicacionFisica

                        from IncidenciaPermiso_stIncidenciaTrabajador a
                        inner join vwDatosAspirantesTrabajadores b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
                        inner join Incidencia_ctJustificacion c on a.IdIncidenciaJustificacion = c.IdIncidenciaJustificacion";
            
        // GET: JustificarFaltas
        public ActionResult Index()
        {
                string EstructuraUsuario = Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;
                int Ide = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                
                var result = (List<JustificarFaltas>)dp.connection.Query<JustificarFaltas>(query);
                var lista_result = result.Where(y => y.UbicacionFisica == EstructuraUsuario).OrderByDescending(x=> x.IdConvenioLaboralTrabajadorCategoria).OrderByDescending(z=> z.FechaFalta).ToList();
                ViewBag.EstructuraUsuario = EstructuraUsuario;
                dp.Close();
                return View(lista_result.ToList());
        }


        public ActionResult IndexAdmin()
        {
            
            string EstructuraUsuario = Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;
           
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
        
            ViewBag.EstructuraUsuario = " ";

            var result = (List<JustificarFaltas>)dp.connection.Query<JustificarFaltas>(query);
            
            dp.Close();

            return View(result.ToList());
        }


        // GET: JustificarFaltas/Details/5
        public ActionResult Details(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // GET: JustificarFaltas/Create
        public ActionResult Create()
        {
            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia");
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
            return View();
        }

        // POST: JustificarFaltas/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdIncidenciaTrabajador,IdConvenioLaboralTrabajadorCategoria,IdTipoIncidencia,FechaInicio,FechaTermino,Observaciones,UserId,FechaCreacion,IdNominaTrabajador,EsAplicada,EsSubsecuente,DiasPagados100,DiasPagados40,DiasAcumulados,IdIncidenciaTrabajadorPadre,IdConvenioLaboralTrabajadorCategoriaRegistro,Autorizo,IdConvenioLaboralTrabajadorCategoriaAutorizo,IdIncidenciaJustificacion,QuincenasCalculadas,PercepcionDiaria,Horas")] IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador)
        {
            if (ModelState.IsValid)
            {
                db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo);
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador", incidenciaPermiso_stIncidenciaTrabajador.IdNominaTrabajador);
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // GET: JustificarFaltas/Edit/5
        public ActionResult Edit(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo);
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador", incidenciaPermiso_stIncidenciaTrabajador.IdNominaTrabajador);
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: JustificarFaltas/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdIncidenciaTrabajador,IdConvenioLaboralTrabajadorCategoria,IdTipoIncidencia,FechaInicio,FechaTermino,Observaciones,UserId,FechaCreacion,IdNominaTrabajador,EsAplicada,EsSubsecuente,DiasPagados100,DiasPagados40,DiasAcumulados,IdIncidenciaTrabajadorPadre,IdConvenioLaboralTrabajadorCategoriaRegistro,Autorizo,IdConvenioLaboralTrabajadorCategoriaAutorizo,IdIncidenciaJustificacion,QuincenasCalculadas,PercepcionDiaria,Horas")] IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador)
        {
            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo);
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador", incidenciaPermiso_stIncidenciaTrabajador.IdNominaTrabajador);
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // GET: JustificarFaltas/Delete/5
        public ActionResult Delete(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: JustificarFaltas/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(long id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }


        public ActionResult Justificacion(int idjustificar, int idconveniolaboraltrabajadorcategoria)
        {

            IncidenciaPermiso_stIncidenciaTrabajador model = new IncidenciaPermiso_stIncidenciaTrabajador();
            int Ide = Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");

            model.IdIncidenciaTrabajador = idjustificar;
            model.IdConvenioLaboralTrabajadorCategoria = idconveniolaboraltrabajadorcategoria;
            return PartialView("_Justificar", model);
        }


        public ActionResult Justificar(int IdIncidenciaTrabajador, int IdConvenioLaboralTrabajadorCategoria,IncidenciaPermiso_stIncidenciaTrabajador incidenciatrabajador)
        {

            

            if (ModelState.IsValid)
            {
                int IdeCLTC = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(IdIncidenciaTrabajador);

                DateTime FechaFalta = incidenciaPermiso_stIncidenciaTrabajador.FechaInicio;
                //string fechas = Request.Form["fechas"];
                ////int dia = DateTime.Now.Day;
                //string[] fechas2 = fechas.Split(',');
               
                try
                {
                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        
                            if (incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion == 0)
                            {

                            incidenciaPermiso_stIncidenciaTrabajador.DescripcionJustificacion = System.Convert.ToString(Request["DescripcionJustificacion"]);
                            incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = System.Convert.ToInt32(Request["IdIncidenciaJustificacion"]);
                            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = IdeCLTC;
                            incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = DateTime.Now;
                            db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                            db.SaveChanges();

                            //if (FechaFalta.Day > 1 && FechaFalta.Day <= 15)
                            //    {

                            //        if (DateTime.Now.Day >= 16 || DateTime.Now.Day <= 31)
                            //        {


                            //            incidenciaPermiso_stIncidenciaTrabajador.DescripcionJustificacion = System.Convert.ToString(Request["DescripcionJustificacion"]);
                            //            incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = System.Convert.ToInt32(Request["IdIncidenciaJustificacion"]);
                            //            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = IdeCLTC;
                            //            incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = DateTime.Now;
                            //            db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                            //            db.SaveChanges();
                            //        }
                            //        else
                            //        {
                            //            return Json(new { Valid = false, Message = "No se puede justificar las faltas ya que el periodo de justificación de la primera quincena es del 16 al 31 de cada mes" });

                            //        }
                            //    }
                                //else
                                //{
                                //    if (DateTime.Now.Day >= 1 && DateTime.Now.Day <= 15)
                                //    {

                                //        incidenciaPermiso_stIncidenciaTrabajador.DescripcionJustificacion = System.Convert.ToString(Request["DescripcionJustificacion"]);
                                //        incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = System.Convert.ToInt32(Request["IdIncidenciaJustificacion"]);
                                //        incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = IdeCLTC;
                                //        incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = DateTime.Now;
                                //        db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                                //        db.SaveChanges();
                                //    }
                                //    else
                                //    {
                                //        return Json(new { Valid = false, Message = "No se puede justificar las faltas ya que el periodo de justificación de la segunda quincena es del 1 al 15 del proximo mes" });

                                //    }
                                //}
                            }
                            else
                            {
                                return Json(new { Valid = false, Message = "Esta incidencia ya fue justificada" });
                            }
                            
                        
                     
                        
                        





                        trans.Complete();

                        
                    }
                    int idConvenioTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(a => a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).Select(b => b.IdConvenioLaboralTrabajador).FirstOrDefault();
                    string CorreoUsuario = db.Kardex_ctTrabajador.Include(t => t.Kardex_ctDatosPersonales).Where(t => t.IdTrabajador == idConvenioTrabajador).Select(t => t.Kardex_ctDatosPersonales.CorreoElectronico).FirstOrDefault();

                   


                    List<IncidenciaPermiso_stIncidenciaTrabajador> listFechas = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(i => i.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && i.IdIncidenciaJustificacion > 0 && i.FechaJustificacion.Value.Year == DateTime.Now.Year && i.FechaJustificacion.Value.Month == DateTime.Now.Month && i.FechaJustificacion.Value.Day == DateTime.Now.Day).ToList();


                    SendCorreoElectronico(CorreoUsuario, listFechas);
                    //SendCorreoElectronico("nenelito61@gmail.com", listFechas);
                }
                catch (Exception e)
                {

                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }



                return Json(new { Valid = true, Message = "Las falta/s han sido justificadas exitosamente" });

            }


            return new JsonResult() { Data = "Las falta/s han sido justificadas exitosamente" };
        }







        public void SendCorreoElectronico(string corretoTo, List<IncidenciaPermiso_stIncidenciaTrabajador> justificaciones)
        {

            string templateIncidencias = @"<br/><h3> Fechas  de  faltas justificadas </h3> <br/>";

            foreach (var item in justificaciones)
            {
                templateIncidencias = templateIncidencias + @"<a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: bold; font-family:Arial, sans-serif '> " + "  " + item.FechaInicio.ToShortDateString() + "  " + @" </a><br/>";
            }



            MailMessage msg = new MailMessage();
            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            string correoprestamo = corretoTo;
            //item.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.CorreoElectronico;
            //string tituloprestamo = "Retraso en manejo de información";
            msg.To.Add(correoprestamo);
            //msg.To.Add("aflores@cecyteo.edu.mx");
            //msg.To.Add("pzafra@cecyteo.edu.mx");

            msg.Subject = "Sistema NOVA";
            msg.IsBodyHtml = true;
            string cuerpo = @"<!doctype html>
                                                        <html xmlns='http://www.w3.org/1999/xhtml'>
                                                        <head>

                                                        <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />

                                                        <title>Faltas</title>

                                                        <style type='text/css'>
	                                                        .ReadMsgBody {width: 100%; background-color: #ffffff;}
	                                                        .ExternalClass {width: 100%; background-color: #ffffff;}
	                                                        body	 {width: 100%; background-color: #ffffff; margin:0; padding:0; -webkit-font-smoothing: antialiased;font-family: Helvetica, Georgia, Times, serif}
	                                                        table {border-collapse: collapse;}

	                                                        @media only screen and (max-width: 640px)  {
					                                                        body[yahoo] .deviceWidth {width:440px!important; padding:0;}
					                                                        body[yahoo] .center {text-align: center!important;}
			                                                        }

	                                                        @media only screen and (max-width: 479px) {
					                                                        body[yahoo] .deviceWidth {width:280px!important; padding:0;}
					                                                        body[yahoo] .center {text-align: center!important;}
			                                                        }

                                                        </style>
                                                        </head>

                                                        <body leftmargin='0' topmargin='0' marginwidth='0' marginheight='0' yahoo='fix' style='font-family: Helvetica, Georgia, Times, serif'>

                                                        <!-- Wrapper -->
                                                        <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
	                                                        <tr>
		                                                        <td width='100%' valign='top' bgcolor='#ffffff' style='padding-top:20px'>

			                                                        <!-- Start Header-->
			                                                        <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
				                                                        <tr>
					                                                        <td width='100%' bgcolor='#ffffff'>

                                                                                    <!-- Logo -->
                                                                                    <table border='0' cellpadding='0' cellspacing='0' align='left' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td style='padding:10px 20px' class='center'>
                                                                                                <a href='#'><img src='http://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table><!-- End Logo -->

                                                                                    <!-- Nav -->
                                                                                    <table border='0' cellpadding='0' cellspacing='0' align='right' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td class='center' style='font-size: 13px; color: #272727; font-weight: light; text-align: right; font-family: Helvetica, Georgia, Times, serif; line-height: 20px; vertical-align: middle; padding:10px 20px; font-style:italic'>
                                         
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table><!-- End Nav -->

					                                                        </td>
				                                                        </tr>
			                                                        </table><!-- End Header -->

		


                                                        <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


                                                                    <!-- 2 Column Images & Text Side by SIde -->
                                                                    <table width='580' border='0' cellpadding='0' cellspacing='0' align='center' class='deviceWidth' bgcolor='#4D5B69' style='margin:0 auto;'>
                                                                        <tr>
                                                                            <td style='padding:10px 0'>
                                                                                    <table align='left' width='29%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td valign='top' align='center' class='center' style='padding-top:20px;color:#fff;' >
                                                                                                 <h1 style='text-align:center;' >Sistema NOVA</h1>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table>
                                                                                    <table align='right' width='69%' cellpadding='0' cellspacing='0' border='0' class='deviceWidth'>
                                                                                        <tr>
                                                                                            <td style='font-size: 12px; color: #959595; font-weight: normal; text-align: left; font-family: Helvetica, Georgia, Times, serif; line-height: 24px; vertical-align: top; padding:10px 8px 10px 8px'>

                                                                                                <table>
                                                                                                    <tr>
                                                                                                        <td valign='top' style='padding:0 10px 10px 5px;color:#fff;'>
                                                    
                                                                                                        </td>
                                                                                                        <td valign='middle' style='padding:0 10px 10px 0'>
                                                                                                        <a href='#' style='text-decoration: none; font-size: 16px; color: #ccc; font-weight: normal; font-family:Arial, sans-serif '>Estimado usuario: Se le avisa del reporte de sus faltas justificadas para su conocimiento.</a>
                                                                                                        <br />            
                                                                                                                        " + "  " + templateIncidencias + "  " + @"                                                                            
                                                                                                        
                                                                                                        <br />                                                                                                   
                                                                                                        <a href='#' style='text-decoration: none; font-size: 10px; color: #ccc; font-weight: normal; font-family:Arial, sans-serif '>" + " Si existe alguna inconsistencia reportarla al area de Recursos Humanos" + " " + @" </a>
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                                                                                                <p style='mso-table-lspace:0;mso-table-rspace:0; margin:0'>
                                             
                                                                                                    <br/><br/>

                                            

                                                                                                </p>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </table>

                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td bgcolor='#fe7f00'><div style='height:6px'>&nbsp;</div></td>
                                                                        </tr>
                                                                    </table><!-- End 2 Column Images & Text Side by SIde -->


                                                        <div style='height:15px;margin:0 auto;'>&nbsp;</div><!-- spacer -->
			                                                        <!-- Two Column (Images Stacked over Text) -->
			 
 
       
 

                                                        <div style='height:35px;margin:0 auto;'>&nbsp;</div><!-- spacer -->


			                                                        <!-- 4 Columns -->
			                                                        <table width='100%' border='0' cellpadding='0' cellspacing='0' align='center'>
				                                                        <tr>
					                                                        <td bgcolor='#14B9D6' style='padding:30px 0'>
                                                                                <table width='580' border='0' cellpadding='10' cellspacing='0' align='center' class='deviceWidth' style='margin:0 auto;'>
                                                                                    <tr>
                                                                                        <td>
                                                                                                <table width='45%' cellpadding='0' cellspacing='0'  border='0' align='left' class='deviceWidth'>
                                                                                                    <tr>
                                                                                                        <td valign='top' style='font-size: 11px; color: #4D5B69; color:#4D5B69; font-family: Arial, sans-serif; padding-bottom:20px' class='center'>

                                                                                                           Departamento de Sistemas, Redes y Soporte Técnico | 
                                                                                                            <a href='www.cecyteo.edu.mx/nova' style='color:#4D5B69;text-decoration:none;'>NOVA - " + DateTime.Now.Year + @"</a><br/>

                                                                                                            <br/><br/>
                                                   

                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                                                                                                <table width='40%' cellpadding='0' cellspacing='0'  border='0' align='right' class='deviceWidth'>
                                                                                                    <tr>
                                                                                                        <td valign='top' style='font-size: 11px; color: #4D5B69; font-weight: normal; font-family: Helvetica, Georgia, Times, serif; line-height: 26px; vertical-align: top; text-align:right' class='center'>
                                                                                                             Todos los Derechos Reservados - Cecyteo  

                                                                                                            <a href='#'><img src='http://www.cecyteo.edu.mx/Nova/app_themes/Nova2015/img/logocecyte.png' alt='' border='0' /></a>

                                                   
                                                                                                        </td>
                                                                                                    </tr>
                                                                                                </table>

                        		                                                        </td>
                        	                                                        </tr>
                                                                                </table>
                                                                            </td>
                                                                        </tr>
                                                                    </table><!-- End 4 Columns -->

		                                                        </td>
	                                                        </tr>
                                                        </table> <!-- End Wrapper -->
                                                        <div style='display:none; white-space:nowrap; font:15px courier; color:#ffffff;'>
                                                        - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
                                                        </div>
                                                        </body>
                                                        </html>";

            msg.Body = cuerpo;
            //msg.Body = "Favor de pasar a entregar la pelicula:" +  " " + tituloprestamo + " "+ "ya que el tiempo del prestamo ha vencido";
            SmtpClient client = new SmtpClient();

            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false; 
            client.Send(msg);
            //Cinedebates_stPrestamos prestamo = db.Cinedebates_stPrestamos.Where(b => b.FechaEntrega == null && b.Notificacion == false && b.IdPrestamo == item.IdPrestamo).FirstOrDefault();
            //prestamo.Notificacion = true;
            //db.Entry(prestamo).State = System.Data.Entity.EntityState.Modified;
            //db.SaveChanges();
        }


            

    }





}
