﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class InstitucionFinancieraController : Controller
    {
        //
        // GET: /InstitucionFinanciera/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvInstitucionFinanciera()
        {
            var model = db.Catalogos_ctInstitucionFinanciera;
            return PartialView("_pvInstitucionFinanciera", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvInstitucionFinancieraAddNew(Nova.Models.Catalogos_ctInstitucionFinanciera item)
        {
            var model = db.Catalogos_ctInstitucionFinanciera;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvInstitucionFinanciera", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvInstitucionFinancieraUpdate(Nova.Models.Catalogos_ctInstitucionFinanciera item)
        {
            var model = db.Catalogos_ctInstitucionFinanciera;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdInstitucionFinanciera == item.IdInstitucionFinanciera);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvInstitucionFinanciera", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvInstitucionFinancieraDelete(System.Byte IdInstitucionFinanciera)
        {
            var model = db.Catalogos_ctInstitucionFinanciera;
            if (IdInstitucionFinanciera != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdInstitucionFinanciera == IdInstitucionFinanciera);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvInstitucionFinanciera", model.ToList());
        }
    }
}
