﻿using Dapper;
using Nova.Libraries;
using Nova.Models;
using Nova.Models.IncidenciaPermiso;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.IncidenciasPermiso
{
    public class JustificacionesController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();
        // GET: Justificaciones
        public ActionResult Index()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var quincenames = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes();
             
            ViewBag.IdConvenioLaboral = new SelectList(db.Catalogos_ctConvenioLaboral.OrderBy(z => z.ConvenioLaboral), "IdConvenioLaboral", "ConvenioLaboral");
            List<SelectListItem> options = new List<SelectListItem>
            {
            new SelectListItem { Value = "H", Text = "HOMBRE" },
            new SelectListItem { Value = "M", Text = "MUJER" }
        };
            ViewBag.IdGenero = new SelectList(options, "Value", "Text");
            ViewBag.IdAreasUsuario = new SelectList(db.Catalogos_ctEstructuraOrganica.Where(q=> q.EsVigente).OrderBy(z => z.EstructuraOrganica), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.IdRelojChecadorAreas = new SelectList(db.Nomina_RelojChecadorAreas.OrderBy(z => z.EstructuraOrganica), "IdRelojChecadorAreas", "EstructuraOrganica");

            DateTime fecha = DateTime.Now.AddMonths(-1);
            ViewBag.IdTrabajador = new SelectList(db.vwDatosAspirantesTrabajadores.Where(q => q.EstatusTrabajador=="ALTA"  || 
            (q.EstatusTrabajador == "BAJA" && q.FechaTermino>= fecha)).Select(q=> new {Nombre=q.ApellidoPaterno+" "+q.ApellidoMaterno+" "+q.Nombre , IdTrabajador=q.IdTrabajador  }).OrderBy(a=> a.Nombre ), "IdTrabajador", "Nombre");

            
            return View();
        }

        public ActionResult VerIncidencias(string genero, short idarea, short rellab,short idt,string fi,string ft,short idreloj)
        {

            
            Justificaciones js = new Justificaciones();

            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion.Where(a=> a.AplicaJustificacionMasiva).OrderBy(z => z.IncidenciaJustificacion), "IdIncidenciaJustificacion", "IncidenciaJustificacion");
            return PartialView(js.getIncidencias(genero, idarea, rellab, idt, fi, ft,idreloj));

        }

      // 
      [HttpPost]
        public ActionResult Justificar(string genero, short idarea, short rellab, short idt, string fi, string ft, short idjust,short idreloj)
        {
         //   int idjust = System.Convert.ToInt32(Request.Form["IdIncidenciaJustificacion"]);
            var inci= db.Incidencia_ctJustificacion.Find(idjust);

            //string genero = (Request.Form["IdGenero"]);
            //Int16 idarea = System.Convert.ToInt16(Request.Form["IdAreasUsuario"]);
            //Int16 rellab = System.Convert.ToInt16(Request.Form["IdConvenioLaboral"]);
            //Int16 idt = System.Convert.ToInt16(Request.Form["IdTrabajador"]);
            //string fi = (Request.Form["fechainicial"]);
            //string ft = (Request.Form["fechafinal"]);
            var dfi = DateTime.Parse(fi);
            var dft = DateTime.Parse(ft);
            if (dfi > dft)
            {
                return JsonView(false, $"La fecha de incio {fi}, no puede ser mayor a la de termino: {ft}");
            }

            if ((inci.IncidenciaJustificacion== "DÍA DE LA MADRE" || inci.IncidenciaJustificacion == "DÍA INTERNACIONAL DE LA MUJER") && genero!="M")
            {
                return JsonView(false, $"La justificación {inci.IncidenciaJustificacion}, solo es válida para el género Femenino");

            }
            Justificaciones js = new Justificaciones();
          
           
            string observacion = System.Convert.ToString(Request.Form["hfIdObservacion"]);

            var datos=js.getIncidencias(genero, idarea, rellab, idt, fi, ft,idreloj);
            string idincidencias = string.Join(",", datos.Select(s=> s.IdIncidenciaTrabajador)); // Concatena los elementos de la lista separados por comas
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            var usuario = Seguridad.Identidad.Usuario();

            String updatsql = $@"update IncidenciaPermiso_stIncidenciaTrabajador 
            set IdIncidenciaJustificacion={idjust}
            , FechaJustificacion='{DateTime.Now.ToString("yyyyMMdd")}'
            , [FechaAutorizacion]='{DateTime.Now.ToString("yyyyMMdd")}'
            , [Autorizo]=1
            ,IdConvenioLaboralTrabajadorCategoriaJustifico={usuario.IdConvenioLaboralTrabajadorCategoria}
            ,IdConvenioLaboralTrabajadorCategoriaAutorizo={usuario.IdConvenioLaboralTrabajadorCategoria}
            ,IdConvenioLaboralTrabajadorCategoriaRegistro={usuario.IdConvenioLaboralTrabajadorCategoria}
            where   IdIncidenciaTrabajador in ({idincidencias})";
            dp.connection.Execute(updatsql);


            dp.Close();

            return JsonView(true, $"Se han justificado {datos.Count()} registros en la base de datos");


        }

    }
}