﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Dapper;
using Nova.Libraries;
using Nova.Models;
using Rotativa;
using static DevExpress.Xpo.Helpers.AssociatedCollectionCriteriaHelper;

namespace Nova.Controllers
{
    public class IncidenciaReporteTrabajadoresController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: IncidenciaPermisoTrabajador
        public ActionResult Index()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var quincenames = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes();
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");
            ViewBag.IdAreasUsuario = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAreasUsuario(usuario.IdConvenioLaboralTrabajadorCategoria), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.Rol = "OperadorIncidencias";
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas();

            return View();
        }

        public ActionResult IncidenciasCentros(string fechainicial = null, string fechafinal = null)
        {
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajadorCentros.getIncidenciasGlobalesTodosCentros(fechainicial, fechafinal);
            if (result.Count == 0)
                return View();
            else
                return View(result);

        }

        public ActionResult IncidenciasGlobales(string fechainicial = null, string fechafinal = null)
        {

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasGlobales(fechainicial, fechafinal));
        }



      
        public ActionResult IncidenciasGlobalesCentro(string fechainicial = null, string fechafinal = null)
        {

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasGlobalesCentro(fechainicial, fechafinal));
        }

        public ActionResult IncidenciasGlobalesCentroAplicadas(/*string fechainicial = null, string fechafinal = null,*/ string QuincenaMes = null, int year = 0, string periodo = null)
        {
            IEnumerable<SelectListItem> ListQna = from s in Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes01()
                                                  select new SelectListItem
                                                  {
                                                      Value = s.IdQuincenaMes.ToString(),
                                                      Text = s.QuincenaMes
                                                  };
            ViewBag.QuincenaMes = ListQna;
            ViewBag.IdQuincenaMes01 = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes01(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.year = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");
            //ViewBag.fechainicio = fechainicial;
            //ViewBag.fechafinal = fechafinal;
            ViewBag.periodo = periodo;
            ViewBag.QuincenaMess = QuincenaMes;
            ViewBag.years = year;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasGlobalesCentroAplicadas(/*fechainicial, fechafinal,*/ QuincenaMes, year, periodo));
        }

        public ActionResult IncidenciasGlobalesMesa(string fechainicial = null, string fechafinal = null)
        {

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasGlobalesMesa(fechainicial, fechafinal));
        }

        public ActionResult IncidenciasGlobalesResponsable(string fechainicial = null, string fechafinal = null)
        {

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasGlobalesResponsable(fechainicial, fechafinal));
        }



        //public ActionResult IncidenciasporAplicar(string fechainicial = null, string fechafinal = null)
        //{

        //    ViewBag.fechainicio = fechainicial;
        //    ViewBag.fechafinal = fechafinal;
        //    return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        //}

        public ActionResult IncidenciasporAplicar(string fechainicial = null, string fechafinal = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult IncidenciasporAplicarXls(string fechainicial = null, string fechafinal = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);


            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }

   
        public ActionResult IncidenciasporAplicarCentro(string fechainicial = null, string fechafinal = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicarCentro(fechainicial, fechafinal);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult IncidenciasporAplicarCentroAplicadas(/*string fechainicial = null, string fechafinal = null,*/ string QuincenaMes = null, int year = 0, string periodo = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            //ViewBag.fechainicio = fechainicial;
            //ViewBag.fechafinal = fechafinal;
            ViewBag.QuincenaMes = QuincenaMes;
            ViewBag.year = year;
            ViewBag.periodo = periodo;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicarCentroAplicadas(/*fechainicial, fechafinal,*/ QuincenaMes, year, periodo);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult IncidenciasporAplicarMesa(string fechainicial = null, string fechafinal = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicarMesa(fechainicial, fechafinal);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult IncidenciasporAplicarResponsable(string fechainicial = null, string fechafinal = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicarResponsable(fechainicial, fechafinal);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult TotalFaltasDepartamento(string fechainicial = null, string fechafinal = null, string departamento = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDepartamento(fechainicial, fechafinal, departamento);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }

        public ActionResult TotalFaltasDireccion(string fechainicial = null, string fechafinal = null, string direccion = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDireccion(fechainicial, fechafinal, direccion);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }

        public ActionResult TotalFaltasDepartamentoCentro(string fechainicial = null, string fechafinal = null, string departamento = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDepartamentoCentro(fechainicial, fechafinal, departamento);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }


        public ActionResult TotalFaltasDepartamentoCentroAplicadas(/*string fechainicial = null, string fechafinal = null,*/ string departamento = null, string QuincenaMes = null, int year = 0, string periodo = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            //ViewBag.fechainicio = fechainicial;
            //ViewBag.fechafinal = fechafinal;
            ViewBag.QuincenaMes = QuincenaMes;
            ViewBag.year = year;
            ViewBag.periodo = periodo;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDepartamentoCentroAplicadas(/*fechainicial, fechafinal,*/ departamento, QuincenaMes, year, periodo);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }

        public ActionResult TotalFaltasDireccionCentro(string fechainicial = null, string fechafinal = null, string direccion = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDireccionCentro(fechainicial, fechafinal, direccion);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }

        public ActionResult TotalFaltas(string fechainicial, string fechafinal, int IdEstructura)
        {

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getTotalFaltas(fechainicial, fechafinal, IdEstructura));
        }

        public ActionResult TotalFaltasJustificadas(string fechainicial, string fechafinal, int IdEstructura)
        {

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getTotalFaltasJustificadas(fechainicial, fechafinal, IdEstructura));
        }

        public ActionResult FaltasporAplicar(string fechainicial, string fechafinal, int IdEstructura)
        {

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getFaltasporAplicar(fechainicial, fechafinal, IdEstructura));
        }



        public ActionResult IncidenciasDiasEconomicos(string year = null, string relacionlaboral = null, string modalidad = null)
        {
            string queryrelacionlaboral = @" select IdRelacionLaboral, RelacionLaboral From Catalogos_ctRelacionLaboral where  IdRelacionLaboral < 3 ";
            string queryyear = @" select year (a.FechaInicio) as year  from IncidenciaPermiso_stIncidenciaTrabajador a
                                        inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion IN('DÍA ECONÓMICO') 
										and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) )
                                        group by year (a.FechaInicio)
                                        order by year (a.FechaInicio)";
            string querymodalidadestudios = @"select IdModalidadEstudio,
                                        CASE WHEN IdModalidadEstudio = 0 THEN 'OFICINAS CENTRALES'WHEN IdModalidadEstudio = 1 THEN 'PLANTEL' ELSE 'EMSAD'
                                        END AS ModalidadEstudio
                                        from vwDatosAspirantesTrabajadores
                                        where EstatusTrabajador = 'ALTA'
                                        group by IdModalidadEstudio";
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var relacionlaborales = (List<RelLaboralSeguimiento>)dp.connection.Query<RelLaboralSeguimiento>(queryrelacionlaboral);

            IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaborales
                                                             select new SelectListItem
                                                             {
                                                                 Value = s.RelacionLaboral.ToString(),
                                                                 Text = s.RelacionLaboral
                                                             };
            ViewBag.relacionlaboral = new SelectList(selectListrelacion, "Value", "Text");

            var years = (List<YearSeguimiento>)dp.connection.Query<YearSeguimiento>(queryyear);

            IEnumerable<SelectListItem> selectListyear = from s in years
                                                         select new SelectListItem
                                                         {
                                                             Value = s.year.ToString(),
                                                             Text = s.year
                                                         };
            ViewBag.year = new SelectList(selectListyear, "Value", "Text");

            var modalidades = (List<ModalidadSeguimiento>)dp.connection.Query<ModalidadSeguimiento>(querymodalidadestudios);

            IEnumerable<SelectListItem> selectListmodalidad = from s in modalidades
                                                              select new SelectListItem
                                                              {
                                                                  Value = s.IdModalidadEstudio.ToString(),
                                                                  Text = s.ModalidadEstudio
                                                              };
            ViewBag.modalidad = new SelectList(selectListmodalidad, "Value", "Text");

            dp.Close();
            //ViewBag.fechainicio = fechainicial;
            //ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDiasEconomicos(year, relacionlaboral, modalidad));
        }

        public ActionResult IncidenciasDiasEconomicosMesas(string year = null, string relacionlaboral = null, string modalidad = null)
        {
            string queryrelacionlaboral = @" select IdRelacionLaboral, RelacionLaboral From Catalogos_ctRelacionLaboral where  IdRelacionLaboral < 3 ";
            string queryyear = @" select year (a.FechaInicio) as year  from IncidenciaPermiso_stIncidenciaTrabajador a
                                        inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										WHERE c.TipoIncidenciaPermiso in('INCIDENCIA')  AND J.IncidenciaJustificacion IN('DÍA ECONÓMICO') 
										and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) )
                                        group by year (a.FechaInicio)
                                        order by year (a.FechaInicio)";
            string querymodalidadestudios = @"select IdModalidadEstudio,
                                        CASE WHEN IdModalidadEstudio = 0 THEN 'OFICINAS CENTRALES'WHEN IdModalidadEstudio = 1 THEN 'PLANTEL' ELSE 'EMSAD'
                                        END AS ModalidadEstudio
                                        from vwDatosAspirantesTrabajadores
                                        where EstatusTrabajador = 'ALTA'
                                        group by IdModalidadEstudio";
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var relacionlaborales = (List<RelLaboralSeguimiento>)dp.connection.Query<RelLaboralSeguimiento>(queryrelacionlaboral);

            IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaborales
                                                             select new SelectListItem
                                                             {
                                                                 Value = s.RelacionLaboral.ToString(),
                                                                 Text = s.RelacionLaboral
                                                             };
            ViewBag.relacionlaboral = new SelectList(selectListrelacion, "Value", "Text");

            var years = (List<YearSeguimiento>)dp.connection.Query<YearSeguimiento>(queryyear);

            IEnumerable<SelectListItem> selectListyear = from s in years
                                                         select new SelectListItem
                                                         {
                                                             Value = s.year.ToString(),
                                                             Text = s.year
                                                         };
            ViewBag.year = new SelectList(selectListyear, "Value", "Text");

            var modalidades = (List<ModalidadSeguimiento>)dp.connection.Query<ModalidadSeguimiento>(querymodalidadestudios);

            IEnumerable<SelectListItem> selectListmodalidad = from s in modalidades
                                                              select new SelectListItem
                                                              {
                                                                  Value = s.IdModalidadEstudio.ToString(),
                                                                  Text = s.ModalidadEstudio
                                                              };
            ViewBag.modalidad = new SelectList(selectListmodalidad, "Value", "Text");

            dp.Close();
            //ViewBag.fechainicio = fechainicial;
            //ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDiasEconomicosMesas(year, relacionlaboral, modalidad));
        }

        public ActionResult IncidenciasDiasEconomicosTrabajadores(string year = null, string relacionlaboral = null, string modalidad = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDiasEconomicosTrabajadores(year, relacionlaboral, modalidad);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult IncidenciasDiasEconomicosTrabajadoresXls(string year = null, string relacionlaboral = null, string modalidad = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDiasEconomicosTrabajadores(year, relacionlaboral, modalidad);


            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidades);

            return View(result);
        }

        public ActionResult IncidenciasDiasEconomicosTrabajadoresMesas(string year = null, string relacionlaboral = null, string modalidad = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDiasEconomicosTrabajadoresMesas(year, relacionlaboral, modalidad);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult IncidenciasDiasEconomicosTrabajadoresMesasXls(string year = null, string relacionlaboral = null, string modalidad = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasDiasEconomicosTrabajadoresMesas(year, relacionlaboral, modalidad);


            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidades);

            return View(result);
        }

        public ActionResult PuntualidadAsistencia(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        {
            string queryrelacionlaboral = @" select IdRelacionLaboral, RelacionLaboral From Catalogos_ctRelacionLaboral where  IdRelacionLaboral < 3 ";
            string queryyear = @" select year (a.FechaInicio) as year  from IncidenciaPermiso_stIncidenciaTrabajador a
                                        inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
										inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
										inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
										INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
										WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS') 
										and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) )
                                        group by year (a.FechaInicio)
                                        order by year (a.FechaInicio)";
            string querymodalidadestudios = @"select IdModalidadEstudio,
                                        CASE WHEN IdModalidadEstudio = 0 THEN 'OFICINAS CENTRALES'WHEN IdModalidadEstudio = 1 THEN 'PLANTEL' ELSE 'EMSAD'
                                        END AS ModalidadEstudio
                                        from vwDatosAspirantesTrabajadores
                                        where EstatusTrabajador = 'ALTA'
                                        group by IdModalidadEstudio";
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var relacionlaborales = (List<RelLaboralSeguimiento>)dp.connection.Query<RelLaboralSeguimiento>(queryrelacionlaboral);

            IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaborales
                                                             select new SelectListItem
                                                             {
                                                                 Value = s.RelacionLaboral.ToString(),
                                                                 Text = s.RelacionLaboral
                                                             };
            ViewBag.relacionlaboral = new SelectList(selectListrelacion, "Value", "Text");

            var years = (List<YearSeguimiento>)dp.connection.Query<YearSeguimiento>(queryyear);

            IEnumerable<SelectListItem> selectListyear = from s in years
                                                         select new SelectListItem
                                                         {
                                                             Value = s.year.ToString(),
                                                             Text = s.year
                                                         };
            ViewBag.year = new SelectList(selectListyear, "Value", "Text");

            var modalidades = (List<ModalidadSeguimiento>)dp.connection.Query<ModalidadSeguimiento>(querymodalidadestudios);

            IEnumerable<SelectListItem> selectListmodalidad = from s in modalidades
                                                              select new SelectListItem
                                                              {
                                                                  Value = s.IdModalidadEstudio.ToString(),
                                                                  Text = s.ModalidadEstudio
                                                              };
            ViewBag.modalidad = new SelectList(selectListmodalidad, "Value", "Text");
            ViewBag.periodo = periodo;
            ViewBag.years = year;
            ViewBag.relacionlaborals = relacionlaboral;
            ViewBag.modalidads = modalidad;
            ViewBag.periodos = periodo;


            dp.Close();
            //ViewBag.fechainicio = fechainicial;
            //ViewBag.fechafinal = fechafinal;
            if (periodo == "PRIMER")
            {
                return View("PuntualidadAsistenciaPrimerSem", IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistencia(year, relacionlaboral, modalidad, periodo));
            }
            else if (periodo == "SEGUNDO")
            {
                return View("PuntualidadAsistenciaSegundoSem", IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistencia(year, relacionlaboral, modalidad, periodo));
            }
            else
            {
                return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistencia(year, relacionlaboral, modalidad, periodo));
            }



        }

        public ActionResult PuntualidadAsistenciaTrabajadores(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadores(year, relacionlaboral, modalidad, periodo);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidades = "Nomina_PuntualidadAnual" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult PuntualidadAsistenciaTrabajadoresPrimerSem(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadores(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_PuntualidadPrimerSem" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

        }
        public ActionResult PuntualidadAsistenciaTrabajadoresSegundoSem(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadores(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_PuntualidadSegundoSem" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

        }


        public ActionResult PuntualidadAsistenciaTrabajadoresXls(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadores(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_PuntualidadAnual" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidades);

            return View(result);



        }
        public ActionResult PuntualidadAsistenciaTrabajadoresPrimerSemXls(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadores(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_PuntualidadPrimerSem" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidades);

            return View(result);



        }
        public ActionResult PuntualidadAsistenciaTrabajadoresSegundoSemXls(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadores(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidades);

            return View(result);
        }

        public ActionResult PuntualidadAsistenciaMesas(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        {
            string queryrelacionlaboral = @" select IdRelacionLaboral, RelacionLaboral From Catalogos_ctRelacionLaboral where  IdRelacionLaboral < 3 ";
            string queryyear = @" select year (a.FechaInicio) as year  from IncidenciaPermiso_stIncidenciaTrabajador a
                                 inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
									inner join  Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
									inner join vwDatosAspirantesTrabajadoresHistorial t on t.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
									INNER JOIN [Incidencia_ctJustificacion] J ON J .IdIncidenciaJustificacion=A.IdIncidenciaJustificacion
									WHERE c.TipoIncidenciaPermiso in('INCIDENCIA', 'RETARDOS') 
									and ((Autorizo=1 and a.IdIncidenciaJustificacion>0) )
                                 group by year (a.FechaInicio)
                                 order by year (a.FechaInicio)";
            string querymodalidadestudios = @"select IdModalidadEstudio,
                                 CASE WHEN IdModalidadEstudio = 0 THEN 'OFICINAS CENTRALES'WHEN IdModalidadEstudio = 1 THEN 'PLANTEL' ELSE 'EMSAD'
                                 END AS ModalidadEstudio
                                 from vwDatosAspirantesTrabajadores
                                 where EstatusTrabajador = 'ALTA'
                                 group by IdModalidadEstudio";
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var relacionlaborales = (List<RelLaboralSeguimiento>)dp.connection.Query<RelLaboralSeguimiento>(queryrelacionlaboral);

            IEnumerable<SelectListItem> selectListrelacion = from s in relacionlaborales
                                                             select new SelectListItem
                                                             {
                                                                 Value = s.RelacionLaboral.ToString(),
                                                                 Text = s.RelacionLaboral
                                                             };
            ViewBag.relacionlaboral = new SelectList(selectListrelacion, "Value", "Text");

            var years = (List<YearSeguimiento>)dp.connection.Query<YearSeguimiento>(queryyear);

            IEnumerable<SelectListItem> selectListyear = from s in years
                                                         select new SelectListItem
                                                         {
                                                             Value = s.year.ToString(),
                                                             Text = s.year
                                                         };
            ViewBag.year = new SelectList(selectListyear, "Value", "Text");

            var modalidades = (List<ModalidadSeguimiento>)dp.connection.Query<ModalidadSeguimiento>(querymodalidadestudios);

            IEnumerable<SelectListItem> selectListmodalidad = from s in modalidades
                                                              select new SelectListItem
                                                              {
                                                                  Value = s.IdModalidadEstudio.ToString(),
                                                                  Text = s.ModalidadEstudio
                                                              };
            ViewBag.modalidad = new SelectList(selectListmodalidad, "Value", "Text");
            ViewBag.periodo = periodo;
            ViewBag.years = year;
            ViewBag.relacionlaborals = relacionlaboral;
            ViewBag.modalidads = modalidad;
            ViewBag.periodos = periodo;


            dp.Close();
            //ViewBag.fechainicio = fechainicial;
            //ViewBag.fechafinal = fechafinal;
            if (periodo == "PRIMER")
            {
                return View("PuntualidadAsistenciaPrimerSemMesas", IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaMesas(year, relacionlaboral, modalidad, periodo));
            }
            else if (periodo == "SEGUNDO")
            {
                return View("PuntualidadAsistenciaSegundoSemMesas", IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaMesas(year, relacionlaboral, modalidad, periodo));
            }
            else
            {
                return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaMesas(year, relacionlaboral, modalidad, periodo));
            }

        }

        public ActionResult PuntualidadAsistenciaTrabajadoresMesas(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadoresMesas(year, relacionlaboral, modalidad, periodo);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

            //string modalidad = "IncidenciasporAplicar" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            //// return View(model);
            //Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            //m.Bottom = 0;
            //m.Left = 4;
            //m.Right = 4;
            //m.Top = 7;
            //var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal);

            ////return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            ////return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasporAplicar(fechainicial, fechafinal));
        }

        public ActionResult PuntualidadAsistenciaTrabajadoresPrimerSemMesas(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadoresMesas(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_PuntualidadPrimerSem" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

        }
        public ActionResult PuntualidadAsistenciaTrabajadoresSegundoSemMesas(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadoresMesas(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_PuntualidadSegundoSem" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

        }

        public ActionResult PuntualidadAsistenciaTrabajadoresMesasXls(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadoresMesas(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidades);

            return View(result);
        }
        public ActionResult PuntualidadAsistenciaTrabajadoresPrimerSemXlsMesas(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadoresMesas(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_PuntualidadPrimerSem" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidades);

            return View(result);



        }
        public ActionResult PuntualidadAsistenciaTrabajadoresSegundoSemXlsMesas(string year = null, string relacionlaboral = null, string modalidad = null, string periodo = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPuntualidadAsistenciaTrabajadoresMesas(year, relacionlaboral, modalidad, periodo);


            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidades);

            return View(result);
        }

        public ActionResult PrimaDominical(string fechainicial = null, string fechafinal = null)
        {
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPrimaDominical(fechainicial, fechafinal));

         
        }
        public ActionResult PrimaDominicalMesas(string fechainicial = null, string fechafinal = null)
        {
            

            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            return View(IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPrimaDominicalMesas(fechainicial, fechafinal));
        }

        public ActionResult PrimaDominicalTrabajadores(string fechainicial = null, string fechafinal = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPrimaDominicalTrabajadores(fechainicial, fechafinal);

            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;


            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };


        }

        public ActionResult PrimaDominicalTrabajadoresXls(string fechainicial = null, string fechafinal = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPrimaDominicalTrabajadores(fechainicial, fechafinal);


            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }


        public ActionResult PrimaDominicalTrabajadoresMesas(string fechainicial = null, string fechafinal = null)
        {
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPrimaDominicalTrabajadoresMesas(fechainicial, fechafinal);

            //EstructuraIncidencias ei = new EstructuraIncidencias();
            //ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidades = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;

            //return View("IncidenciasporAplicar", result.ToList());
            //return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidades };

           
        }

        public ActionResult PrimaDominicalTrabajadoresMesasXls(string fechainicial = null, string fechafinal = null)
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            ViewBag.fechainicio = fechainicial;
            ViewBag.fechafinal = fechafinal;
            var result = IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPrimaDominicalTrabajadoresMesas(fechainicial, fechafinal);


            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }

        public ActionResult TotalPuntualidadAnual(string year, string relacionlaboral, string modalidad, string periodo, string Estructura)
        {

            return View(IncidenciaPermiso_stIncidenciaTrabajador.getPuntualidadAsistenciaTrabajadoresTotal(year, relacionlaboral, modalidad, periodo, Estructura));
        }

        public ActionResult TotalPuntualidadPrimerSem(string year, string relacionlaboral, string modalidad, string periodo, string Estructura)
        {

            return View(IncidenciaPermiso_stIncidenciaTrabajador.getPuntualidadAsistenciaTrabajadoresTotal(year, relacionlaboral, modalidad, periodo, Estructura));
        }
        public ActionResult TotalPuntualidadSegundoSem(string year, string relacionlaboral, string modalidad, string periodo, string Estructura)
        {

            return View(IncidenciaPermiso_stIncidenciaTrabajador.getPuntualidadAsistenciaTrabajadoresTotal(year, relacionlaboral, modalidad, periodo, Estructura));
        }





        // GET: IncidenciaPermisoTrabajador/Delete/5
        public ActionResult Delete(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermisoTrabajador/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(long id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
