﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Dapper;
using Nova.Libraries;
using Nova.Models;
using Rotativa;

namespace Nova.Controllers
{
    public class IncidenciaPermisoTrabajadoresController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: IncidenciaPermisoTrabajador
        public ActionResult Index()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var quincenames = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes();
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");
            ViewBag.IdAreasUsuario = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAreasUsuario(usuario.IdConvenioLaboralTrabajadorCategoria), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.Rol = "OperadorIncidencias";
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas(); 

            return View();
        }
        public ActionResult AdministradorIncidencias()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var quincenames = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes();
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");
            ViewBag.IdAreasUsuario = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAreasAdmin(), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.Rol = "AdministradorIncidencias";
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas();

            return View("Index");
        }

        public ActionResult IncidenciasPorMesaAdmin()
        {
            


            return View("IncidenciasPorMesa", IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPorMesa(0));
        }
        public ActionResult IncidenciasPorMesa()
        {
            var id = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var hay=db.Nomina_RelojChecadorControlUsuarios.Where(d => d.IdConvenioLaboralTrabajadorCategoria == id).FirstOrDefault();

            if (hay == null)
            {
                throw new ApplicationException("Esta opción solo es para reposnsables de las mesas");
            }



            return View( IncidenciaPermiso_stIncidenciaTrabajador.getIncidenciasPorMesa(id));
        }
        public ActionResult ResponsablesIncidencias()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var quincenames = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes();
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");
            ViewBag.IdAreasUsuario = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAreaDirector(usuario.IdConvenioLaboralTrabajadorCategoria), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.Rol = "ResponsableIncidencias";
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas();


            return View("Index");
        }
        public ActionResult PermisosArea(PermisosArea permisosarea)
        {
            DateTime fechainicial = Convert.ToDateTime(permisosarea.fi);
            DateTime fechafinal = Convert.ToDateTime(permisosarea.ff);
            //var listpermisosarea = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "PERMISO"
            // && z.Convenios_stConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria == permisosarea.idarea
            // && z.Autorizo == true
            // && z.Catalogos_ctTipoIncidencia.EsPermiso==true
            // && (z.FechaInicio <= fechainicial && z.FechaTermino >= fechainicial) || (z.FechaInicio >= fechainicial && z.FechaTermino <= fechafinal)
            // || (z.FechaInicio <= fechafinal && z.FechaTermino >= fechafinal)
            // || (z.FechaInicio <= fechainicial && z.FechaTermino >= fechafinal)).ToList();
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query;

            query = @"select f.IdTrabajador as Id,b.Incidencia as Permiso,f.Nombre,f.ApellidoPaterno,f.ApellidoMaterno,a.FechaInicio,a.FechaTermino from IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
inner join Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on a.IdConvenioLaboralTrabajadorCategoria= d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador e on e.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
inner join vwDatosAspirantesTrabajadores f on f.IdTrabajador = e.IdTrabajador
where f.IdEstructuraOrganicaFisica= "+ permisosarea.idarea + " and c.IdTipoIncidenciaPermiso=4 "  +
@" union all " + 
@"select a.IdTrabajador as Id,b.Incidencia as Permiso,d.Nombre,d.ApellidoPaterno,d.ApellidoMaterno,a.FechaInicio,a.FechaTermino from Nomina_ApoyoEstudios a
inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
inner join Catalogos_ctTipoIncidenciaPermiso c on b.IdTipoIncidenciaPermiso = c.IdTipoIncidenciaPermiso
inner join vwDatosAspirantesTrabajadores d on a.IdTrabajador = d.IdTrabajador
where d.IdEstructuraOrganicaFisica= "+ permisosarea.idarea + " and c.IdTipoIncidenciaPermiso=4  "
+ @"order by 1,6";
            List<TrabajadoresPermisos> t = (List<TrabajadoresPermisos>)dp.connection.Query<TrabajadoresPermisos>(query);
            dp.Close();

            return PartialView("pvPermisosUbicabcionFisica", t);
        }

        public ActionResult PivotIncidencias(string ida, short idarea,short idqm, string rol )
        {
            ViewBag.justificaciones = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getTipoJustificacion();
            ViewBag.Leyendas = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetLeyendas();

            string año = ida;
            int aaaa = Convert.ToInt32(año);
            ViewBag.Año = aaaa;
            ViewBag.Idqm = idqm;
            DateTime FechaInicial=DateTime.MinValue;
            DateTime FechaFinal= DateTime.MinValue;
            ViewBag.Idarea = idarea;

            Boolean esquincenapar = false;
            short NoQuincena =System.Convert.ToInt16( db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().QuincenaMes);
            ViewBag.ol = rol;
            ViewBag.NoQuincena = NoQuincena;
            ViewBag.NombreMes = db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().Catalogos_ctMes.Mes;
            string NoMes = System.Convert.ToString(db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().IdMes);
            short Mes = System.Convert.ToInt16(NoMes);
            if (NoQuincena % 2 == 0)
            {
                esquincenapar = true;
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes+"-16");
                switch (NoMes)
                {
                    case "2" :
                        Boolean esbisiesto = System.DateTime.IsLeapYear(Convert.ToInt32(año));
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-29");
                        break;
                    case "4":
                    case "6":
                    case "9":
                    case "11":
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-30");
                        break;
                    default:
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-31");
                        break;
                }
            }
            else
            {
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes);
                FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes+"-15");
            }
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query;

            query = @"select IdIncidenciaTrabajador=NULL,FechaInicio=NULL,FechaTermino=NULL,Horas=NULL,tiempofuera=NULL,IdTrabajador,Nombre+' '+ApellidoPaterno+' '+ApellidoMaterno as Trabajador
,DiasHorasIncidencia=NULL
,DiasEconomicos=NULL
,QuienAutorizo=NULL
,QuienJustifico=NULL
,QuienRegistro=NULL
,Incidencia=NULL,Nomenclatura=NULL,Color=NULL
,IncidenciaJustico=NULL,NomenclaturaJustifico=NULL,ColorJustifico=NULL
,IdNominaTrabajador=NULL,EstructuraOrganica=NULL,Categoria=NULL
,Observaciones=NULL,RelacionLaboral,ConvenioLaboral,EsAplicada=NULL,Autorizo=NULL,DescripcionJustificacion=NULL
,FechaAutorizacion=NULL,FechaCreacion=NULL,FechaJustificacion=NULL
,EsJustificacionExtemporanea=NULL
,IdIncidenciaJustificacion=NULL
,EsCancelada=NULL
,EsCerrada=NULL
,EsFaltaDirecta=NULL
,CURP
,FechaTermino as FechaTerminoConvenio
,IdModalidadEstudio
,QuincenaParaNomina=NULL
,AñoParaNomina=NULL
from vwDatosAspirantesTrabajadoresHistorial 
where IdEstructuraOrganicaFisica=" + idarea+ " and (EstatusTrabajador='ALTA' or EstatusTrabajador='BAJA')" +
" and (Year(FechaTermino) >= "+DateTime.Now.Year.ToString()+ " or FechaTermino is null)"+
" and IdConvenioLaboralTrabajadorCategoria not in (select IdConvenioLaboralTrabajadorCategoria" +
" from IncidenciaPermiso_stIncidenciaTrabajador where IdEstructuraOrganica="+ idarea+ " and (IdTipoIncidencia=2 or IdTipoIncidencia=31 or IdTipoIncidencia=36 or IdTipoIncidencia=8 or IdTipoIncidencia=32 or IdTipoIncidencia=37 or IdTipoIncidencia=38 or IdTipoIncidencia=35 or IdTipoIncidencia=43) and cast(FechaInicio as date)>=" + "'" + FechaInicial.ToShortDateString() + "'" + " and cast(FechaTermino as date)<=" + "'" + FechaFinal.ToShortDateString() + "')"
+ " union all"
+ @" select a.IdIncidenciaTrabajador,a.FechaInicio,a.FechaTermino,a.Horas,a.tiempofuera,d.IdTrabajador,e.Nombre+' '+e.ApellidoPaterno+' '+e.ApellidoMaterno as Trabajador
,CASE WHEN j.RelacionLaboral='DOCENTE' then a.Horas else DATEDIFF(day, b.FechaInicio,a.FechaTermino) end as DiasHorasIncidencia
,CASE WHEN k.Incidencia='DÍAS ECONÓMICOS' then DATEDIFF(day, b.FechaInicio,a.FechaTermino) ELSE 0 end DiasEconomicos
,ka.Nombre+' '+ka.ApellidoPaterno+' '+ka.ApellidoMaterno as QuienAutorizo
,kj.Nombre+' '+kj.ApellidoPaterno+' '+kj.ApellidoMaterno as QuienJustifico
,kr.Nombre+' '+kr.ApellidoPaterno+' '+kr.ApellidoMaterno as QuienRegistro
,k.Incidencia, k.Nomenclatura,k.Color
,ij.IncidenciaJustificacion as IncidenciaJustico,ij.Nomenclatura as NomenclaturaJustifico,ij.Color ColorJustifico
,a.IdNominaTrabajador,f.EstructuraOrganica,h.Categoria
,a.Observaciones,j.RelacionLaboral,l.ConvenioLaboral,a.EsAplicada,a.Autorizo,a.DescripcionJustificacion
,a.FechaAutorizacion,a.FechaCreacion,a.FechaJustificacion
,a.EsJustificacionExtemporanea
,a.IdIncidenciaJustificacion
,a.EsCancelada
,a.EsCerrada
,a.EsFaltaDirecta
,e.CURP
,b.FechaTermino as FechaTerminoConvenio
,f.IdModalidadEstudio
,a.QuincenaParaNomina
,a.AñoParaNomina
from IncidenciaPermiso_stIncidenciaTrabajador a
inner join vwDatosAspirantesTrabajadoresHistorial xx on a.IdConvenioLaboralTrabajadorCategoria=xx.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador d on d.IdTrabajador = c.IdTrabajador
inner join Kardex_ctDatosPersonales e on d.IdKardex= e.IdKardex
inner join Catalogos_ctEstructuraOrganica f on b.IdEstructuraOrganica =f.IdEstructuraOrganica
inner join Plazas_stDistribucionPlazaCategoria g on b.IdDistribucionPlazaCategoria=g.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria h on g.IdCategoria=h.IdCategoria
inner join Convenios_stRelacionConvenioLaboral i on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctRelacionLaboral j on i.IdRelacionLaboral=j.IdRelacionLaboral
inner join Catalogos_ctTipoIncidencia k on a.IdTipoIncidencia=k.IdTipoIncidencia
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=i.IdConvenioLaboral

--Autorizo
left join Convenios_stConvenioLaboralTrabajadorCategoria ca on a.IdConvenioLaboralTrabajadorCategoriaAutorizo=ca.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador la on la.IdConvenioLaboralTrabajador= ca.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador ta on ta.IdTrabajador=la.IdTrabajador
left join Kardex_ctDatosPersonales ka on ka.IdKardex = ta.IdKardex
--Justifico
left join Convenios_stConvenioLaboralTrabajadorCategoria cj on a.IdConvenioLaboralTrabajadorCategoriaJustifico=cj.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador lj on lj.IdConvenioLaboralTrabajador= cj.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador tj on tj.IdTrabajador=lj.IdTrabajador
left join Kardex_ctDatosPersonales kj on kj.IdKardex = tj.IdKardex
--Registro
left join Convenios_stConvenioLaboralTrabajadorCategoria cr on a.IdConvenioLaboralTrabajadorCategoriaRegistro=cr.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador lr on lr.IdConvenioLaboralTrabajador= cr.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador tr on tr.IdTrabajador=lr.IdTrabajador
left join Kardex_ctDatosPersonales kr on kr.IdKardex = tr.IdKardex
--Incidencia Justificación
left join Incidencia_ctJustificacion ij on ij.IdIncidenciaJustificacion = a.IdIncidenciaJustificacion
where b.IdEstructuraOrganica=" + idarea + " and (a.IdTipoIncidencia=2 or a.IdTipoIncidencia=31 or a.IdTipoIncidencia=36 or a.IdTipoIncidencia=8 or a.IdTipoIncidencia=32 or a.IdTipoIncidencia=37 or a.IdTipoIncidencia=38 or a.IdTipoIncidencia=35 or a.IdTipoIncidencia=43 or a.IdTipoIncidencia=58)  and cast(a.FechaInicio as date)>=" + "'"+FechaInicial.ToShortDateString()+"'"+ " and cast(a.FechaTermino as date)<=" + "'"+FechaFinal.ToShortDateString()+"'"
+ " order by 23 ,35";
            List<IncidenciaTrabajador> t = (List<IncidenciaTrabajador>)dp.connection.Query<IncidenciaTrabajador>(query);
    dp.Close();
            // Grupo por Idtrabajador
            var trabajadores = t.GroupBy(x => x.IdTrabajador).Select(z => new {IdTrabajador=z.Key }).ToList();
            // pivot incidencias por trabajador
            List<VistaIncidenciaTrabajador> Listaincidencias = new List<VistaIncidenciaTrabajador>();
            // Obtiene día inicial y final de la quincena
            short diainicialquincena = Convert.ToByte(FechaInicial.ToShortDateString().Substring(0,2));
            short diafinalquincena = Convert.ToByte(FechaFinal.ToShortDateString().Substring(0, 2));
            short diaincidencia = 0;
            ViewBag.diainicialquincena = diainicialquincena;
            ViewBag.diafinalquincena = diafinalquincena;
            ViewBag.FechaInicial = FechaInicial.Date;
            ViewBag.FechaFinal = FechaFinal.Date;
            int faltas;
            int permisoseconomicos;
            string tobservaciones;
            Boolean puntualidadasistencia = false;
            foreach (var p in trabajadores)
            {
                var datostrabajador = t.Where(x=>x.IdTrabajador==p.IdTrabajador).FirstOrDefault();
                   
                
                int IdTrabajador = datostrabajador.IdTrabajador;
                string Trabajador = datostrabajador.Trabajador;
                string Categoria = datostrabajador.Categoria;
                string RelacionLaboral = datostrabajador.RelacionLaboral;
                string ConvenioLaboral = datostrabajador.ConvenioLaboral;
                int IdModalidadEstudio= datostrabajador.IdModalidadEstudio;
                faltas = 0;
                permisoseconomicos = 0;
                tobservaciones = "";
                VistaIncidenciaTrabajador vit = new VistaIncidenciaTrabajador();
                vit.Id = IdTrabajador;
                vit.Trabajador = Trabajador;
                vit.Categoria = Categoria;
                vit.ConvenioLaboral = ConvenioLaboral;
                vit.RelacionLaboral = RelacionLaboral;
                vit.Ftc =null;
                vit.IdModalidadEstudio = IdModalidadEstudio;
                if (datostrabajador.FechaTerminoConvenio.HasValue)
                    vit.Ftc = datostrabajador.FechaTerminoConvenio.Value;

                for (DateTime date = FechaInicial; date <= FechaFinal; date = date.AddDays(1.0))
                {
                    var incidenciasTrabajadordia = t.Where(z => z.IdTrabajador == p.IdTrabajador && z.FechaInicio.Year==date.Year && z.FechaInicio.Month==date.Month && z.FechaInicio.Day==date.Day).ToList();
                    if (incidenciasTrabajadordia.Count() > 0)
                    { 

                        // Verifica a que día corresponde
                        diaincidencia = Convert.ToByte(date.ToShortDateString().Substring(0, 2));
                       
                        foreach (var ind in incidenciasTrabajadordia)
                        {
                            tobservaciones = tobservaciones +" "+ ind.Observaciones;
                            if (ind.Nomenclatura != null)
                            {
                                if (RelacionLaboral== "ADMINISTRATIVO")
                                {
                                    if ((ind.Incidencia.Contains("FALTA")   && ind.Autorizo == false)
                                        || (ind.Incidencia.Contains("FALTA") && ind.Autorizo == true && ind.IdIncidenciaJustificacion==0)
                                        || (ind.Incidencia.Contains("FALTA") && ind.IncidenciaJustico == "DÍA ECONÓMICO"  && ind.Autorizo == false)
                                        || (ind.Incidencia.Contains("OMISIÓN") && ind.Autorizo == false)

                                        )
                                    {
                                         faltas = faltas + 1;
                                    }

                                }
                                else
                                {
                                    if (RelacionLaboral == "DOCENTE") 
                                    {
                                        if ((ind.Incidencia.Contains("FALTA")   && ind.Autorizo == false)
                                        || (ind.Incidencia.Contains("FALTA") && ind.Autorizo == true && ind.IdIncidenciaJustificacion == 0)
                                        || (ind.Incidencia.Contains("FALTA") && ind.IncidenciaJustico == "DÍA ECONÓMICO" && ind.Autorizo == false)
                                        || (ind.Incidencia.Contains("OMISIÓN") && ind.Autorizo == false)
                                        
                                        )
                                        {
                                            faltas = faltas + ind.Horas;
                                        }

                                    }

                                }
                                if (ind.NomenclaturaJustifico != null)
                                {
                                    if (
                                        (ind.IncidenciaJustico == "DÍA ECONÓMICO" && ConvenioLaboral == "BASE" && ind.FechaAutorizacion !=null && ind.Autorizo == true)
                                        //|| (ind.IncidenciaJustico == "DÍA ECONÓMICO" && ConvenioLaboral == "BASE" && (ind.FechaAutorizacion==null || ind.FechaAutorizacion.Year ==1))
                                        )
                                    {
                                        permisoseconomicos = permisoseconomicos + 1;
                                    }
                                }
                            }
                        }
                        switch (diaincidencia)
                        {
                            case 1:
                                vit.D1 = 1;
                                vit.IncidenciasDia1= incidenciasTrabajadordia;
                                break;
                            case 2:
                                vit.D2 = 2;
                                vit.IncidenciasDia2= incidenciasTrabajadordia;
                                break;
                            case 3:
                                vit.D3 = 3;
                                vit.IncidenciasDia3 = incidenciasTrabajadordia;
                                break;
                            case 4:
                                vit.D4 = 4;
                                vit.IncidenciasDia4 = incidenciasTrabajadordia;
                                break;
                            case 5:
                                vit.D5 = 5;
                                vit.IncidenciasDia5 = incidenciasTrabajadordia;
                            break;
                            case 6:
                                vit.D6 = 6;
                                vit.IncidenciasDia6 = incidenciasTrabajadordia;
                            break;
                            case 7:
                                vit.D7 = 7;
                                vit.IncidenciasDia7 = incidenciasTrabajadordia;
                            break;
                            case 8:
                                vit.D8 = 8;
                                vit.IncidenciasDia8 = incidenciasTrabajadordia;
                            break;
                            case 9:
                                vit.D9 = 9;
                                vit.IncidenciasDia9 = incidenciasTrabajadordia;
                            break;
                            case 10:
                                vit.D10 = 10;
                                vit.IncidenciasDia10 = incidenciasTrabajadordia;
                            break;
                            case 11:
                                vit.D11 = 11;
                                vit.IncidenciasDia11 = incidenciasTrabajadordia;
                            break;
                            case 12:
                                vit.D12 = 12;
                                vit.IncidenciasDia12 = incidenciasTrabajadordia;
                            break;
                            case 13:
                                vit.D13 = 13;
                                vit.IncidenciasDia13 = incidenciasTrabajadordia;
                            break;
                            case 14:
                                vit.D14 = 14;
                                vit.IncidenciasDia14 = incidenciasTrabajadordia;
                            break;
                            case 15:
                                vit.D15 = 15;
                                vit.IncidenciasDia15 = incidenciasTrabajadordia;
                            break;
                            case 16:
                                vit.D1 = 16;
                                vit.IncidenciasDia1 = incidenciasTrabajadordia;
                            break;
                            case 17:
                                vit.D2 = 17;
                                vit.IncidenciasDia2 = incidenciasTrabajadordia;
                            break;
                            case 18:
                                vit.D3 = 18;
                                vit.IncidenciasDia3 = incidenciasTrabajadordia;
                            break;
                            case 19:
                                vit.D4 = 19;
                                vit.IncidenciasDia4 = incidenciasTrabajadordia;
                            break;
                            case 20:
                                vit.D5 = 20;
                                vit.IncidenciasDia5 = incidenciasTrabajadordia;
                            break;
                            case 21:
                                vit.D6 = 21;
                                vit.IncidenciasDia6 = incidenciasTrabajadordia;
                            break;
                            case 22:
                                vit.D7 = 22;
                                vit.IncidenciasDia7 = incidenciasTrabajadordia;
                            break;
                            case 23:
                                vit.D8 = 23;
                                vit.IncidenciasDia8 = incidenciasTrabajadordia;
                            break;
                            case 24:
                                vit.D9 = 24;
                                vit.IncidenciasDia9 = incidenciasTrabajadordia;
                            break;
                            case 25:
                                vit.D10 = 25;
                                vit.IncidenciasDia10 = incidenciasTrabajadordia;
                            break;
                            case 26:
                                vit.D11 = 26;
                                vit.IncidenciasDia11 = incidenciasTrabajadordia;
                            break;
                            case 27:
                                vit.D12 = 27;
                                vit.IncidenciasDia12 = incidenciasTrabajadordia;
                            break;
                            case 28:
                                vit.D13 = 28;
                                vit.IncidenciasDia13 = incidenciasTrabajadordia;
                            break;
                            case 29:
                                vit.D14 = 29;
                                vit.IncidenciasDia14 = incidenciasTrabajadordia;
                            break;
                            case 30:
                                vit.D15 = 30;
                                vit.IncidenciasDia15 = incidenciasTrabajadordia;
                            break;
                            case 31:
                                vit.D16 = 31;
                                vit.IncidenciasDia16 = incidenciasTrabajadordia;
                            break;
                            default:
                                throw new Exception("Error al procesar las incidencias del trabajador " + Trabajador);


                        }
                    }
                }
                vit.Faltas = faltas;
                vit.PuntualidadAsistencia = false;
                vit.Observaciones = tobservaciones;
                vit.DiasEconomicos = permisoseconomicos;
                if ((NoQuincena % 2) == 0)
                {
                    var pa1 = db.IncidenciaPermiso_stIncidenciaTrabajador
                     .Where(
                        z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == p.IdTrabajador
                     && (
                     (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && RelacionLaboral == "ADMINISTRATIVO" && z.Autorizo == false)
                     ||( z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && RelacionLaboral == "DOCENTE" &&  z.Autorizo == false && !(z.Catalogos_ctTipoIncidencia.Incidencia == "FALTA HORAS CLUB"))
                     ||( z.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISIÓN") && z.Autorizo == false)
                     ||( z.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO") && z.Autorizo == false)
                     || z.Incidencia_ctJustificacion.IncidenciaJustificacion.Contains("OMISIÓN")
                     )
                     && (z.FechaInicio.Month == Mes)
                     ).ToList();
                    if (pa1.Count() > 0)
                    {
                        vit.PuntualidadAsistencia = true;
                    }


                }
                else
                {
                    var pa2 = db.IncidenciaPermiso_stIncidenciaTrabajador
                     .Where(
                        z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == p.IdTrabajador
                     && (
                     (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && RelacionLaboral == "ADMINISTRATIVO" && z.Autorizo == false)
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && RelacionLaboral == "DOCENTE" && z.Autorizo == false && !(z.Catalogos_ctTipoIncidencia.Incidencia == "FALTA HORAS CLUB"))
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISIÓN") && z.Autorizo == false)
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO") && z.Autorizo == false)
                     || z.Incidencia_ctJustificacion.IncidenciaJustificacion.Contains("OMISIÓN")

                     )
                     && ((z.FechaInicio.Year == aaaa && z.FechaInicio.Month == Mes) && (z.FechaInicio.Day >= diainicialquincena && z.FechaInicio.Day <= diafinalquincena))
                     ).ToList();
                    if (pa2.Count() > 0)
                    {
                        vit.PuntualidadAsistencia = true;
                    }


                }

                Listaincidencias.Add(vit);

            

            }
            EstructuraIncidencias ei = new EstructuraIncidencias();
            ei.InicidenciasTrabajadores = Listaincidencias;

            return PartialView(ei);

        }
        public ActionResult CerrarIncidencias()
        {
            //var dtrabajador = db.vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == IdTrabajador).FirstOrDefault();
            //ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.IdQuincenaMesA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");

            return PartialView();
        }
        public ActionResult cambiarquincena(long id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return Json(new { Valid = false, Message = "No se encontró la incidencia, Id="+incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajador });
            }
            if (incidenciaPermiso_stIncidenciaTrabajador.EsAplicada)
            {
                return Json(new { Valid = false, Message = "La incidencia ya fue aplicada, no es posible cambiar la quincena para nómina"});

            }
            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdIncidenciaTrabajador == id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            var dtrabajador = db.vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == IdTrabajador && x.RestringirMenu == null).FirstOrDefault();
            ViewBag.IdTrabajador = IdTrabajador;
            ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.QuincenaMes = incidenciaPermiso_stIncidenciaTrabajador.QuincenaParaNomina;
            ViewBag.Año = incidenciaPermiso_stIncidenciaTrabajador.AñoParaNomina;
            ViewBag.IdQuincenaMes = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetQuincenaMes(), "IdQuincenaMes", "QuincenaMes");
            ViewBag.IdAAAAA = new SelectList(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.GetAñosAsistencia(), "IdAño", "Año");

            return PartialView(incidenciaPermiso_stIncidenciaTrabajador);
        }
        [HttpPost]

        public ActionResult cambiarquincena(long id,int quincena, int año)
        {
            //long id = System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);
            //int quincena = System.Convert.ToInt32(Request.Form["hfQuincenaMesCambio"]);
            //int año = System.Convert.ToInt32(Request.Form["hfAnioCambio"]);
            if (quincena == 0 || año ==0)
            {
                return Json(new { Valid = false, Message = "Deberá seleccionar un año y una quincena" });

            }
            var usuario = Seguridad.Identidad.Usuario();
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return Json(new { Valid = false, Message = "No se encontró la incidencia, Id=" + incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaTrabajador });
            }
            incidenciaPermiso_stIncidenciaTrabajador.QuincenaParaNomina = db.Catalogos_ctQuincenaMes.Where(z=>z.IdQuincenaMes==quincena).FirstOrDefault().QuincenaMes;
            incidenciaPermiso_stIncidenciaTrabajador.AñoParaNomina = año;
            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = "La quincena y el año para nómina se grabaron exitosamente" });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        [HttpPost]
        public ActionResult CerrarIncidencias(string ida, short idarea, short idqm, string rol, short idia, short idqma)
        {
            string link = "../IncidenciaPermisoTrabajador/PivotIncidencias?ida=" + ida + "&idarea=" + idarea + "&idqm=" + idqm + "&rol=" + rol;

            Uri myUri = new Uri(link, UriKind.Relative);
            string area = db.Catalogos_ctEstructuraOrganica.Where(x => x.IdEstructuraOrganica == idarea).FirstOrDefault().EstructuraOrganica;

            string año = ida;
            DateTime FechaInicial = DateTime.MinValue;
            DateTime FechaFinal = DateTime.MinValue;

            Boolean esquincenapar = false;
            short NoQuincena = System.Convert.ToInt16(db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().QuincenaMes);
            string NoQuincenaNomina = db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqma).FirstOrDefault().QuincenaMes;

            ViewBag.ol = rol;
            ViewBag.NoQuincena = NoQuincena;
            ViewBag.NombreMes = db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().Catalogos_ctMes.Mes;
            string NoMes = System.Convert.ToString(db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().IdMes);
            short Mes = System.Convert.ToInt16(NoMes);
            if (NoQuincena % 2 == 0)
            {
                esquincenapar = true;
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes + "-16");
                switch (NoMes)
                {
                    case "2":
                        Boolean esbisiesto = System.DateTime.IsLeapYear(Convert.ToInt32(año));
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-29");
                        break;
                    case "4":
                    case "6":
                    case "9":
                    case "11":
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-30");
                        break;
                    default:
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-31");
                        break;
                }
            }
            else
            {
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes);
                FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-15");
            }
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string msj = "El proceso de cerrar incidencias se realizó exitosamente !!";

            string query;

            query = @"select a.IdIncidenciaTrabajador
from IncidenciaPermiso_stIncidenciaTrabajador a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
where b.IdEstructuraOrganica=" + idarea + " and (a.EsCerrada=0 or a.EsCerrada is null) and (a.IdTipoIncidencia!=0)  and (cast(a.FechaInicio as date)>=" + "'" + FechaInicial.ToShortDateString() + "'" + " and cast(a.FechaTermino as date)<=" + "'" + FechaFinal.ToShortDateString() + "')"
+ "order by a.FechaInicio";
            List<long> t = (List<long>)dp.connection.Query<long>(query);
            dp.Close();
            if (t.Count() == 0)
            {
                //MessageBox.Show(ViewData, TipoMensaje.Error, "No existen incidencias abiertas", "Error", myUri.ToString());
                //return View("VError");

                return Json(new { Valid = false, Message = "No existen incidencias abiertas" },JsonRequestBehavior.AllowGet);

            }
            // Cierra las incidencias de la quincena y el área
            //TransactionOptions transactionoptions1 = new TransactionOptions();
            //transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
              //using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                //{

                    foreach (var item in t)
                    {
                        IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(item);

                        incidenciaPermiso_stIncidenciaTrabajador.EsCerrada = true;
                incidenciaPermiso_stIncidenciaTrabajador.AñoParaNomina = idia;
                incidenciaPermiso_stIncidenciaTrabajador.QuincenaParaNomina = NoQuincenaNomina;
                        db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                            try
                            {

                                db.SaveChanges();
                    Models.RelojChecador rch = new Nova.Models.RelojChecador(true);
                    rch.CierreMes(idarea, FechaFinal.ToShortDateString(), NoQuincenaNomina, año);
                            }
                            catch (Exception ex)
                            {
                    //MessageBox.Show(ViewData, TipoMensaje.Error, ExceptionExtensions.GetOriginalException(ex).Message, "Error", myUri.ToString());
                    //return View("VError");

                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(ex).Message }, JsonRequestBehavior.AllowGet);
                }
                    }
            // scope.Complete();
            //}

            //MessageBox.Show(ViewData, TipoMensaje.Error, msj, "Error", myUri.ToString());
            //return View("VError");
            SendPushNotification("Cerró incidencias de la quincena: "+NoQuincena+" año: "+año+ "centro: "+ area , TypePushNotification.success, Session["Aplicacion"].ToString());
            return Json(new { Valid = true, Message = msj, JsonRequestBehavior.AllowGet });

        }

        public ActionResult ReporteIncidenciasPdf(string ida, short idarea, short idqm, string rol)
        {
            string año = ida;
            ViewBag.Año = año;
            int aaaa = Convert.ToInt32(año);

            DateTime FechaInicial = DateTime.MinValue;
            DateTime FechaFinal = DateTime.MinValue;
            var usuario = Seguridad.Identidad.Usuario();

            Boolean esquincenapar = false;
            short NoQuincena = System.Convert.ToInt16(db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().QuincenaMes);
            ViewBag.NoQuincena = NoQuincena;
            ViewBag.ol = rol;
            ViewBag.NombreMes = db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().Catalogos_ctMes.Mes;
            ViewBag.NombreArea = db.Catalogos_ctEstructuraOrganica.Where(z => z.IdEstructuraOrganica == idarea).FirstOrDefault().EstructuraOrganica;
            var datosdirector = db.vwDatosAspirantesTrabajadores.Where(z => (z.Categoria == "RESPONSABLE DEL CENTRO \"A\"" ||
                                                   z.Categoria == "RESPONSABLE DEL CENTRO \"B\"" ||
                                                   z.Categoria == "RESPONSABLE DEL CENTRO \"C\"" ||
                                                   z.Categoria == "DIRECTOR DE PLANTEL \"A\"" ||
                                                    z.Categoria == "JEFE DE DEPARTAMENTO" ||
                                                   z.Categoria == "DIRECTOR DE PLANTEL \"B\"") && z.IdEstructuraOrganicaFisica == idarea && z.EstatusTrabajador=="ALTA").FirstOrDefault();
            if (datosdirector == null)
            {
                ViewBag.DirectorArea = "";
                
                }
            else
            {
                ViewBag.DirectorArea = datosdirector.Nombre + " " + datosdirector.ApellidoPaterno + " " + datosdirector.ApellidoMaterno;

            }
            ViewBag.NombreUsuario = usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + usuario.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
            string NoMes = System.Convert.ToString(db.Catalogos_ctQuincenaMes.Where(x => x.IdQuincenaMes == idqm).FirstOrDefault().IdMes);
            short Mes = System.Convert.ToInt16(NoMes);
            if (NoQuincena % 2 == 0)
            {
                esquincenapar = true;
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes + "-16");
                switch (NoMes)
                {
                    case "2":
                        Boolean esbisiesto = System.DateTime.IsLeapYear(Convert.ToInt32(año));
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-29");
                        break;
                    case "4":
                    case "6":
                    case "9":
                    case "11":
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-30");
                        break;
                    default:
                        FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-31");
                        break;
                }
            }
            else
            {
                FechaInicial = System.Convert.ToDateTime(año + "-" + NoMes);
                FechaFinal = System.Convert.ToDateTime(año + "-" + NoMes + "-15");
            }
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query;

            //            query = @"select a.IdIncidenciaTrabajador,a.FechaInicio,a.FechaTermino,a.Horas,d.IdTrabajador,e.Nombre+' '+e.ApellidoPaterno+' '+e.ApellidoMaterno as Trabajador
            //,CASE WHEN j.RelacionLaboral='DOCENTE' then a.Horas else DATEDIFF(day, b.FechaInicio,a.FechaTermino) end as DiasHorasIncidencia
            //,CASE WHEN k.Incidencia='DÍAS ECONÓMICOS' then DATEDIFF(day, b.FechaInicio,a.FechaTermino) ELSE 0 end DiasEconomicos
            //,ka.Nombre+' '+ka.ApellidoPaterno+' '+ka.ApellidoMaterno as QuienAutorizo
            //,kj.Nombre+' '+kj.ApellidoPaterno+' '+kj.ApellidoMaterno as QuienJustifico
            //,kr.Nombre+' '+kr.ApellidoPaterno+' '+kr.ApellidoMaterno as QuienRegistro
            //,k.Incidencia, k.Nomenclatura,k.Color
            //,ij.IncidenciaJustificacion as IncidenciaJustico,ij.Nomenclatura as NomenclaturaJustifico,ij.Color ColorJustifico
            //,a.IdNominaTrabajador,f.EstructuraOrganica,h.Categoria
            //,a.Observaciones,j.RelacionLaboral,l.ConvenioLaboral,a.EsAplicada,a.Autorizo,a.DescripcionJustificacion
            //,a.FechaAutorizacion,a.FechaCreacion,a.FechaJustificacion
            //,a.EsJustificacionExtemporanea
            //,a.IdIncidenciaJustificacion
            //,a.EsCancelada
            //,a.EsCerrada
            //from IncidenciaPermiso_stIncidenciaTrabajador a
            //inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
            //inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
            //inner join Kardex_ctTrabajador d on d.IdTrabajador = c.IdTrabajador
            //inner join Kardex_ctDatosPersonales e on d.IdKardex= e.IdKardex
            //inner join Catalogos_ctEstructuraOrganica f on b.IdEstructuraOrganica =f.IdEstructuraOrganica
            //inner join Plazas_stDistribucionPlazaCategoria g on b.IdDistribucionPlazaCategoria=g.IdDistribucionPlazaCategoria
            //inner join Plazas_ctCategoria h on g.IdCategoria=h.IdCategoria
            //inner join Convenios_stRelacionConvenioLaboral i on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
            //inner join Catalogos_ctRelacionLaboral j on i.IdRelacionLaboral=j.IdRelacionLaboral
            //inner join Catalogos_ctTipoIncidencia k on a.IdTipoIncidencia=k.IdTipoIncidencia
            //inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=i.IdConvenioLaboral

            //--Autorizo
            //left join Convenios_stConvenioLaboralTrabajadorCategoria ca on a.IdConvenioLaboralTrabajadorCategoriaAutorizo=ca.IdConvenioLaboralTrabajadorCategoria
            //left join Convenios_stConvenioLaboralTrabajador la on la.IdConvenioLaboralTrabajador= ca.IdConvenioLaboralTrabajador
            //left join Kardex_ctTrabajador ta on ta.IdTrabajador=la.IdTrabajador
            //left join Kardex_ctDatosPersonales ka on ka.IdKardex = ta.IdKardex
            //--Justifico
            //left join Convenios_stConvenioLaboralTrabajadorCategoria cj on a.IdConvenioLaboralTrabajadorCategoriaJustifico=cj.IdConvenioLaboralTrabajadorCategoria
            //left join Convenios_stConvenioLaboralTrabajador lj on lj.IdConvenioLaboralTrabajador= cj.IdConvenioLaboralTrabajador
            //left join Kardex_ctTrabajador tj on tj.IdTrabajador=lj.IdTrabajador
            //left join Kardex_ctDatosPersonales kj on kj.IdKardex = tj.IdKardex
            //--Registro
            //left join Convenios_stConvenioLaboralTrabajadorCategoria cr on a.IdConvenioLaboralTrabajadorCategoriaRegistro=cr.IdConvenioLaboralTrabajadorCategoria
            //left join Convenios_stConvenioLaboralTrabajador lr on lr.IdConvenioLaboralTrabajador= cr.IdConvenioLaboralTrabajador
            //left join Kardex_ctTrabajador tr on tr.IdTrabajador=lr.IdTrabajador
            //left join Kardex_ctDatosPersonales kr on kr.IdKardex = tr.IdKardex
            //--Incidencia Justificación
            //left join Incidencia_ctJustificacion ij on ij.IdIncidenciaJustificacion = a.IdIncidenciaJustificacion
            //where b.IdEstructuraOrganica=" + idarea + " and (a.IdTipoIncidencia=2 or a.IdTipoIncidencia=31 or a.IdTipoIncidencia=36 or a.IdTipoIncidencia=8 or a.IdTipoIncidencia=32 or a.IdTipoIncidencia=37 or a.IdTipoIncidencia=38 or a.IdTipoIncidencia=35 or a.IdTipoIncidencia=43)  and cast(a.FechaInicio as date)>=" + "'" + FechaInicial.ToShortDateString() + "'" + " and cast(a.FechaTermino as date)<=" + "'" + FechaFinal.ToShortDateString() + "'"
            //+ "order by d.IdTrabajador,a.FechaInicio";
            query = @"select IdIncidenciaTrabajador=NULL,FechaInicio=NULL,FechaTermino=NULL,Horas=NULL,tiempofuera=NULL,IdTrabajador,Nombre+' '+ApellidoPaterno+' '+ApellidoMaterno as Trabajador
,DiasHorasIncidencia=NULL
,DiasEconomicos=NULL
,QuienAutorizo=NULL
,QuienJustifico=NULL
,QuienRegistro=NULL
,Incidencia=NULL,Nomenclatura=NULL,Color=NULL
,IncidenciaJustico=NULL,NomenclaturaJustifico=NULL,ColorJustifico=NULL
,IdNominaTrabajador=NULL,EstructuraOrganica=NULL,Categoria=Categoria
,Observaciones=NULL,RelacionLaboral,ConvenioLaboral,EsAplicada=NULL,Autorizo=NULL,DescripcionJustificacion=NULL
,FechaAutorizacion=NULL,FechaCreacion=NULL,FechaJustificacion=NULL
,EsJustificacionExtemporanea=NULL
,IdIncidenciaJustificacion=NULL
,EsCancelada=NULL
,EsCerrada=NULL
,CURP
,FechaTermino as FechaTerminoConvenio
,IdModalidadEstudio
,QuincenaParaNomina=NULL
,AñoParaNomina=NULL
from vwDatosAspirantesTrabajadores 
where IdEstructuraOrganicaFisica=" + idarea + " and EstatusTrabajador='ALTA'" +
" and IdConvenioLaboralTrabajadorCategoria not in (select IdConvenioLaboralTrabajadorCategoria from IncidenciaPermiso_stIncidenciaTrabajador where IdEstructuraOrganica=" + idarea + " and (IdTipoIncidencia=2 or IdTipoIncidencia=31 or IdTipoIncidencia=36 or IdTipoIncidencia=8 or IdTipoIncidencia=32 or IdTipoIncidencia=37 or IdTipoIncidencia=38 or IdTipoIncidencia=35 or IdTipoIncidencia=43) and cast(FechaInicio as date)>=" + "'" + FechaInicial.ToShortDateString() + "'" + " and cast(FechaTermino as date)<=" + "'" + FechaFinal.ToShortDateString() + "')"
+ " union all"
+ @" select a.IdIncidenciaTrabajador,a.FechaInicio,a.FechaTermino,a.Horas,a.tiempofuera,d.IdTrabajador,e.Nombre+' '+e.ApellidoPaterno+' '+e.ApellidoMaterno as Trabajador
,CASE WHEN j.RelacionLaboral='DOCENTE' then a.Horas else DATEDIFF(day, b.FechaInicio,a.FechaTermino) end as DiasHorasIncidencia
,CASE WHEN k.Incidencia='DÍAS ECONÓMICOS' then DATEDIFF(day, b.FechaInicio,a.FechaTermino) ELSE 0 end DiasEconomicos
,ka.Nombre+' '+ka.ApellidoPaterno+' '+ka.ApellidoMaterno as QuienAutorizo
,kj.Nombre+' '+kj.ApellidoPaterno+' '+kj.ApellidoMaterno as QuienJustifico
,kr.Nombre+' '+kr.ApellidoPaterno+' '+kr.ApellidoMaterno as QuienRegistro
,k.Incidencia, k.Nomenclatura,k.Color
,ij.IncidenciaJustificacion as IncidenciaJustico,ij.Nomenclatura as NomenclaturaJustifico,ij.Color ColorJustifico
,a.IdNominaTrabajador,f.EstructuraOrganica,h.Categoria
,a.Observaciones,j.RelacionLaboral,l.ConvenioLaboral,a.EsAplicada,a.Autorizo,a.DescripcionJustificacion
,a.FechaAutorizacion,a.FechaCreacion,a.FechaJustificacion
,a.EsJustificacionExtemporanea
,a.IdIncidenciaJustificacion
,a.EsCancelada
,a.EsCerrada
,e.CURP
,b.FechaTermino as FechaTerminoConvenio
,f.IdModalidadEstudio
,a.QuincenaParaNomina
,a.AñoParaNomina
from IncidenciaPermiso_stIncidenciaTrabajador a
inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador d on d.IdTrabajador = c.IdTrabajador
inner join Kardex_ctDatosPersonales e on d.IdKardex= e.IdKardex
inner join Catalogos_ctEstructuraOrganica f on b.IdEstructuraOrganica =f.IdEstructuraOrganica
inner join Plazas_stDistribucionPlazaCategoria g on b.IdDistribucionPlazaCategoria=g.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria h on g.IdCategoria=h.IdCategoria
inner join Convenios_stRelacionConvenioLaboral i on h.IdRelacionConvenioLaboral=i.IdRelacionConvenioLaboral
inner join Catalogos_ctRelacionLaboral j on i.IdRelacionLaboral=j.IdRelacionLaboral
inner join Catalogos_ctTipoIncidencia k on a.IdTipoIncidencia=k.IdTipoIncidencia
inner join Catalogos_ctConvenioLaboral l on l.IdConvenioLaboral=i.IdConvenioLaboral

--Autorizo
left join Convenios_stConvenioLaboralTrabajadorCategoria ca on a.IdConvenioLaboralTrabajadorCategoriaAutorizo=ca.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador la on la.IdConvenioLaboralTrabajador= ca.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador ta on ta.IdTrabajador=la.IdTrabajador
left join Kardex_ctDatosPersonales ka on ka.IdKardex = ta.IdKardex
--Justifico
left join Convenios_stConvenioLaboralTrabajadorCategoria cj on a.IdConvenioLaboralTrabajadorCategoriaJustifico=cj.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador lj on lj.IdConvenioLaboralTrabajador= cj.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador tj on tj.IdTrabajador=lj.IdTrabajador
left join Kardex_ctDatosPersonales kj on kj.IdKardex = tj.IdKardex
--Registro
left join Convenios_stConvenioLaboralTrabajadorCategoria cr on a.IdConvenioLaboralTrabajadorCategoriaRegistro=cr.IdConvenioLaboralTrabajadorCategoria
left join Convenios_stConvenioLaboralTrabajador lr on lr.IdConvenioLaboralTrabajador= cr.IdConvenioLaboralTrabajador
left join Kardex_ctTrabajador tr on tr.IdTrabajador=lr.IdTrabajador
left join Kardex_ctDatosPersonales kr on kr.IdKardex = tr.IdKardex
--Incidencia Justificación
left join Incidencia_ctJustificacion ij on ij.IdIncidenciaJustificacion = a.IdIncidenciaJustificacion
where b.IdEstructuraOrganica=" + idarea + " and (a.IdTipoIncidencia=2 or a.IdTipoIncidencia=31 or a.IdTipoIncidencia=36 or a.IdTipoIncidencia=8 or a.IdTipoIncidencia=32 or a.IdTipoIncidencia=37 or a.IdTipoIncidencia=38 or a.IdTipoIncidencia=35 or a.IdTipoIncidencia=43 or a.IdTipoIncidencia=58)  and cast(a.FechaInicio as date)>=" + "'" + FechaInicial.ToShortDateString() + "'" + " and cast(a.FechaTermino as date)<=" + "'" + FechaFinal.ToShortDateString() + "'"
+ " order by 23 ,35";

            List<IncidenciaTrabajador> t = (List<IncidenciaTrabajador>)dp.connection.Query<IncidenciaTrabajador>(query);

            dp.Close();
            // Genera leyendas reporte

            List<LeyendasReporte> lLey = new List<LeyendasReporte>();
            List<LeyendasReporte> lLey2 = new List<LeyendasReporte>();

            lLey = t.Where(z=>z.IdIncidenciaJustificacion != 0).GroupBy(x => new { x.IncidenciaJustico,x.NomenclaturaJustifico }).Select(z => new LeyendasReporte { Incidencia = z.Key.IncidenciaJustico, Nomenclatura=z.Key.NomenclaturaJustifico }).ToList();
            lLey2 = t.Where(z => z.IdIncidenciaJustificacion == 0 && z.Incidencia != null).GroupBy(x => new { x.Incidencia, x.Nomenclatura }).Select(z => new LeyendasReporte { Incidencia = z.Key.Incidencia, Nomenclatura = z.Key.Nomenclatura }).ToList();
            lLey.AddRange(lLey2);
            ViewBag.LeyendasReporte = lLey;
            // Grupo por Idtrabajador
            var trabajadores = t.GroupBy(x => x.IdTrabajador).Select(z => new { IdTrabajador = z.Key }).ToList();
            var encuentracerrada = t.Where(z => z.EsCerrada == true).ToList();
            ViewBag.ReporteValido = "NO";
            if (encuentracerrada.Count>0)
            {
                ViewBag.ReporteValido = "SI";
            }
            // pivot incidencias por trabajador
            List<VistaIncidenciaTrabajador> Listaincidencias = new List<VistaIncidenciaTrabajador>();
            // Obtiene día inicial y final de la quincena
            short diainicialquincena = Convert.ToByte(FechaInicial.ToShortDateString().Substring(0, 2));
            short diafinalquincena = Convert.ToByte(FechaFinal.ToShortDateString().Substring(0, 2));
            short diaincidencia = 0;
            ViewBag.diainicialquincena = diainicialquincena;
            ViewBag.diafinalquincena = diafinalquincena;
            ViewBag.FechaInicial = FechaInicial.Date.ToString();
            ViewBag.FechaFinal = FechaFinal.Date.ToString();
            int faltas;
            int permisoseconomicos;

            string tobservaciones;

            foreach (var p in trabajadores)
            {
                var datostrabajador = t.Where(x => x.IdTrabajador == p.IdTrabajador).FirstOrDefault();


                int IdTrabajador = datostrabajador.IdTrabajador;
                string Trabajador = datostrabajador.Trabajador;
                string Categoria = datostrabajador.Categoria;
                string RelacionLaboral = datostrabajador.RelacionLaboral;
                string ConvenioLaboral = datostrabajador.ConvenioLaboral;

                faltas = 0;
                permisoseconomicos = 0;
                tobservaciones = "";
                VistaIncidenciaTrabajador vit = new VistaIncidenciaTrabajador();
                vit.Id = IdTrabajador;
                vit.Trabajador = Trabajador;
                vit.Categoria = Categoria;
                vit.ConvenioLaboral = ConvenioLaboral;
                vit.RelacionLaboral = RelacionLaboral;

                for (DateTime date = FechaInicial; date <= FechaFinal; date = date.AddDays(1.0))
                {
                    var incidenciasTrabajadordia = t.Where(z => z.IdTrabajador == p.IdTrabajador && z.FechaInicio.Year == date.Year && z.FechaInicio.Month == date.Month && z.FechaInicio.Day == date.Day).ToList();
                    if (incidenciasTrabajadordia.Count() > 0)
                    {

                        // Verifica a que día corresponde
                        diaincidencia = Convert.ToByte(date.ToShortDateString().Substring(0, 2));

                        foreach (var ind in incidenciasTrabajadordia)
                        {
                            
                            tobservaciones = tobservaciones + " " + ind.Observaciones;
                            if (ind.Nomenclatura != null)
                            {
                                if (RelacionLaboral == "ADMINISTRATIVO")
                                {
                                    if ((ind.Incidencia.Contains("FALTA") && ind.Autorizo == false)
                                        || (ind.Incidencia.Contains("FALTA") && ind.IncidenciaJustico == "DÍA ECONÓMICO" && ind.Autorizo == false)
                                        || (ind.Incidencia.Contains("OMISIÓN") && ind.Autorizo == false)

                                        )
                                    {
                                        faltas = faltas + 1;
                                    }

                                }
                                else
                                {
                                    if (RelacionLaboral == "DOCENTE")
                                    {
                                        if ((ind.Incidencia.Contains("FALTA") && ind.Autorizo == false)
                                        || (ind.Incidencia.Contains("FALTA") && ind.IncidenciaJustico == "DÍA ECONÓMICO" && ind.Autorizo == false)
                                        || (ind.Incidencia.Contains("OMISIÓN") && ind.Autorizo == false)

                                        )
                                        {
                                            faltas = faltas + ind.Horas;
                                        }

                                    }

                                }
                                if (ind.NomenclaturaJustifico != null)
                                {
                                    if (
                                        (ind.IncidenciaJustico == "DÍA ECONÓMICO" && ConvenioLaboral == "BASE" && ind.FechaAutorizacion != null && ind.Autorizo == true)
                                        //|| (ind.IncidenciaJustico == "DÍA ECONÓMICO" && ConvenioLaboral == "BASE" && (ind.FechaAutorizacion==null || ind.FechaAutorizacion.Year ==1))
                                        )
                                    {
                                        permisoseconomicos = permisoseconomicos + 1;
                                    }
                                }
                            }
                        }
                        switch (diaincidencia)
                        {
                            case 1:
                                vit.D1 = 1;
                                vit.IncidenciasDia1 = incidenciasTrabajadordia;
                                break;
                            case 2:
                                vit.D2 = 2;
                                vit.IncidenciasDia2 = incidenciasTrabajadordia;
                                break;
                            case 3:
                                vit.D3 = 3;
                                vit.IncidenciasDia3 = incidenciasTrabajadordia;
                                break;
                            case 4:
                                vit.D4 = 4;
                                vit.IncidenciasDia4 = incidenciasTrabajadordia;
                                break;
                            case 5:
                                vit.D5 = 5;
                                vit.IncidenciasDia5 = incidenciasTrabajadordia;
                                break;
                            case 6:
                                vit.D6 = 6;
                                vit.IncidenciasDia6 = incidenciasTrabajadordia;
                                break;
                            case 7:
                                vit.D7 = 7;
                                vit.IncidenciasDia7 = incidenciasTrabajadordia;
                                break;
                            case 8:
                                vit.D8 = 8;
                                vit.IncidenciasDia8 = incidenciasTrabajadordia;
                                break;
                            case 9:
                                vit.D9 = 9;
                                vit.IncidenciasDia9 = incidenciasTrabajadordia;
                                break;
                            case 10:
                                vit.D10 = 10;
                                vit.IncidenciasDia10 = incidenciasTrabajadordia;
                                break;
                            case 11:
                                vit.D11 = 11;
                                vit.IncidenciasDia11 = incidenciasTrabajadordia;
                                break;
                            case 12:
                                vit.D12 = 12;
                                vit.IncidenciasDia12 = incidenciasTrabajadordia;
                                break;
                            case 13:
                                vit.D13 = 13;
                                vit.IncidenciasDia13 = incidenciasTrabajadordia;
                                break;
                            case 14:
                                vit.D14 = 14;
                                vit.IncidenciasDia14 = incidenciasTrabajadordia;
                                break;
                            case 15:
                                vit.D15 = 15;
                                vit.IncidenciasDia15 = incidenciasTrabajadordia;
                                break;
                            case 16:
                                vit.D1 = 16;
                                vit.IncidenciasDia1 = incidenciasTrabajadordia;
                                break;
                            case 17:
                                vit.D2 = 17;
                                vit.IncidenciasDia2 = incidenciasTrabajadordia;
                                break;
                            case 18:
                                vit.D3 = 18;
                                vit.IncidenciasDia3 = incidenciasTrabajadordia;
                                break;
                            case 19:
                                vit.D4 = 19;
                                vit.IncidenciasDia4 = incidenciasTrabajadordia;
                                break;
                            case 20:
                                vit.D5 = 20;
                                vit.IncidenciasDia5 = incidenciasTrabajadordia;
                                break;
                            case 21:
                                vit.D6 = 21;
                                vit.IncidenciasDia6 = incidenciasTrabajadordia;
                                break;
                            case 22:
                                vit.D7 = 22;
                                vit.IncidenciasDia7 = incidenciasTrabajadordia;
                                break;
                            case 23:
                                vit.D8 = 23;
                                vit.IncidenciasDia8 = incidenciasTrabajadordia;
                                break;
                            case 24:
                                vit.D9 = 24;
                                vit.IncidenciasDia9 = incidenciasTrabajadordia;
                                break;
                            case 25:
                                vit.D10 = 25;
                                vit.IncidenciasDia10 = incidenciasTrabajadordia;
                                break;
                            case 26:
                                vit.D11 = 26;
                                vit.IncidenciasDia11 = incidenciasTrabajadordia;
                                break;
                            case 27:
                                vit.D12 = 27;
                                vit.IncidenciasDia12 = incidenciasTrabajadordia;
                                break;
                            case 28:
                                vit.D13 = 28;
                                vit.IncidenciasDia13 = incidenciasTrabajadordia;
                                break;
                            case 29:
                                vit.D14 = 29;
                                vit.IncidenciasDia14 = incidenciasTrabajadordia;
                                break;
                            case 30:
                                vit.D15 = 30;
                                vit.IncidenciasDia15 = incidenciasTrabajadordia;
                                break;
                            case 31:
                                vit.D16 = 31;
                                vit.IncidenciasDia16 = incidenciasTrabajadordia;
                                break;
                            default:
                                throw new Exception("Error al procesar las incidencias del trabajador " + Trabajador);


                        }
                    }
                }
                vit.Faltas = faltas;
                vit.PuntualidadAsistencia = false;
                vit.Observaciones = tobservaciones;
                vit.DiasEconomicos = permisoseconomicos;

                if ((NoQuincena % 2) == 0)
                {
                    var pa1 = db.IncidenciaPermiso_stIncidenciaTrabajador
                     .Where(
                        z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == p.IdTrabajador
                     && (
                     (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && RelacionLaboral == "ADMINISTRATIVO" && z.Autorizo == false)
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && RelacionLaboral == "DOCENTE" && z.Autorizo == false && !(z.Catalogos_ctTipoIncidencia.Incidencia == "FALTA HORAS CLUB"))
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISIÓN") && z.Autorizo == false)
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO") && z.Autorizo == false)
                     //|| z.Incidencia_ctJustificacion.IncidenciaJustificacion.Contains("OMISIÓN")
                     )
                     && (z.FechaInicio.Month == Mes)
                     ).ToList();
                    if (pa1.Count() > 0)
                    {
                        vit.PuntualidadAsistencia = true;
                    }


                }
                else
                {
                    var pa2 = db.IncidenciaPermiso_stIncidenciaTrabajador
                     .Where(
                        z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador == p.IdTrabajador
                     && (
                     (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && RelacionLaboral == "ADMINISTRATIVO" && z.Autorizo == false)
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && RelacionLaboral == "DOCENTE" && z.Autorizo == false && !(z.Catalogos_ctTipoIncidencia.Incidencia == "FALTA HORAS CLUB"))
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("OMISIÓN") && z.Autorizo == false)
                     || (z.Catalogos_ctTipoIncidencia.Incidencia.Contains("RETARDO") && z.Autorizo == false)
                     //|| z.Incidencia_ctJustificacion.IncidenciaJustificacion.Contains("OMISIÓN")
                     )
                     && ((z.FechaInicio.Year == aaaa && z.FechaInicio.Month == Mes) && (z.FechaInicio.Day >= diainicialquincena && z.FechaInicio.Day <= diafinalquincena))
                     ).ToList();
                    if (pa2.Count() > 0)
                    {
                        vit.PuntualidadAsistencia = true;
                    }


                }


                Listaincidencias.Add(vit);



            }
            EstructuraIncidencias ei = new EstructuraIncidencias();
            ei.InicidenciasTrabajadores = Listaincidencias;
            string modalidad = "Nomina_ReporteIncidencias" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            // return View(ei);
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 8;
            m.Right = 4;
            m.Top = 7;


            ////return View("ReporteMir", result.ToList());
            return new ViewAsPdf(ei) { PageSize = Rotativa.Options.Size.Letter, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

            //return View(ei);

        }

        // GET: IncidenciaPermiso_stIncidenciaTrabajador/Details/5
        public ActionResult Details(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }
        public ActionResult HorasClub(string id, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult HorasClub(Falta fhc)
        {
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);

            short Idmodalidad = 0;
            if (db.vwDatosAspirantesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault().IdModalidadEstudio.HasValue)
            {
                Idmodalidad = db.vwDatosAspirantesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault().IdModalidadEstudio.Value;
            }
             if (Idmodalidad != 2)
            {
                ModelState.AddModelError("E3", "Las horas club solo aplican para EMSAD");
            }
            if (fhc.Horas == 0)
            {
                ModelState.AddModelError("E1", "Debe ingresar las horas de la falta");
            }
            else
            {
                if (fhc.Horas > 12)
                {
                    ModelState.AddModelError("E2", "el número de horas no debe ser mayor a 12");

                }
                ipt.IdTipoIncidencia = 58;
                ipt.Horas = fhc.Horas;

            }

            DateTime fi = fhc.Dia;
            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            string msj = "Se grabó el retardo exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        public ActionResult Retardo(string id, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Retardo(Prima falta)
        {
            DateTime fi = falta.Dia;
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            if (rela == "DOCENTE")
            {
                    ipt.IdTipoIncidencia = 32;
                
            }
            else
            {
                ipt.IdTipoIncidencia = 31;

            }
            string msj = "Se grabó el retardo exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult omisionsalida(string id, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult omisionsalida(Prima falta)
        {
            DateTime fi = falta.Dia;
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;
            ipt.IdTipoIncidencia = 35;
            string msj = "Se grabó el retardo exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        public ActionResult Falta(string id,string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral= db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Falta(Falta falta)
        {
            DateTime fi = falta.Dia;
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = false;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            if (rela == "DOCENTE")
            {
               if (falta.Horas == 0)
                {
                    ModelState.AddModelError("E1","Debe ingresar las horas de la falta");
                }
                else
                {
                    if (falta.Horas >12)
                    {
                        ModelState.AddModelError("E2", "el número de horas no debe ser mayor a 12");

                    }
                    ipt.IdTipoIncidencia = 8;
                    ipt.Horas = falta.Horas;

                }
            }
            else
            {
                ipt.IdTipoIncidencia = 2;
                ipt.Horas = 0;

            }
            string msj = "La falta se grabó exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult Prima(string id, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Prima(Prima prima)
        {
            DateTime fi = prima.Dia;
            if (fi.DayOfWeek != DayOfWeek.Saturday)
            {
                                                  if (fi.DayOfWeek != DayOfWeek.Sunday)
                {
                    return Json(new { Valid = false, Message ="Error: La prima dominical aplica únicamente para sábado o domingo"});

                }
            }
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = true;
            ipt.FechaAutorizacion = DateTime.Now;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

                ipt.IdTipoIncidencia = 37;
            string msj = "La prima dominical se grabó exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult DiasDescanso(string id, string fi, string ff, string di, string df, string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            int idcltc = (int)db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;
            string relacionlaboral = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault().RelacionLaboral;

            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc = idcltc;
            ViewBag.RelacionLaboral = relacionlaboral;

            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0, 10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems, "Value", "Text");

            return PartialView();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult DiasDescanso(Prima falta)
        {
            DateTime fi = falta.Dia;
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            string rela = System.Convert.ToString(Request.Form["relacionlaboral"]);
            IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
            ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
            ipt.FechaInicio = fi;
            ipt.FechaTermino = fi;
            ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.FechaCreacion = fi;
            ipt.EsAplicada = false;
            ipt.EsSubsecuente = false;
            ipt.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ipt.Autorizo = true;
            ipt.FechaAutorizacion = DateTime.Now;
            ipt.EsCancelada = false;
            ipt.EsCerrada = false;
            ipt.Horas = 0;
            ipt.IdIncidenciaJustificacion = 0;
            ipt.EsFaltaDirecta = true;

            ipt.IdTipoIncidencia = 38;
            string msj = "El día de descanso se grabó exitosamente";


            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        public ActionResult Pase(string id,string fi, string ff, string di, string df,string nuquin, string nommes)
        {
            int Id = Convert.ToInt32(id);
            var trabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == Id && z.RestringirMenu==null).FirstOrDefault();
            DateTime fechainicial = Convert.ToDateTime(fi);
            DateTime fechafinal = Convert.ToDateTime(ff);
            ViewBag.fi = fechainicial.ToShortDateString();
            ViewBag.ff = fechafinal.ToShortDateString();
            ViewBag.di = di;
            ViewBag.df = df;
            ViewBag.nuquin = nuquin;
            ViewBag.nommes = nommes;
            ViewBag.Idcltc= trabajador.IdConvenioLaboralTrabajadorCategoria;
            ViewBag.Trabajador = trabajador.Nombre + " " + trabajador.ApellidoPaterno + " " + trabajador.ApellidoMaterno;




            List<SelectListItem> listaitems = new List<SelectListItem>();
            for (DateTime i = fechainicial; i <= fechafinal; i = i.AddDays(1))
            {
                SelectListItem sl = new SelectListItem();
                sl.Selected = false;
                sl.Text = i.Day.ToString() + "(" + Nova.Libraries.Dias.AbreviaturaDiaSemana(i.DayOfWeek) + ")";
                sl.Value = i.ToShortDateString().Substring(0,10);
                listaitems.Add(sl);
            }
            ViewBag.Dia = new SelectList(listaitems,"Value","Text");

            return PartialView();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Pase(Pase pase)
        {
            int idcltc = System.Convert.ToInt32(Request.Form["IdConvenioLaboralTrabajadorCategoria"]);
            DateTime fi =pase.Dia;
            string msj = "El pase de salida se grabó exitosamente";


            if (ModelState.IsValid)
            {
                IncidenciaPermiso_stIncidenciaTrabajador ipt = new IncidenciaPermiso_stIncidenciaTrabajador();
                ipt.IdConvenioLaboralTrabajadorCategoria = idcltc;
                ipt.IdTipoIncidencia = 43;
                ipt.FechaInicio = fi;
                ipt.FechaTermino = fi;
                ipt.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.FechaCreacion = fi;
                ipt.EsAplicada = false;
                ipt.EsSubsecuente = false;
                ipt.IdConvenioLaboralTrabajadorCategoriaRegistro= Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                ipt.Autorizo = true;
                ipt.FechaJustificacion = DateTime.Now;
                ipt.IdIncidenciaJustificacion = 36;
                ipt.FechaJustificacion = fi;
                ipt.EsFaltaDirecta = true;
                ipt.Horas = 0;
                ipt.EsCancelada = false;
                ipt.EsCerrada = false;
                ipt.TiempoFuera = pase.TiempoFuera;
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Add(ipt);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: IncidenciaPermiso_stIncidenciaTrabajador/Create
        public ActionResult Create(int id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidencia = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia");
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion");
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador");
            return View();
        }

        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Create
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdIncidenciaTrabajador,IdConvenioLaboralTrabajadorCategoria,IdTipoIncidencia,FechaInicio,FechaTermino,Observaciones,UserId,FechaCreacion,IdNominaTrabajador,EsAplicada,EsSubsecuente,DiasPagados100,DiasPagados40,DiasAcumulados,IdIncidenciaTrabajadorPadre,IdConvenioLaboralTrabajadorCategoriaRegistro,Autorizo,IdConvenioLaboralTrabajadorCategoriaAutorizo,IdIncidenciaJustificacion,IdConvenioLaboralTrabajadorCategoriaJustifico,DescripcionJustificacion,FechaJustificacion,QuincenasCalculadas,PercepcionDiaria,Horas,FechaAutorizacion,EsJustificacionExtemporanea")] IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador)
        {
            if (ModelState.IsValid)
            {
                db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciaPermiso_stIncidenciaTrabajador);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciaPermiso_stIncidenciaTrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaRegistro = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaRegistro);
            ViewBag.IdConvenioLaboralTrabajadorCategoriaAutorizo = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo);
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            ViewBag.IdNominaTrabajador = new SelectList(db.Nomina_stNominaTrabajador, "IdNominaTrabajador", "IdNominaTrabajador", incidenciaPermiso_stIncidenciaTrabajador.IdNominaTrabajador);
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }
        public ActionResult VerRegistrosReloj(int id, string fi = null, string ff = null)
        {
            string fii = null;
            string fff = null;
            if (fi != null)
            {
                fii = fi.Substring(0, 10);
                fff = ff.Substring(0, 10);
            }
            //ViewBag.NombreMes = nm;
            //ViewBag.NoQuincena = nq;
            ViewBag.Trabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == id && z.RestringirMenu==null).FirstOrDefault();
            //var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == id && DbFunctions.TruncateTime(x.FechaAsistencia) >= DbFunctions.TruncateTime(fii) &&  DbFunctions.TruncateTime(x.FechaAsistencia) <= DbFunctions.TruncateTime(fff)).OrderBy(z => z.FechaAsistencia).ToList(); 
            return PartialView(IncidenciaPermiso_stIncidenciaTrabajador.getAsistencias(id, fii, fff));
        }

        public ActionResult AsistenciasReloj(int id)
        {

            //ViewBag.NombreMes = nm;
            //ViewBag.NoQuincena = nq;
            ViewBag.Trabajador = db.vwDatosAspirantesTrabajadores.Where(z => z.IdTrabajador == id && z.RestringirMenu==null).FirstOrDefault();
            //var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == id && DbFunctions.TruncateTime(x.FechaAsistencia) >= DbFunctions.TruncateTime(fii) &&  DbFunctions.TruncateTime(x.FechaAsistencia) <= DbFunctions.TruncateTime(fff)).OrderBy(z => z.FechaAsistencia).ToList(); 
            return View("VerRegistrosReloj", IncidenciaPermiso_stIncidenciaTrabajador.getAsistencias(id, null, null));
        }



        // GET: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        public ActionResult JustificarIncidencia(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdIncidenciaTrabajador==id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
           var dtrabajador = db.vwDatosAspirantesTrabajadores.Where(x=>x.IdTrabajador == IdTrabajador && x.RestringirMenu == null).FirstOrDefault();
            ViewBag.IdTrabajador = IdTrabajador;
            ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.IdIncidenciaJustificacion = new SelectList(db.Incidencia_ctJustificacion.OrderBy(z=>z.IncidenciaJustificacion), "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == IdTrabajador && DbFunctions.TruncateTime(x.FechaAsistencia) == DbFunctions.TruncateTime(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio)).OrderBy(z => z.FechaAsistencia).ToList(); ;
            ViewBag.incidenciasreloj = incidenciasreloj;
            return PartialView(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult JustificarIncidencia()
        {
            long id =System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);
            int idij = System.Convert.ToInt32(Request.Form["hfIdincidenciajustificacion"]);
            string observacion = System.Convert.ToString(Request.Form["hfIdObservacion"]);

            var usuario = Seguridad.Identidad.Usuario();
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion=idij;
            var incidenciajustificacion = db.Incidencia_ctJustificacion.Where(z => z.IdIncidenciaJustificacion == idij).FirstOrDefault();
            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.Where(x => x.IdConvenioLaboralTrabajadorCategoria == incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            if (incidenciajustificacion.IncidenciaJustificacion== "DÍA ECONÓMICO")
            {
                var diaseconomicosmes = db.Catalogos_ctParametrosRelacionLaboral.Where(x => x.IdRelacionConvenioLaboral == datostrabajador.IdRelacionConvenioLaboral && x.FechaInicio.Year == DateTime.Now.Year).OrderByDescending(f => f.FechaFinal).FirstOrDefault();
                if (diaseconomicosmes != null)
                {
                    int diaseconomicosdisfrutadosaño = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                    && z.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year
                    && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                    && ((z.FechaAutorizacion != null && z.Autorizo == true) )
                    ).Count();

                    if (diaseconomicosdisfrutadosaño >= diaseconomicosmes.DiasEconomicosPorAño)
                    {
                        ModelState.AddModelError("error2", "Ya ha disfrutado sus " + diaseconomicosmes.DiasEconomicosPorAño + " días económicos permitidos por año");
                    }
                    else
                    { 
                        int diaseconomicosdisfrutadosmes = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                        && z.FechaInicio.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Month
                        && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                        && ((z.FechaAutorizacion != null  && z.Autorizo==true)||(z.FechaJustificacion != null && z.FechaAutorizacion == null) )
                        ).Count();
                        if (diaseconomicosdisfrutadosmes >= diaseconomicosmes.MaximoDiasEconomicosMensuales)
                        {
                            ModelState.AddModelError("error1", "Ya ha disfrutado sus " + diaseconomicosmes.MaximoDiasEconomicosMensuales + " días económicos permitidos por mes");
                        }
                    }
                }

            }
            incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = DateTime.Now;
            incidenciaPermiso_stIncidenciaTrabajador.Observaciones = observacion;
            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = usuario.IdConvenioLaboralTrabajadorCategoria;

            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = "La justificación de la incidencia se realizó exitosamente"});

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        [HttpPost] 
        public ActionResult EliminarPase(long id)
        {

            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = "Se eliminó exitosamente la incidencia" });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult EliminarJustificacion(long id)
        {

            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador.EsCerrada == true)
            {
                ModelState.AddModelError("E1","No es posible eliminar una incidencia cerrada");
            }

            if (ModelState.IsValid)
            {
                try
                {
                    incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaJustifico = null;
                    incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = 0;
                    incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = null;
                    incidenciaPermiso_stIncidenciaTrabajador.DescripcionJustificacion = null;
                    incidenciaPermiso_stIncidenciaTrabajador.Observaciones = null;
                    incidenciaPermiso_stIncidenciaTrabajador.EsAplicada = false;
                    incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                    incidenciaPermiso_stIncidenciaTrabajador.FechaAutorizacion = null;

                    db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = "Se eliminó exitosamente la justificación" });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        public ActionResult EliminarFalta(long id)
        {

            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            if (ModelState.IsValid)
            {
                try
                {
                    db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = "Se eliminó exitosamente la incidencia" });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: IncidenciaPermisoTrabajador/Edit/5
        public ActionResult AutorizarIncidencia(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdIncidenciaTrabajador == id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            var dtrabajador = db.vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == IdTrabajador).FirstOrDefault();
            ViewBag.IdTrabajador = IdTrabajador;
            ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.IdIncidenciaJustificacionA = new SelectList(db.Incidencia_ctJustificacion, "IdIncidenciaJustificacion", "IncidenciaJustificacion", incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion);
            var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == IdTrabajador && DbFunctions.TruncateTime(x.FechaAsistencia) == DbFunctions.TruncateTime(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio)).OrderBy(z => z.FechaAsistencia).ToList(); ;
            ViewBag.incidenciasreloj = incidenciasreloj;
            ViewBag.idij = incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion;
            return PartialView(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult AutorizarIncidencia()
        {
            int autorizo = System.Convert.ToInt32(Request.Form["hfautorizo"]);
            string observacion = System.Convert.ToString(Request.Form["Observaciones"]);

            string msj = "";
            long id = System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);
            int idij = System.Convert.ToInt32(Request.Form["Idincidenciajustificacion"]);
             if (idij == 0)
            {
                ModelState.AddModelError("Error", "Debe seleccionar una justificación");
            }

            //int idij = System.Convert.ToInt32(Request.Form["hfIdincidenciajustificacion"]);
            var usuario = Seguridad.Identidad.Usuario();
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = idij;
            incidenciaPermiso_stIncidenciaTrabajador.FechaAutorizacion = DateTime.Now;
            incidenciaPermiso_stIncidenciaTrabajador.Observaciones = observacion;

            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = usuario.IdConvenioLaboralTrabajadorCategoria;
            //incidenciaPermiso_stIncidenciaTrabajador.Observaciones = observacion;
            if (autorizo==1)
            {
                incidenciaPermiso_stIncidenciaTrabajador.Autorizo = false;
                msj = "La NO autorización de la incidencia se realizó exitosamente";

            }
            else
            {
                msj = "La autorización de la incidencia se realizó exitosamente";
                incidenciaPermiso_stIncidenciaTrabajador.Autorizo = true;
                //if (idijNuevo > 0)
                //{
                //    if (idijAnterior != idijNuevo)
                //    {
                //        incidenciaPermiso_stIncidenciaTrabajador.Observaciones = incidenciaPermiso_stIncidenciaTrabajador.Observaciones
                //        + " se sustituyo la justificación: " + db.Incidencia_ctJustificacion.Where(z => z.IdIncidenciaJustificacion == idijAnterior).FirstOrDefault().IncidenciaJustificacion
                //        + " por " + db.Incidencia_ctJustificacion.Where(z => z.IdIncidenciaJustificacion == idijNuevo).FirstOrDefault().IncidenciaJustificacion;
                //        incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion = idijNuevo;
                //    }
                //}

            }
            var incidenciajustificacion = db.Incidencia_ctJustificacion.Where(z => z.IdIncidenciaJustificacion == idij).FirstOrDefault();

            var datostrabajador = db.vwDatosAspirantesTrabajadoresHistorial.Where(x => x.IdConvenioLaboralTrabajadorCategoria == incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            if (incidenciajustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO")
            {
                var diaseconomicosmes = db.Catalogos_ctParametrosRelacionLaboral.Where(x => x.IdRelacionConvenioLaboral == datostrabajador.IdRelacionConvenioLaboral && x.FechaInicio.Year == DateTime.Now.Year).OrderByDescending(f => f.FechaFinal).FirstOrDefault();
                if (diaseconomicosmes != null)
                {
                    int diaseconomicosdisfrutadosaño = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                    && z.FechaInicio.Year == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Year
                    && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                    && ((z.FechaAutorizacion != null && z.Autorizo == true) || (z.FechaJustificacion != null && z.FechaAutorizacion == null))
                    ).Count();

                    if (diaseconomicosdisfrutadosaño > diaseconomicosmes.DiasEconomicosPorAño)
                    {
                        ModelState.AddModelError("error2", "Ya ha disfrutado sus " + diaseconomicosmes.DiasEconomicosPorAño + " días económicos permitidos por año");
                    }
                    else
                    {
                        int diaseconomicosdisfrutadosmes = (int)db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == datostrabajador.IdTrabajador
                        && z.FechaInicio.Month == incidenciaPermiso_stIncidenciaTrabajador.FechaInicio.Month
                        && z.Incidencia_ctJustificacion.IncidenciaJustificacion == "DÍA ECONÓMICO"
                        && ((z.FechaAutorizacion != null && z.Autorizo == true) || (z.FechaJustificacion != null && z.FechaAutorizacion == null))
                        ).Count();
                        if (diaseconomicosdisfrutadosmes > diaseconomicosmes.MaximoDiasEconomicosMensuales)
                        {
                            ModelState.AddModelError("error1", "Ya ha disfrutado sus " + diaseconomicosmes.MaximoDiasEconomicosMensuales + " días económicos permitidos por mes");
                        }
                    }
                }

            }
             if (datostrabajador.IdModalidadEstudio==0)
            {
                if (!incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion.HasValue)
                {
                    incidenciaPermiso_stIncidenciaTrabajador.FechaJustificacion = DateTime.Now;
                }
            }
            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }
        public ActionResult CancelarIncidencia(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            int IdTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(z => z.IdIncidenciaTrabajador == id).FirstOrDefault().Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            var dtrabajador = db.vwDatosAspirantesTrabajadores.Where(x => x.IdTrabajador == IdTrabajador).FirstOrDefault();
            ViewBag.IdTrabajador = IdTrabajador;
            ViewBag.Trabajador = dtrabajador.Nombre + " " + dtrabajador.ApellidoPaterno + " " + dtrabajador.ApellidoMaterno;
            ViewBag.Justificacion = db.Incidencia_ctJustificacion.Where(s=>s.IdIncidenciaJustificacion== incidenciaPermiso_stIncidenciaTrabajador.IdIncidenciaJustificacion).FirstOrDefault().IncidenciaJustificacion;
            var incidenciasreloj = db.Nomina_RelojChecadorAsistencia.Where(x => x.IdTrabajador == IdTrabajador && DbFunctions.TruncateTime(x.FechaAsistencia) == DbFunctions.TruncateTime(incidenciaPermiso_stIncidenciaTrabajador.FechaInicio)).OrderBy(z => z.FechaAsistencia).ToList(); ;
            ViewBag.incidenciasreloj = incidenciasreloj;
            return PartialView(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermiso_stIncidenciaTrabajador/Edit/5
        // To protect from overposting attacks, please enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult CancelarIncidencia()
        {

            string msj = "La Cancelación de la Incidencia se realizó exitosamente !!";
            long id = System.Convert.ToInt64(Request.Form["IdIncidenciaTrabajador"]);

            var usuario = Seguridad.Identidad.Usuario();
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);

            incidenciaPermiso_stIncidenciaTrabajador.IdConvenioLaboralTrabajadorCategoriaAutorizo = usuario.IdConvenioLaboralTrabajadorCategoria;
            incidenciaPermiso_stIncidenciaTrabajador.EsCancelada = true;
            if (ModelState.IsValid)
            {
                db.Entry(incidenciaPermiso_stIncidenciaTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: IncidenciaPermisoTrabajador/Delete/5
        public ActionResult Delete(long? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciaPermiso_stIncidenciaTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciaPermiso_stIncidenciaTrabajador);
        }

        // POST: IncidenciaPermisoTrabajador/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(long id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciaPermiso_stIncidenciaTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciaPermiso_stIncidenciaTrabajador);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
