﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using DevExpress.Web.Mvc;

namespace Nova.Controllers
{
    public class IncidenciaTrabajadorController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        //
        // GET: /IncidenciaTrabajador/
        Nova.Models.bdNovaEntities db1 = new Nova.Models.bdNovaEntities();

        public ActionResult Index(int IdConvenioLaboralTrabajadorCategoria = 0)
        {
            if (IdConvenioLaboralTrabajadorCategoria > 0)
            {
                var model = db1.IncidenciaPermiso_stIncidenciaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                //ViewData["Model"] = model;
                //ViewData["IdConvenioLaboralTrabajador"] = IdConvenioLaboralTrabajador;
                Session["Datos"] = model;
                Session["Convenios"] = Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador.getConveniosLaborales(IdConvenioLaboralTrabajadorCategoria);
                Session["IdConvenioLaboralTrabajador"] = IdConvenioLaboralTrabajadorCategoria;


                //var incidenciapermiso_stincidenciatrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Include(i => i.Catalogos_ctTipoIncidencia).Include(i => i.Convenios_stConvenioLaboralTrabajador);
                return View(model);
            }
            else
                throw new ApplicationException("No hay un convenio laboral vigente para este trabajador");


        }

        //
        // GET: /IncidenciaTrabajador/Details/5

        public ActionResult Details(long id = 0)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciapermiso_stincidenciatrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciapermiso_stincidenciatrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciapermiso_stincidenciatrabajador);
        }

        //
        // GET: /IncidenciaTrabajador/Create

        public ActionResult Create()
        {
            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia");
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador");
            return View();
        }

        //
        // POST: /IncidenciaTrabajador/Create

        [HttpPost]
        public ActionResult Create(IncidenciaPermiso_stIncidenciaTrabajador incidenciapermiso_stincidenciatrabajador)
        {
            if (ModelState.IsValid)
            {
                db.IncidenciaPermiso_stIncidenciaTrabajador.Add(incidenciapermiso_stincidenciatrabajador);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciapermiso_stincidenciatrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", incidenciapermiso_stincidenciatrabajador.IdConvenioLaboralTrabajadorCategoria);
            return View(incidenciapermiso_stincidenciatrabajador);
        }

        //
        // GET: /IncidenciaTrabajador/Edit/5

        public ActionResult Edit(long id = 0)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciapermiso_stincidenciatrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciapermiso_stincidenciatrabajador == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciapermiso_stincidenciatrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", incidenciapermiso_stincidenciatrabajador.IdConvenioLaboralTrabajadorCategoria);
            return View(incidenciapermiso_stincidenciatrabajador);
        }

        //
        // POST: /IncidenciaTrabajador/Edit/5

        [HttpPost]
        public ActionResult Edit(IncidenciaPermiso_stIncidenciaTrabajador incidenciapermiso_stincidenciatrabajador)
        {
            if (ModelState.IsValid)
            {
                db.Entry(incidenciapermiso_stincidenciatrabajador).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdTipoIncidencia = new SelectList(db.Catalogos_ctTipoIncidencia, "IdTipoIncidencia", "Incidencia", incidenciapermiso_stincidenciatrabajador.IdTipoIncidencia);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", incidenciapermiso_stincidenciatrabajador.IdConvenioLaboralTrabajadorCategoria);
            return View(incidenciapermiso_stincidenciatrabajador);
        }

        //
        // GET: /IncidenciaTrabajador/Delete/5

        public ActionResult Delete(long id = 0)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciapermiso_stincidenciatrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            if (incidenciapermiso_stincidenciatrabajador == null)
            {
                return HttpNotFound();
            }
            return View(incidenciapermiso_stincidenciatrabajador);
        }

        //
        // POST: /IncidenciaTrabajador/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(long id)
        {
            IncidenciaPermiso_stIncidenciaTrabajador incidenciapermiso_stincidenciatrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Find(id);
            db.IncidenciaPermiso_stIncidenciaTrabajador.Remove(incidenciapermiso_stincidenciatrabajador);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }


        [ValidateInput(false)]
        public ActionResult _pvGridIncidenciasPermisos()
        {

            return PartialView("__pvGridIncidenciasPermisos", Session["Datos"]);
        }

        public ActionResult MultiColumnComboBoxPartial()
        {

            return PartialView();
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridIncidenciasPermisosAddNew(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador item)
        {
            item.FechaCreacion = DateTime.Now;
            // string n= Session["IdConvenioLaboralTrabajador"].ToString();
            // item.IdConvenioLaboralTrabajador = ConvertToInt.ConvertToInt16(n);


            string[] cl = Request["IdConvenioLaboralTrabajador"].Split(',');
            item.IdConvenioLaboralTrabajadorCategoria = ConvertToInt.ConvertToInt16(cl[0]);
            var model = db1.IncidenciaPermiso_stIncidenciaTrabajador;

            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db1.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors." + ModelState.Values.SelectMany(m => m.Errors)
                                 .Select(e => e.ErrorMessage).ToList().FirstOrDefault().ToString();
            return PartialView("__pvGridIncidenciasPermisos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridIncidenciasPermisosUpdate(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador item)
        {
            var model = db1.IncidenciaPermiso_stIncidenciaTrabajador;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdIncidenciaTrabajador == item.IdIncidenciaTrabajador);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db1.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvGridIncidenciasPermisos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridIncidenciasPermisosDelete(System.Int64 IdIncidenciaTrabajador)
        {
            var model = db1.IncidenciaPermiso_stIncidenciaTrabajador;
            if (IdIncidenciaTrabajador != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdIncidenciaTrabajador == IdIncidenciaTrabajador);
                    if (item != null)
                        model.Remove(item);
                    db1.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("__pvGridIncidenciasPermisos", model.ToList());
        }
        Nova.Models.bdNovaEntities db2 = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult GridViewPartial()
        {
            //var model = db2.IncidenciaPermiso_stIncidenciaTrabajador;
            return PartialView("_GridViewPartial", Session["Datos"]);
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult GridViewPartialAddNew(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador item)
        {

            item.FechaCreacion = DateTime.Now;
            item.IdConvenioLaboralTrabajadorCategoria = System.Convert.ToInt16(Session["IdConvenioLaboralTrabajador"]);
            item.UserId = 0;
            var model = db2.IncidenciaPermiso_stIncidenciaTrabajador;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db2.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";

            Int16 id = System.Convert.ToInt16(Session["IdConvenioLaboralTrabajador"]);
            var modelo = db2.IncidenciaPermiso_stIncidenciaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == id).ToList();
            //ViewData["Model"] = model;
            Session["Datos"] = modelo;
            return PartialView("_GridViewPartial", Session["Datos"]);
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult GridViewPartialUpdate(Nova.Models.IncidenciaPermiso_stIncidenciaTrabajador item)
        {
            var model = db2.IncidenciaPermiso_stIncidenciaTrabajador;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdIncidenciaTrabajador == item.IdIncidenciaTrabajador);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db2.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_GridViewPartial", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult GridViewPartialDelete(System.Int64 IdIncidenciaTrabajador)
        {
            // var model = db2.IncidenciaPermiso_stIncidenciaTrabajador;
            Int16 id = System.Convert.ToInt16(Session["IdConvenioLaboralTrabajador"]);
            var model = db1.IncidenciaPermiso_stIncidenciaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == id).ToList();
            //ViewData["Model"] = model;
            //ViewData["IdConvenioLaboralTrabajador"] = IdConvenioLaboralTrabajador;
            Session["Datos"] = model;

            if (IdIncidenciaTrabajador != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdIncidenciaTrabajador == IdIncidenciaTrabajador);
                    if (item != null)
                        model.Remove(item);
                    db2.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_GridViewPartial", model.ToList());
        }
        Nova.Models.bdNovaEntities db3 = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult DataViewPartial()
        {

            Int16 id = System.Convert.ToInt16(Session["IdConvenioLaboralTrabajador"]);
            //var model = db1.IncidenciaPermiso_stIncidenciaTrabajador.Where(s => s.IdConvenioLaboralTrabajador == id).ToList();
            var model = db3.vwDatosAspirantesTrabajadores.Where(d => d.IdConvenioLaboralTrabajador == id).ToList();
            return PartialView("_DataViewPartial", model);
        }
    }
}