﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using System.Net;
using System.Data.Entity;

namespace Nova.Controllers.Incidencias
{
    public class IncidenciaSuspensionPagoTrabajadorController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        public ActionResult Index(int IdTrabajador = 0)
        {

            if (IdTrabajador == 0)
                throw new Exception("El trabajador no existe, favor de verificar la información proporcionada.");


            Tuple<vwDatosAspirantesTrabajadores, List<Incidencia_stSuspensionPagoTrabajador>> model = null;
            List<Incidencia_stSuspensionPagoTrabajador> _historialSuspensionesTrabajador = new List<Incidencia_stSuspensionPagoTrabajador>();
            vwDatosAspirantesTrabajadores trabajador = new vwDatosAspirantesTrabajadores();

            trabajador = db.vwDatosAspirantesTrabajadores.SingleOrDefault(t => t.IdTrabajador == IdTrabajador);
            _historialSuspensionesTrabajador = db.Incidencia_stSuspensionPagoTrabajador.Where(i => i.IdTrabajador == IdTrabajador).OrderByDescending(f => f.FechaTermino).ToList();



            model = Tuple.Create(trabajador, _historialSuspensionesTrabajador);

            return View(model);
        }

        public ActionResult Edit(int id = 0)
        {
            if (id == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Incidencia_stSuspensionPagoTrabajador incidencia_stSuspensionPagoTrabajador = db.Incidencia_stSuspensionPagoTrabajador.Find(id);
            if (incidencia_stSuspensionPagoTrabajador == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdMotivoSuspension = new SelectList(db.Incidencia_ctMotivoSuspension, "IdMotivoSuspension", "MotivoSuspension", incidencia_stSuspensionPagoTrabajador.IdMotivoSuspension);
            ViewBag.IdTrabajador = new SelectList(db.Kardex_ctTrabajador.Where(t => t.IdTrabajador == incidencia_stSuspensionPagoTrabajador.IdTrabajador).Select(s => new { IdTrabajador = s.IdTrabajador, Nombre = s.Kardex_ctDatosPersonales.Nombre + " " + s.Kardex_ctDatosPersonales.ApellidoPaterno }), "IdTrabajador", "Nombre", incidencia_stSuspensionPagoTrabajador.IdTrabajador);
            return View(incidencia_stSuspensionPagoTrabajador);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdSuspensionPagoTrabajador,IdMotivoSuspension,IdTrabajador,FechaInicio,FechaTermino")] Incidencia_stSuspensionPagoTrabajador incidencia_stSuspensionPagoTrabajador)
        {
            bool IsValid = false;
            int r = DateTime.Compare(incidencia_stSuspensionPagoTrabajador.FechaTermino.Date, incidencia_stSuspensionPagoTrabajador.FechaInicio.Date);
            if (r < 0)
                return Json(new { IsValid, Message = "Error. La fecha de termino no puede ser menor a la fecha inicial de la suspensión" });

            incidencia_stSuspensionPagoTrabajador.IdConvenioLaboralTrabajadorCategoriaMovimiento = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            incidencia_stSuspensionPagoTrabajador.FechaMovimiento = DateTime.Now;
            if (ModelState.IsValid)
            {
                db.Entry(incidencia_stSuspensionPagoTrabajador).State = EntityState.Modified;
                try
                {
                    db.SaveChanges();
                    IsValid = true;
                }
                catch (Exception e)
                {

                    return Json(new { IsValid, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }


            }
            else
            {
                foreach (var modelState in ModelState.Values)
                {
                    foreach (var error in modelState.Errors)
                    {
                        return Json(new { IsValid, Message = "Error, el proceso no se pudo completar. " + error.ErrorMessage });

                    }
                }
            }
            ViewBag.IdMotivoSuspension = new SelectList(db.Incidencia_ctMotivoSuspension, "IdMotivoSuspension", "MotivoSuspension", incidencia_stSuspensionPagoTrabajador.IdMotivoSuspension);
            ViewBag.IdTrabajador = new SelectList(db.Kardex_ctTrabajador, "IdTrabajador", "CorreoOficial", incidencia_stSuspensionPagoTrabajador.IdTrabajador);
            return Json(new { IsValid, Message = "Registro grabado con éxito." });
        }
        // GET: Suspension/Create
        public ActionResult Create(int id = 0)
        {
            if (id == 0)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ViewBag.IdTrabajador = id;
            ViewBag.IdMotivoSuspension = new SelectList(db.Incidencia_ctMotivoSuspension, "IdMotivoSuspension", "MotivoSuspension");
            return View();
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdMotivoSuspension,IdTrabajador,FechaInicio,FechaTermino")] Incidencia_stSuspensionPagoTrabajador incidencia_stSuspensionPagoTrabajador)
        {
            bool IsValid = false;
            int r = DateTime.Compare(incidencia_stSuspensionPagoTrabajador.FechaTermino.Date, incidencia_stSuspensionPagoTrabajador.FechaInicio.Date);
            if (r < 0)
                return Json(new { IsValid, Message = "Error. La fecha de termino no puede ser menor a la fecha inicial de la suspensión o nula" });


            incidencia_stSuspensionPagoTrabajador.IdSuspensionPagoTrabajador = 0;
            incidencia_stSuspensionPagoTrabajador.IdConvenioLaboralTrabajadorCategoriaMovimiento = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            incidencia_stSuspensionPagoTrabajador.FechaMovimiento = DateTime.Now;

            if (ModelState.IsValid)
            {
                db.Incidencia_stSuspensionPagoTrabajador.Add(incidencia_stSuspensionPagoTrabajador);
                try
                {
                    db.SaveChanges();
                    IsValid = true;
                }
                catch (Exception e)
                {
                    return Json(new { IsValid, Message = ExceptionExtensions.GetOriginalException(e).Message });

                }

            }
            else
            {
                foreach (var modelState in ModelState.Values)
                {
                    foreach (var error in modelState.Errors)
                    {
                        return Json(new { IsValid, Message = "Error, el proceso no se pudo completar. " + error.ErrorMessage });

                    }
                }
            }
            ViewBag.IdMotivoSuspension = new SelectList(db.Incidencia_ctMotivoSuspension, "IdMotivoSuspension", "MotivoSuspension", incidencia_stSuspensionPagoTrabajador.IdMotivoSuspension);
            ViewBag.IdTrabajador = new SelectList(db.Kardex_ctTrabajador, "IdTrabajador", "CorreoOficial", incidencia_stSuspensionPagoTrabajador.IdTrabajador);
            return Json(new { IsValid, Message = "Registro grabado con éxito." });
        }
        public ActionResult CatalogoMotivoSuspension(int id = 0)
        {
            ViewBag.IdTrabajador = id;
            return View();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult CatalogoMotivoSuspension([Bind(Include = "IdMotivoSuspension,MotivoSuspension,Descripcion")] Incidencia_ctMotivoSuspension incidencia_ctMotivoSuspension)
        {
            int idTrabajador = incidencia_ctMotivoSuspension.IdMotivoSuspension;
            if (ModelState.IsValid)
            {
                db.Incidencia_ctMotivoSuspension.Add(incidencia_ctMotivoSuspension);
                db.SaveChanges();
                return RedirectToAction("Index", new { id = idTrabajador });
            }

            return View(incidencia_ctMotivoSuspension);
        }
    }
}