﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;

namespace Nova.Controllers
{
    public class SubDeduccionController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        //
        // GET: /SubDeduccion/

        public ActionResult Index()
        {
            var deducciones_ctsubdeduccion = db.Deducciones_ctSubDeduccion.Include(d => d.Deducciones_ctDeduccion).Include(d => d.Deducciones_TipoSubDeduccion);
            return View(deducciones_ctsubdeduccion.ToList());
        }

        //
        // GET: /SubDeduccion/Details/5

        public ActionResult Details(short id = 0)
        {
            Deducciones_ctSubDeduccion deducciones_ctsubdeduccion = db.Deducciones_ctSubDeduccion.Find(id);
            if (deducciones_ctsubdeduccion == null)
            {
                return HttpNotFound();
            }
            return View(deducciones_ctsubdeduccion);
        }

        //
        // GET: /SubDeduccion/Create

        public ActionResult Create()
        {
            ViewBag.IdDeduccion = new SelectList(db.Deducciones_ctDeduccion, "IdDeduccion", "Deduccion");
            ViewBag.IdTipoSubDeduccion = new SelectList(db.Deducciones_TipoSubDeduccion, "IdTipoSubDeduccion", "TipoSubDeduccion");
            return View();
        }

        //
        // POST: /SubDeduccion/Create

        [HttpPost]
        public ActionResult Create(Deducciones_ctSubDeduccion deducciones_ctsubdeduccion)
        {
            if (ModelState.IsValid)
            {
                db.Deducciones_ctSubDeduccion.Add(deducciones_ctsubdeduccion);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdDeduccion = new SelectList(db.Deducciones_ctDeduccion, "IdDeduccion", "Deduccion", deducciones_ctsubdeduccion.IdDeduccion);
            ViewBag.IdTipoSubDeduccion = new SelectList(db.Deducciones_TipoSubDeduccion, "IdTipoSubDeduccion", "TipoSubDeduccion", deducciones_ctsubdeduccion.IdTipoSubDeduccion);
            return View(deducciones_ctsubdeduccion);
        }

        //
        // GET: /SubDeduccion/Edit/5

        public ActionResult Edit(short id = 0)
        {
            Deducciones_ctSubDeduccion deducciones_ctsubdeduccion = db.Deducciones_ctSubDeduccion.Find(id);
            if (deducciones_ctsubdeduccion == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdDeduccion = new SelectList(db.Deducciones_ctDeduccion, "IdDeduccion", "Deduccion", deducciones_ctsubdeduccion.IdDeduccion);
            ViewBag.IdTipoSubDeduccion = new SelectList(db.Deducciones_TipoSubDeduccion, "IdTipoSubDeduccion", "TipoSubDeduccion", deducciones_ctsubdeduccion.IdTipoSubDeduccion);
            return View(deducciones_ctsubdeduccion);
        }

        //
        // POST: /SubDeduccion/Edit/5

        [HttpPost]
        public ActionResult Edit(Deducciones_ctSubDeduccion deducciones_ctsubdeduccion)
        {
            if (ModelState.IsValid)
            {
                db.Entry(deducciones_ctsubdeduccion).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdDeduccion = new SelectList(db.Deducciones_ctDeduccion, "IdDeduccion", "Deduccion", deducciones_ctsubdeduccion.IdDeduccion);
            ViewBag.IdTipoSubDeduccion = new SelectList(db.Deducciones_TipoSubDeduccion, "IdTipoSubDeduccion", "TipoSubDeduccion", deducciones_ctsubdeduccion.IdTipoSubDeduccion);
            return View(deducciones_ctsubdeduccion);
        }

        //
        // GET: /SubDeduccion/Delete/5

        public ActionResult Delete(short id = 0)
        {
            Deducciones_ctSubDeduccion deducciones_ctsubdeduccion = db.Deducciones_ctSubDeduccion.Find(id);
            if (deducciones_ctsubdeduccion == null)
            {
                return HttpNotFound();
            }
            return View(deducciones_ctsubdeduccion);
        }

        //
        // POST: /SubDeduccion/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(short id)
        {
            Deducciones_ctSubDeduccion deducciones_ctsubdeduccion = db.Deducciones_ctSubDeduccion.Find(id);
            db.Deducciones_ctSubDeduccion.Remove(deducciones_ctsubdeduccion);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
        Nova.Models.bdNovaEntities db1 = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgridSubdeducciones()
        {
            

            var model = db1.Deducciones_ctSubDeduccion;
            
            return PartialView("__pvgridSubdeducciones", model.ToList());
        }
        
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgridSubdeduccionesAddNew(Nova.Models.Deducciones_ctSubDeduccion item)
        {
            

            var model = db1.Deducciones_ctSubDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db1.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgridSubdeducciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgridSubdeduccionesUpdate(Nova.Models.Deducciones_ctSubDeduccion item)
        {
            var model = db1.Deducciones_ctSubDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdSubDeduccion == item.IdSubDeduccion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db1.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgridSubdeducciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgridSubdeduccionesDelete(System.Int16 IdSubDeduccion)
        {
            var model = db1.Deducciones_ctSubDeduccion;
            if (IdSubDeduccion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdSubDeduccion == IdSubDeduccion);
                    if (item != null)
                        model.Remove(item);
                    db1.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("__pvgridSubdeducciones", model.ToList());
        }
        Nova.Models.bdNovaEntities db2 = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvGridDeducciones()
        {
            var model = db2.Deducciones_ctDeduccion;
            return PartialView("__pvGridDeducciones", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridDeduccionesAddNew(Nova.Models.Deducciones_ctDeduccion item)
        {
            var model = db2.Deducciones_ctDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db2.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvGridDeducciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridDeduccionesUpdate(Nova.Models.Deducciones_ctDeduccion item)
        {
            var model = db2.Deducciones_ctDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdDeduccion == item.IdDeduccion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db2.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvGridDeducciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridDeduccionesDelete(System.Int16 IdDeduccion)
        {
            var model = db2.Deducciones_ctDeduccion;
            if (IdDeduccion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdDeduccion == IdDeduccion);
                    if (item != null)
                        model.Remove(item);
                    db2.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("__pvGridDeducciones", model.ToList());
        }
    }
}