﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class DeduccionController : Controller
    {
        //
        // GET: /Deduccion/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvDeduccion()
        {
            var model = db.Deducciones_ctDeduccion;
            return PartialView("_pvDeduccion", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionAddNew(Nova.Models.Deducciones_ctDeduccion item)
        {
            var model = db.Deducciones_ctDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvDeduccion", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionUpdate(Nova.Models.Deducciones_ctDeduccion item)
        {
            var model = db.Deducciones_ctDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdDeduccion == item.IdDeduccion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvDeduccion", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDeduccionDelete(System.Int16 IdDeduccion)
        {
            var model = db.Deducciones_ctDeduccion;
            if (IdDeduccion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdDeduccion == IdDeduccion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvDeduccion", model.ToList());
        }
    }
}
