﻿using Microsoft.AspNet.SignalR;
using Nova.Models.DashBoards;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers
{

    public class DashBoardContratacionController : Controller
    {


        // GET: DashBoardContratacion
        [AllowAnonymous]
        public ActionResult Index()
        {
            return View();
        }

        [AllowAnonymous]
        public ActionResult RefrescarGafica()
        {
            ObtenDatosAvance();
            ObtenDatosPorTipoRelacion();
            ObtenerDatosActualizadosStatus();
            ObtenDatosPorAreaConocimientoCategoria();
            //return View();
            return Json(new { success = true, data = "Datos cargados!"}, JsonRequestBehavior.AllowGet);
        }

        public void ObtenerDatosActualizadosStatus()
        {


            GraficasContratacion data = new GraficasContratacion();
            var datos = data.ObtenDatosPorEstatus();
            // Envía los datos actualizados a los clientes a través del hub
            var hubContext = GlobalHost.ConnectionManager.GetHubContext<DashboardContratosHub>();

            hubContext.Clients.All.ReceiveChartDataStatus(datos);
        }


        public void ObtenerDatosActualizadosGenero()
        {

            // Obtiene los datos actualizados desde la base de datos
            int estatusContratos = 4;
            int sexoM = 10;
            int sexoF = 8;
            int relacionLaboral = 5;
            int tipoSuplencia = 7;

            // Envía los datos actualizados a los clientes a través del hub
            var hubContext = GlobalHost.ConnectionManager.GetHubContext<DashboardContratosHub>();
            hubContext.Clients.All.ReceiveChartDataGener(estatusContratos, sexoM, sexoF);
        }
        public void ObtenerDatosActualizados()
        {
            // Obtiene los datos actualizados desde la base de datos
            int estatusContratos = 4;
            int sexoM = 10;
            int sexoF = 8;
            int relacionLaboral = 5;
            int tipoSuplencia = 7;

            // Envía los datos actualizados a los clientes a través del hub
            var hubContext = GlobalHost.ConnectionManager.GetHubContext<DashboardContratosHub>();
            hubContext.Clients.All.ReceiveChartData(estatusContratos, sexoM, sexoF, relacionLaboral, tipoSuplencia);
        }
        public void ObtenDatosPorAreaConocimientoCategoria()
        {
            GraficasContratacion data = new GraficasContratacion();
            var datos = data.ObtenDatosPorAreaConocimientoCategoria();
            // Envía los datos actualizados a los clientes a través del hub
            var hubContext = GlobalHost.ConnectionManager.GetHubContext<DashboardContratosHub>();

            hubContext.Clients.All.ReceiveDatosPorAreaConocimientoCategoria(datos);
        }
        public void ObtenDatosPorTipoRelacion()
        {
            GraficasContratacion data = new GraficasContratacion();
            var datos = data.ObtenDatosPorTipoRelacion();
            // Envía los datos actualizados a los clientes a través del hub
            var hubContext = GlobalHost.ConnectionManager.GetHubContext<DashboardContratosHub>();

            hubContext.Clients.All.ReceiveDatosPorTipoRelacion(datos);
        }

        public void ObtenDatosAvance()
        {


            GraficasContratacion data = new GraficasContratacion();
            var datos = data.ObtenDatosAvance();
            // Envía los datos actualizados a los clientes a través del hub
            var hubContext = GlobalHost.ConnectionManager.GetHubContext<DashboardContratosHub>();

            hubContext.Clients.All.ReceiveDatosAvance(datos);
        }

    }
}