﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
namespace Nova.Controllers
{
     //[Authorize (Roles="NominaDocente")]
    public class CuentaContableController : Controller
    {
        //
        // GET: /CuentaContable/
        [OutputCache(Location = System.Web.UI.OutputCacheLocation.None, NoStore = true)]
        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCuentaContable()
        {
            var model = db.Catalogos_ctCuentaContable;
            return PartialView("_pvCuentaContable", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCuentaContableAddNew(Nova.Models.Catalogos_ctCuentaContable item)
        {
            var model = db.Catalogos_ctCuentaContable;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCuentaContable", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCuentaContableUpdate(Nova.Models.Catalogos_ctCuentaContable item)
        {
            var model = db.Catalogos_ctCuentaContable;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdCuentaContable == item.IdCuentaContable);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCuentaContable", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCuentaContableDelete(System.Int16 IdCuentaContable)
        {
            var model = db.Catalogos_ctCuentaContable;
            if (IdCuentaContable != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdCuentaContable == IdCuentaContable);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                   
                    
                }

            }
            return PartialView("_pvCuentaContable", model.ToList());
        }

       
    }
}
