﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
namespace Nova.Controllers
{
    public class CreditoTrabajadorController : Controller
    {
        //
        // GET: /Creditos_stCreditoTrabajador/
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        public ActionResult Index(int IdTrabajador)
        {
            Session["Trabajador"] = Nova.Models.Creditos_stCreditoTrabajador.getTrabajador(IdTrabajador);
            Session["IdTrabajador"] = IdTrabajador;
            Session["model"] = db.Creditos_stCreditoTrabajador.Where(s=> s.IdTrabajador==IdTrabajador).OrderByDescending(c=> c.FechaInicioCredito).ToList();
            return View();
        }

        

        [ValidateInput(false)]
        public ActionResult _pvGridViewCreditosTrabajador()
        {
           // var model = db.Creditos_stCreditoTrabajador;
            return PartialView("__pvGridViewCreditosTrabajador", Session["model"]);
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridViewCreditosTrabajadorAddNew(Nova.Models.Creditos_stCreditoTrabajador item)
        {

            var model = db.Creditos_stCreditoTrabajador;
            if (item.ValidaModelo().IsValid)
            {
                if (ModelState.IsValid)
                {
                    try
                    {
                        model.Add(item);
                        db.SaveChanges();
                    }
                    catch (Exception e)
                    {
                        ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                    }
                }
                else
                    ViewData["EditError"] =  ModelState.Values.SelectMany(m => m.Errors)
                                 .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            }
            else
                //MessageBox.Show(ViewData, TipoMensaje.Warning, item.ValidaModelo().Mensaje);
                ViewData["EditError"] = item.ValidaModelo().Mensaje;
            int idt=(int )Session["IdTrabajador"];
            Session["model"] = db.Creditos_stCreditoTrabajador.Where(s => s.IdTrabajador == idt).ToList();
            return PartialView("__pvGridViewCreditosTrabajador", Session["model"]);
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridViewCreditosTrabajadorUpdate(Nova.Models.Creditos_stCreditoTrabajador item)
        {
            var model = db.Creditos_stCreditoTrabajador;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdCreditoTrabajador == item.IdCreditoTrabajador);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors. " + ModelState.Values.SelectMany(m => m.Errors)
                                 .Select(e => e.ErrorMessage).ToList().FirstOrDefault().ToString(); 
            int idt = (int)Session["IdTrabajador"];
            Session["model"] = db.Creditos_stCreditoTrabajador.Where(s => s.IdTrabajador == idt).OrderByDescending(c=> c.FechaInicioCredito).ToList();
            return PartialView("__pvGridViewCreditosTrabajador", Session["model"]);
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvGridViewCreditosTrabajadorDelete(System.Int32 IdCreditoTrabajador)
        {
            var model = db.Creditos_stCreditoTrabajador;
            if (IdCreditoTrabajador != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdCreditoTrabajador == IdCreditoTrabajador);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            int idt = (int)Session["IdTrabajador"];
            Session["model"] = db.Creditos_stCreditoTrabajador.Where(s => s.IdTrabajador == idt).OrderByDescending(c=> c.FechaInicioCredito).ToList();
            return PartialView("__pvGridViewCreditosTrabajador", Session["model"]);
        }
    }
}
