﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Seguridad;
namespace Nova.Controllers.Credenciales
{
    public class CredencialesInventarioController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: /CredencialesInventario/
        public ActionResult Index()
        {
            var credenciales_inventario = db.Credenciales_Inventario.Include(c => c.Catalogos_ctModalidadEstudio).Include(c => c.Convenios_stConvenioLaboralTrabajadorCategoria);
            return View(credenciales_inventario.ToList());
        }

        //// GET: /CredencialesInventario/Details/5
        //public ActionResult Details(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Credenciales_Inventario credenciales_inventario = db.Credenciales_Inventario.Find(id);
        //    if (credenciales_inventario == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    return View(credenciales_inventario);
        //}

        // GET: /CredencialesInventario/Create
        public ActionResult Create()
        {
            ViewBag.IdModalidadEstudio = new SelectList(db.Catalogos_ctModalidadEstudio.Where(q=> q.IdModalidadEstudio>0), "IdModalidadEstudio", "ModalidadEstudio");
            //ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            Credenciales_Inventario model = new Credenciales_Inventario();
            model.IdConvenioLaboralTrabajadorCategoria = Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            return View(model);
        }

        // POST: /CredencialesInventario/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include="IdCredencialesInventario,FechaEntrada,Factura,PrecioUnitario,IdConvenioLaboralTrabajadorCategoria,Existencias,Entradas,IdModalidadEstudio")] Credenciales_Inventario credenciales_inventario)
        {
            if (ModelState.IsValid)
            {
                credenciales_inventario.Existencias = System.Convert.ToInt16(credenciales_inventario.Existencias + credenciales_inventario.Entradas);
                db.Credenciales_Inventario.Add(credenciales_inventario);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            ViewBag.IdModalidadEstudio = new SelectList(db.Catalogos_ctModalidadEstudio, "IdModalidadEstudio", "ModalidadEstudio", credenciales_inventario.IdModalidadEstudio);
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", credenciales_inventario.IdConvenioLaboralTrabajadorCategoria);
            return View(credenciales_inventario);
        }

        //// GET: /CredencialesInventario/Edit/5
        //public ActionResult Edit(int? id)
        //{
        //    if (id == null)
        //    {
        //        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        //    }
        //    Credenciales_Inventario credenciales_inventario = db.Credenciales_Inventario.Find(id);
        //    if (credenciales_inventario == null)
        //    {
        //        return HttpNotFound();
        //    }
        //    ViewBag.IdModalidadEstudio = new SelectList(db.Catalogos_ctModalidadEstudio, "IdModalidadEstudio", "ModalidadEstudio", credenciales_inventario.IdModalidadEstudio);
        //    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", credenciales_inventario.IdConvenioLaboralTrabajadorCategoria);
        //    return View(credenciales_inventario);
        //}

        //// POST: /CredencialesInventario/Edit/5
        //// Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        //// más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        //[HttpPost]
        //[ValidateAntiForgeryToken]
        //public ActionResult Edit([Bind(Include="IdCredencialesInventario,FechaEntrada,Factura,PrecioUnitario,IdConvenioLaboralTrabajadorCategoria,Existencias,Entradas,IdModalidadEstudio")] Credenciales_Inventario credenciales_inventario)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        db.Entry(credenciales_inventario).State = System.Data.Entity.EntityState.Modified;
        //        db.SaveChanges();
        //        return RedirectToAction("Index");
        //    }
        //    ViewBag.IdModalidadEstudio = new SelectList(db.Catalogos_ctModalidadEstudio, "IdModalidadEstudio", "ModalidadEstudio", credenciales_inventario.IdModalidadEstudio);
        //    ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", credenciales_inventario.IdConvenioLaboralTrabajadorCategoria);
        //    return View(credenciales_inventario);
        //}

        // GET: /CredencialesInventario/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Credenciales_Inventario credenciales_inventario = db.Credenciales_Inventario.Find(id);
            if (credenciales_inventario == null)
            {
                return HttpNotFound();
            }
            return View(credenciales_inventario);
        }

        // POST: /CredencialesInventario/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            Credenciales_Inventario credenciales_inventario = db.Credenciales_Inventario.Find(id);
            db.Credenciales_Inventario.Remove(credenciales_inventario);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
