﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Dapper;
using Seguridad;

namespace Nova.Controllers 
{

    public class MiCertificadoController : Controller
    {
        // GET: BuscarFolio
       
        [AllowAnonymous]
        public ActionResult Folio(string id)
        {
            bdAriesEntities bd = new bdAriesEntities();
            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string query = @"select * from Certificacion_stCertificadoParcialAlumno where Folio=@id";

            var model = bd.Certificacion_stCertificadoAlumno.Where(x => x.Folio == id).FirstOrDefault();

            var result = (Certificacion_stCertificadoAlumno)dp.connection.QuerySingleOrDefault<Certificacion_stCertificadoAlumno>(query, new { id });

            if (model != null)
                return View(model);
            else {

                if (result != null)
                {
                    return View(result);
                }
                else
                {
                    ViewBag.ID = id;
                    return View("DetalleFolio");
                }
            }
           
        }

       


        [AllowAnonymous]
        [HttpPost]
        public ActionResult ObtenFolio(string folio)
        {
            bdAriesEntities bd = new bdAriesEntities();
            var model = bd.Certificacion_stCertificadoAlumno.Where(x => x.Folio == folio).FirstOrDefault();

            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string query = @"select * from Certificacion_stCertificadoParcialAlumno where Folio= @folio";

            var result = (Certificacion_stCertificadoAlumno)dp.connection.QuerySingleOrDefault<Certificacion_stCertificadoAlumno>(query, new { folio });


            if (model != null)
                return View("Folio", model);
            else
            {
                if (result != null)
                {
                    return View("Folio", result);
                }
                else
                {
                    ViewBag.ID = folio;
                    return View("DetalleFolio");
                }
            }
        }
        public ActionResult DetalleFolio()
        {
            return View();
        }
    }
}