﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;

namespace Nova.Controllers.Catalogos
{
    public class TipoSubdeduccionesController : Controller
    {
        //
        // GET: /TipoSubdeducciones/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvTipoSubdeducciones()
        {
            var model = db.Deducciones_TipoSubDeduccion;
            return PartialView("_pvTipoSubdeducciones", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvTipoSubdeduccionesAddNew(Nova.Models.Deducciones_TipoSubDeduccion item)
        {
            var model = db.Deducciones_TipoSubDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvTipoSubdeducciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvTipoSubdeduccionesUpdate(Nova.Models.Deducciones_TipoSubDeduccion item)
        {
            var model = db.Deducciones_TipoSubDeduccion;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdTipoSubDeduccion == item.IdTipoSubDeduccion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvTipoSubdeducciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvTipoSubdeduccionesDelete(System.Int16 IdTipoSubDeduccion)
        {
            var model = db.Deducciones_TipoSubDeduccion;
            if (IdTipoSubDeduccion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdTipoSubDeduccion == IdTipoSubDeduccion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvTipoSubdeducciones", model.ToList());
        }

    }
}
