﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class ProyectosController : Controller
    {
        //
        // GET: /Proyectos/

        public ActionResult Index()
        {
            return View();
        }


        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgvProyectos()
        {
            var model = db.Catalogos_ctProyectoPresupuestal;
            return PartialView("__pvgvProyectos", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvProyectosAddNew(Nova.Models.Catalogos_ctProyectoPresupuestal item)
        {
            var model = db.Catalogos_ctProyectoPresupuestal;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors." + ModelState.Values.SelectMany(m => m.Errors)
                                .Select(g => g.ErrorMessage).ToList().FirstOrDefault().ToString();
            return PartialView("__pvgvProyectos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvProyectosUpdate(Nova.Models.Catalogos_ctProyectoPresupuestal item)
        {
            var model = db.Catalogos_ctProyectoPresupuestal;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdProyectoPresupuestal == item.IdProyectoPresupuestal);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgvProyectos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvProyectosDelete(System.Int16 IdProyectoPresupuestal)
        {
            var model = db.Catalogos_ctProyectoPresupuestal;
            if (IdProyectoPresupuestal != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdProyectoPresupuestal == IdProyectoPresupuestal);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = "Please, correct all errors." + ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            return PartialView("__pvgvProyectos", model.ToList());
        }
    }
}
