﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Catalogos
{
    public class Nomina_DocentesHorasPagoController : Controller
    {
        //
        // GET: /Nomina_DocentesHorasPago/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvNomina_DocentesHorasPago()
        {
            var model = db.Nomina_DocentesHorasPago;
            return PartialView("_pvNomina_DocentesHorasPago", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvNomina_DocentesHorasPagoAddNew(Nova.Models.Nomina_DocentesHorasPago item)
        {
            var model = db.Nomina_DocentesHorasPago;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
              
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvNomina_DocentesHorasPago", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvNomina_DocentesHorasPagoUpdate(Nova.Models.Nomina_DocentesHorasPago item)
        {
            var model = db.Nomina_DocentesHorasPago;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdDocentesHorasPago == item.IdDocentesHorasPago);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvNomina_DocentesHorasPago", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvNomina_DocentesHorasPagoDelete(System.Int16 IdDocentesHorasPago)
        {
            var model = db.Nomina_DocentesHorasPago;
            if (IdDocentesHorasPago != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdDocentesHorasPago == IdDocentesHorasPago);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                                       
                    
                }
            }


            return PartialView("_pvNomina_DocentesHorasPago", model.ToList());
        }
    }
}
