﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class JornadaLaboralController : Controller
    {
        //
        // GET: /JornadaLaboral/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult __pvgvJornadaLaboral()
        {
            var model = db.Catalogos_ctJornadaLaboral;
            return PartialView("___pvgvJornadaLaboral", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult __pvgvJornadaLaboralAddNew(Nova.Models.Catalogos_ctJornadaLaboral item)
        {
            var model = db.Catalogos_ctJornadaLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);


            return PartialView("___pvgvJornadaLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult __pvgvJornadaLaboralUpdate(Nova.Models.Catalogos_ctJornadaLaboral item)
        {
            var model = db.Catalogos_ctJornadaLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdJornadaLaboral == item.IdJornadaLaboral);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("___pvgvJornadaLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult __pvgvJornadaLaboralDelete(System.Int16 IdJornadaLaboral)
        {
            var model = db.Catalogos_ctJornadaLaboral;
            if (IdJornadaLaboral != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdJornadaLaboral == IdJornadaLaboral);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("___pvgvJornadaLaboral", model.ToList());
        }
    }
}
