﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
using System.Transactions;
using ExcelDataReader;

namespace Nova.Controllers.Catalogos
{
    public class HoraJornadaController : Controller
    {
        bdNovaEntities db = new bdNovaEntities();

        // GET: /HoraJornada/
        public ActionResult Index()
        {
            return View();
        }

        [ValidateInput(false)]
        public ActionResult pvHoraJornada()
        {
            var model = db.Plazas_ctCostoHoraJornada.OrderByDescending(t => t.FechaInicio).ToList();
            return PartialView("_pvHoraJornada", model);
        }

        //consultar ultimo año
        [HttpPost]
        public ActionResult getUltimoAnio()
        {
            var result = new { Value_e = false, Message_e = "", Result_Value = 0 };

            DateTime fecha = db.Plazas_ctCostoHoraJornada.OrderByDescending(t => t.FechaInicio).Select(s => s.FechaInicio).First();
            if (fecha == null)
            {
                result = new { Value_e = false, Message_e = "No se puede encontrar referencia con la fecha", Result_Value = 0 };
                return Json(result, JsonRequestBehavior.AllowGet);
            }
            else
            {
                result = new { Value_e = true, Message_e = "Se exportará información del Año " + fecha.Year, Result_Value = fecha.Year };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

        }

        //exportar información a Excel
        public ActionResult getCostoHoraJornadaXls()
        {
            DateTime fecha = db.Plazas_ctCostoHoraJornada.OrderByDescending(t => t.FechaInicio).Select(s => s.FechaInicio).First();
            List<Plazas_ctCostoHoraJornada> model = db.Plazas_ctCostoHoraJornada.Where(t => t.FechaInicio.Year == fecha.Year).ToList();
            string nombrefile = "CostoHoraJornada" + DateTime.Now.ToShortDateString() + ".xls";
            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=" + nombrefile);

            return View("CostoHoraJornadaXls", model);
        }

        //importar información de Excel
        public ActionResult importFileXls(HttpPostedFileBase upload)
        {
            var result = new { Value_e = false, Message_e = "" };
            if (upload.ContentLength > 0)
            {
                // ExcelDataReader works with the binary Excel file, so it needs a FileStream
                // to get started. This is how we avoid dependencies on ACE or Interop:
                System.IO.Stream stream = upload.InputStream;
                // We return the interface, so that
                IExcelDataReader reader = null;

                if (upload.FileName.EndsWith(".xls"))
                {
                    reader = ExcelReaderFactory.CreateBinaryReader(stream);
                }
                else if (upload.FileName.EndsWith(".xlsx"))
                {
                    reader = ExcelReaderFactory.CreateOpenXmlReader(stream);
                }
                else
                {
                    result = new { Value_e = false, Message_e = "Formato de archivo no soportado. Seleccione un archivo con formato XLS o XLSX" };
                    return Json(result, JsonRequestBehavior.AllowGet);
                }
                //reader.IsFirstRowAsColumnNames = true;

                //DataSet result = new DataSet();

                List<Plazas_ctCategoria> categoria = db.Plazas_ctCategoria.ToList();
                List<Catalogos_ctJornadaLaboral> jornadaLaboral = db.Catalogos_ctJornadaLaboral.ToList();

                List<Plazas_ctCostoHoraJornada> list = new List<Plazas_ctCostoHoraJornada>();
                int contador = 0;
                while (reader.Read())
                {
                    if (contador == 0)
                    {
                        reader.Read();
                        contador++;
                    }

                    Plazas_ctCostoHoraJornada newlist = new Plazas_ctCostoHoraJornada();

                    short categoriaId = 0;
                    short jornadaLaboralId = 0;


                    //consultar la categoria
                    List<Plazas_ctCategoria> categoriaModel = categoria.Where(t => t.IdCategoria == System.Convert.ToInt32(reader.GetValue(0))).ToList();
                    if (categoriaModel.Count() > 0)
                    {
                        categoriaId = categoriaModel.FirstOrDefault().IdCategoria;
                    }
                    else
                    {
                        result = new { Value_e = false, Message_e = "Error relacionado con el la columna Categoria. Valide que los datos sean coherentes y la categoria no debe coincidir con algun otra categoria de lo exportado. Revice la fila número " + (contador + 1) };
                        return Json(result, JsonRequestBehavior.AllowGet);
                    }

                    if (categoriaId > 0)
                    {
                        newlist.IdCategoria = categoriaId;
                    }
                    else
                    {
                        result = new { Value_e = false, Message_e = "No se pudo consultar la Categoria en la fila " + (contador + 1) };
                        return Json(result, JsonRequestBehavior.AllowGet);
                    }


                    newlist.FechaInicio = System.Convert.ToDateTime(reader.GetValue(2));
                    newlist.FechaTermino = System.Convert.ToDateTime(reader.GetValue(3));
                    newlist.CostoPorHora = System.Convert.ToDecimal(reader.GetValue(4));
                    newlist.CostoPorHoraExcedente = System.Convert.ToDecimal(reader.GetValue(5));
                    newlist.CostoPorHoraInterina = System.Convert.ToDecimal(reader.GetValue(6));
                    newlist.CostoPorHoraRezago = System.Convert.ToDecimal(reader.GetValue(7));
                    newlist.CostoMaterialDidactico = System.Convert.ToDecimal(reader.GetValue(8));
                    newlist.CostoMaterialDidacticoExcedente = System.Convert.ToDecimal(reader.GetValue(9));
                    newlist.CostoEficienciaJornada = System.Convert.ToDecimal(reader.GetValue(10));
                    newlist.CostoEficienciaExcedente = System.Convert.ToDecimal(reader.GetValue(11));

                    //consultar la jornada
                    List<Catalogos_ctJornadaLaboral> jornadaLaboralModel = jornadaLaboral.Where(t => t.IdJornadaLaboral == System.Convert.ToInt32(reader.GetValue(12))).ToList();
                    if (jornadaLaboralModel != null)
                    {
                        jornadaLaboralId = jornadaLaboralModel.FirstOrDefault().IdJornadaLaboral;
                    }
                    else
                    {
                        result = new { Value_e = false, Message_e = "Error relacionado con el la columna JornadaLaboral. Valide que los datos sean coherentes y la JornadaLaboral no debe coincidir con algun otra Jornada de lo exportado. Revice la fila número " + (contador + 1) };
                        return Json(result, JsonRequestBehavior.AllowGet);
                    }

                    if (jornadaLaboralId > 0)
                    {
                        newlist.IdJornadaLaboral = jornadaLaboralId;
                    }
                    else
                    {
                        result = new { Value_e = false, Message_e = "No se pudo consultar la JornadaLaboral en la fila " + (contador + 1) };
                        return Json(result, JsonRequestBehavior.AllowGet);
                    }



                    newlist.PorcentajeIncremento = System.Convert.ToInt16(reader.GetValue(14));
                    newlist.FechaAplicacion = System.Convert.ToDateTime(reader.GetValue(15));


                    list.Add(newlist);

                    contador++;
                }
                reader.Close();

                try
                {
                    TransactionOptions transactionoptions1 = new TransactionOptions();
                    transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                    {
                        int año = list.FirstOrDefault().FechaInicio.Year;

                        var listaAnterior = db.Plazas_ctCostoHoraJornada.Where(t => t.FechaInicio.Year == año).ToList();
                        db.Plazas_ctCostoHoraJornada.RemoveRange(listaAnterior);
                        db.SaveChanges();

                        db.Plazas_ctCostoHoraJornada.AddRange(list);
                        db.SaveChanges();

                        scope.Complete();
                    }

                    result = new { Value_e = true, Message_e = "Se ha Importado con éxito" };
                    return Json(result, JsonRequestBehavior.AllowGet);
                }
                catch (Exception e)
                {
                    result = new { Value_e = false, Message_e = e.Message };
                    return Json(result, JsonRequestBehavior.AllowGet);
                }

            }
            else
            {
                result = new { Value_e = false, Message_e = "No se cargo algún Archivo." };
                return Json(result, JsonRequestBehavior.AllowGet);
            }

        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvHoraJornadaAddNew(Nova.Models.Plazas_ctCostoHoraJornada item)
        {
            var model = db.Plazas_ctCostoHoraJornada;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvHoraJornada", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvHoraJornadaUpdate(Nova.Models.Plazas_ctCostoHoraJornada item)
        {
            var model = db.Plazas_ctCostoHoraJornada;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdCostoHoraJornada == item.IdCostoHoraJornada);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvHoraJornada", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvHoraJornadaDelete(System.Int16 IdCostoHoraJornada)
        {
            var model = db.Plazas_ctCostoHoraJornada;
            if (IdCostoHoraJornada != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdCostoHoraJornada == IdCostoHoraJornada);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvHoraJornada", model.ToList());
        }

    }
}
