﻿ using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Catalogos
{
    public class GrupoProcesosController : Controller
    {
        //
        // GET: /GrupoProcesos/

        public ActionResult Index()
        {
            return View();
        }


        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvGrupoProcesos()
        {
            var model = db.Procesos_ctProcesosActividad;
            return PartialView("_pvGrupoProcesos", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvGrupoProcesosAddNew(Nova.Models.Procesos_ctProcesosActividad item)
        {
            var model = db.Procesos_ctProcesosActividad;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvGrupoProcesos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvGrupoProcesosUpdate(Nova.Models.Procesos_ctProcesosActividad item)
        {
            var model = db.Procesos_ctProcesosActividad;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdProcesosActividad == item.IdProcesosActividad);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvGrupoProcesos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvGrupoProcesosDelete(System.Int16 IdProcesosActividad)
        {
            var model = db.Procesos_ctProcesosActividad;
            if (IdProcesosActividad != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdProcesosActividad == IdProcesosActividad);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvGrupoProcesos", model.ToList());
        }

    }
}
