﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;

namespace Nova.Controllers.Catalogos
{
    public class GrupoPercepcionesController : Controller
    {
        //
        // GET: /GrupoPercepciones/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvGrupoPercepciones()
        {
            var model = db.Catalogos_ctGrupoPercepciones;
            return PartialView("_pvGrupoPercepciones", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvGrupoPercepcionesAddNew(Nova.Models.Catalogos_ctGrupoPercepciones item)
        {
            var model = db.Catalogos_ctGrupoPercepciones;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvGrupoPercepciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvGrupoPercepcionesUpdate(Nova.Models.Catalogos_ctGrupoPercepciones item)
        {
            var model = db.Catalogos_ctGrupoPercepciones;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdGrupoPercepcion == item.IdGrupoPercepcion);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvGrupoPercepciones", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvGrupoPercepcionesDelete(System.Int16 IdGrupoPercepcion)
        {
            var model = db.Catalogos_ctGrupoPercepciones;
            if (IdGrupoPercepcion != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdGrupoPercepcion == IdGrupoPercepcion);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvGrupoPercepciones", model.ToList());
        }

    }
}
