﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.Catalogos
{
    public class FuentesFinanciamientoController : Controller
    {
        //
        // GET: /FuentesFinanciamiento/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvFuentesFinanciamiento()
        {
            var model = db.Catalogos_ctFuenteFinanciamiento;
            return PartialView("_pvFuentesFinanciamiento", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvFuentesFinanciamientoAddNew(Nova.Models.Catalogos_ctFuenteFinanciamiento item)
        {
            var model = db.Catalogos_ctFuenteFinanciamiento;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvFuentesFinanciamiento", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvFuentesFinanciamientoUpdate(Nova.Models.Catalogos_ctFuenteFinanciamiento item)
        {
            var model = db.Catalogos_ctFuenteFinanciamiento;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdFuenteFinanciamiento == item.IdFuenteFinanciamiento);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvFuentesFinanciamiento", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvFuentesFinanciamientoDelete(System.Int16 IdFuenteFinanciamiento)
        {
            var model = db.Catalogos_ctFuenteFinanciamiento;
            if (IdFuenteFinanciamiento != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdFuenteFinanciamiento == IdFuenteFinanciamiento);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvFuentesFinanciamiento", model.ToList());
        }
 
    }
}
