﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;
namespace Nova.Controllers.Catalogos
{
    public class FormaPagoController : Controller
    {
        //
        // GET: /FormaPago/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvGridFormaPago()
        {
            var model = db.Catalogos_ctFormaDePago;
            return PartialView("_pvGridFormaPago", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvGridFormaPagoAddNew(Nova.Models.Catalogos_ctFormaDePago item)
        {
            var model = db.Catalogos_ctFormaDePago;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_pvGridFormaPago", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvGridFormaPagoUpdate(Nova.Models.Catalogos_ctFormaDePago item)
        {
            var model = db.Catalogos_ctFormaDePago;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdFormaDePago == item.IdFormaDePago);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvGridFormaPago", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvGridFormaPagoDelete(System.Byte IdFormaDePago)
        {
            var model = db.Catalogos_ctFormaDePago;
            if (IdFormaDePago != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdFormaDePago == IdFormaDePago);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvGridFormaPago", model.ToList());
        }
    }
}
