﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class EstructuraOrganicaController : Controller
    {
        //
        // GET: /EstructuraOrganica/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgvEstructuraorganica()
        {
            var model = db.Catalogos_ctEstructuraOrganica;
            return PartialView("__pvgvEstructuraorganica", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvEstructuraorganicaAddNew(Nova.Models.Catalogos_ctEstructuraOrganica item)
        {
            var model = db.Catalogos_ctEstructuraOrganica;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("__pvgvEstructuraorganica", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvEstructuraorganicaUpdate(Nova.Models.Catalogos_ctEstructuraOrganica item)
        {
            var model = db.Catalogos_ctEstructuraOrganica;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdEstructuraOrganica == item.IdEstructuraOrganica);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgvEstructuraorganica", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgvEstructuraorganicaDelete(System.Int16 IdEstructuraOrganica)
        {
            var model = db.Catalogos_ctEstructuraOrganica;
            if (IdEstructuraOrganica != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdEstructuraOrganica == IdEstructuraOrganica);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("__pvgvEstructuraorganica", model.ToList());
        }
    }
}
