﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using DevExpress.Web.Mvc;


namespace Nova.Controllers.Catalogos
{
    public class DistribucionPlazasController : Controller
    {
        //
        // GET: /DistribucionPlazas/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvDistribucionPlazas()
        {
            var model = db.Plazas_stDistribucionPlazaCategoria;
            return PartialView("_pvDistribucionPlazas", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvDistribucionPlazasAddNew(Nova.Models.Plazas_stDistribucionPlazaCategoria item)
        {
            var model = db.Plazas_stDistribucionPlazaCategoria;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvDistribucionPlazas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDistribucionPlazasUpdate(Nova.Models.Plazas_stDistribucionPlazaCategoria item)
        {
            var model = db.Plazas_stDistribucionPlazaCategoria;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdDistribucionPlazaCategoria == item.IdDistribucionPlazaCategoria);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvDistribucionPlazas", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvDistribucionPlazasDelete(System.Int32 IdDistribucionPlazaCategoria)
        {
            var model = db.Plazas_stDistribucionPlazaCategoria;
            if (IdDistribucionPlazaCategoria != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdDistribucionPlazaCategoria == IdDistribucionPlazaCategoria);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvDistribucionPlazas", model.ToList());
        }

    }
}
