﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models.CuentasPago;

using System.Data;
using System.Data.Entity;

using Nova.Models;
using Nova.Libraries;
using DevExpress.Web.Mvc;
 

namespace Nova.Controllers.Catalogos
{
    public class CuentasPagoController : Controller
    {
        //
        // GET: /CuentasPago/

        public ActionResult Index(int IdTrabajador)
        {
            var model = CuentasPago.GetCuentasPago(db.Kardex_stTrabajadorCuentas, IdTrabajador);
            Session["IdTrabajador"] = IdTrabajador;
            return View(model);
            //return View();
        }
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCuentasPago()
        {
            //var model = db.Kardex_stTrabajadorCuentas;
            //return PartialView("_pvCuentasPago", model.ToList());
            int id = (int)Session["IdTrabajador"];
            var model = CuentasPago.GetCuentasPago(db.Kardex_stTrabajadorCuentas, id);
            return PartialView("_pvCuentasPago", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCuentasPagoAddNew(Nova.Models.Kardex_stTrabajadorCuentas item)
        {
            var model = db.Kardex_stTrabajadorCuentas;

            //int id = (int)Session["IdTrabajador"];
            //var model = CuentasPago.GetCuentasPago(db.Kardex_stTrabajadorCuentas, id);
            //int id = (int)Session["IdTrabajador"];
            //var model = CuentasPago.GetCuentasPago(db.Kardex_stTrabajadorCuentas, id);
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                                .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            int id = (int)Session["IdTrabajador"];
            var model2 = CuentasPago.GetCuentasPago(db.Kardex_stTrabajadorCuentas, id);
            return PartialView("_pvCuentasPago", model2.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCuentasPagoUpdate(Nova.Models.Kardex_stTrabajadorCuentas item)
        {
            var model = db.Kardex_stTrabajadorCuentas;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdTrabajadorCuentas == item.IdTrabajadorCuentas);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            int id = (int)Session["IdTrabajador"];
            return RedirectToAction("Index", new { IdTrabajador = id });
            //return PartialView("_pvCuentasPago", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCuentasPagoDelete(System.Int16 IdTrabajadorCuentas)
        {
            var model = db.Kardex_stTrabajadorCuentas;
            if (IdTrabajadorCuentas != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdTrabajadorCuentas == IdTrabajadorCuentas);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvCuentasPago", model.ToList());
        }

    }
}
