﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class ClasificacionLaboralController : Controller
    {
        //
        // GET: /ClasificacionLaboral/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult _pvgridClasificacionLaboral()
        {
            var model = db.Catalogos_ctClasificacionLaboral;
            return PartialView("__pvgridClasificacionLaboral", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgridClasificacionLaboralAddNew(Nova.Models.Catalogos_ctClasificacionLaboral item)
        {
            var model = db.Catalogos_ctClasificacionLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
              {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("__pvgridClasificacionLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgridClasificacionLaboralUpdate(Nova.Models.Catalogos_ctClasificacionLaboral item)
        {
            var model = db.Catalogos_ctClasificacionLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdClasificacionLaboral == item.IdClasificacionLaboral);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("__pvgridClasificacionLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult _pvgridClasificacionLaboralDelete(System.Int16 IdClasificacionLaboral)
        {
            var model = db.Catalogos_ctClasificacionLaboral;
            if (IdClasificacionLaboral != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdClasificacionLaboral == IdClasificacionLaboral);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("__pvgridClasificacionLaboral", model.ToList());
        }
    }
}
