﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Data;
using System.Data.Entity;
using Nova.Models;
//using Nova.Libraries;
using DevExpress.Web.Mvc;

namespace Nova.Controllers.Catalogos
{
    public class CategoriasController : Controller
    {
        //private bdNovaEntities db1 = new bdNovaEntities();
        //
        // GET: /Categorias/

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        public ActionResult Index()
        {
                   return View();
        }


      
        [ValidateInput(false)]
        public ActionResult pvCategorias()
        {
            var model = db.Plazas_ctCategoria;

            return PartialView("_pvCategorias", model.ToList());
           }

        public ActionResult MultiColumnComboBoxPartial()
        {

            return PartialView();
        }


        [HttpPost, ValidateInput(false)]
        public ActionResult pvCategoriasAddNew(Nova.Models.Plazas_ctCategoria item)
        {
            var model = db.Plazas_ctCategoria;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                 
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCategorias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCategoriasUpdate(Nova.Models.Plazas_ctCategoria item)
        {
            var model = db.Plazas_ctCategoria;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdCategoria == item.IdCategoria);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCategorias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCategoriasDelete(System.Int16 IdCategoria)
        {
            var model = db.Plazas_ctCategoria;
            if (IdCategoria != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdCategoria == IdCategoria);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvCategorias", model.ToList());
        }

    }
}
