﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CapacitacionSedeController : Controller
    {
        //
        // GET: /CapacitacionSede/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCapacitacionSede()
        {
            var model = db.Capacitacion_ctSede;
            return PartialView("_pvCapacitacionSede", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionSedeAddNew(Nova.Models.Capacitacion_ctSede item)
        {
            var model = db.Capacitacion_ctSede;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCapacitacionSede", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionSedeUpdate(Nova.Models.Capacitacion_ctSede item)
        {
            var model = db.Capacitacion_ctSede;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdSede == item.IdSede);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCapacitacionSede", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionSedeDelete(System.Int16 IdSede)
        {
            var model = db.Capacitacion_ctSede;
            if (IdSede != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdSede == IdSede);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvCapacitacionSede", model.ToList());
        }
    }
}
