﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

using Nova.Libraries;

using System.Net.Mail;
using System.Net;


namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionEstructuraOrganicaController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

         // GET: CapacitacionEstructuraOrganica
        public ActionResult Index()
        {
            return View();
        }

        // GET: CapacitacionEstructuraOrganica
        public ActionResult Notificar(int id)
        {
            Capacitacion_PersonalPermitidoEstructuraOrganica item = db.Capacitacion_PersonalPermitidoEstructuraOrganica.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> trabajadores = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == item.IdEstructuraOrganica && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            ViewBag.trabajadores = trabajadores;
            return View(item);
        }

        [HttpPost]
        public ActionResult EnviarNotificacion(int id)
        {
            Capacitacion_PersonalPermitidoEstructuraOrganica item = db.Capacitacion_PersonalPermitidoEstructuraOrganica.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> correos = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == item.IdEstructuraOrganica && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            // ViewBag.trabajadores = trabajadores;

            UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

            string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Index", "Home");

            Nova.Models.Capacitacion_PersonalPermitidoCategoria.EnviarEmailInvitacion("jcmc2@hotmail.com", item.Capacitacion_stConvocatoriasCursos, url);


            MessageBox.Show(ViewData, TipoMensaje.Success, "Se han enviado los correos electrónicos exitosamente ");

            Capacitacion_PersonalPermitidoEstructuraOrganica variable = db.Capacitacion_PersonalPermitidoEstructuraOrganica.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> trabajadores = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Catalogos_ctEstructuraOrganica.IdEstructuraOrganica == item.IdEstructuraOrganica && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            ViewBag.trabajadores = trabajadores;


            return View("Notificar", variable);
        }

        [ValidateInput(false)]
        public ActionResult EstructuraOrganica()
        {
            var model = db.Capacitacion_PersonalPermitidoEstructuraOrganica;
            return PartialView("_EstructuraOrganica", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult EstructuraOrganicaAddNew(Nova.Models.Capacitacion_PersonalPermitidoEstructuraOrganica item)
        {
            ViewData["Item"] = item;
            var model = db.Capacitacion_PersonalPermitidoEstructuraOrganica;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_EstructuraOrganica", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult EstructuraOrganicaUpdate(Nova.Models.Capacitacion_PersonalPermitidoEstructuraOrganica item)
        {

            var model = db.Capacitacion_PersonalPermitidoEstructuraOrganica;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdEstructuraOrganica == item.IdEstructuraOrganica);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_EstructuraOrganica", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult EstructuraOrganicaDelete(System.Int32 IdPersonalPermitidoEstructuraOrganica)
        {
            var model = db.Capacitacion_PersonalPermitidoEstructuraOrganica;
            if (IdPersonalPermitidoEstructuraOrganica != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPersonalPermitidoEstructuraOrganica == IdPersonalPermitidoEstructuraOrganica);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_EstructuraOrganica", model.ToList());
        }
    }
}