﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionEstadisticaController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        // GET: CapacitacionEstadistica
        public ActionResult Index()
        {
            Capacitacion_stConvocatoria convocatoria = db.Capacitacion_stConvocatoria.OrderByDescending(f => f.FechaInicioConvocatoria).FirstOrDefault();
            int id = 0;
            if (Request["IdConvocatoria"] != null)
                id = System.Convert.ToInt32(Request["IdConvocatoria"]);
            else
                if (convocatoria.IdConvocatoria == 0)
                    throw new ApplicationException("No existe una convocatoria seleccionada");
                else
                    id = convocatoria.IdConvocatoria;


            ViewBag.Id = id;
            return View();
        }
        public ActionResult TotalParticipantesCurso(int id)
        {
            //int id = 0;
            //if (Request["IdConvocatoria"] != null)
            //    id = System.Convert.ToInt32(Request["IdConvocatoria"]);


            ViewBag.TotalParticipantesCurso = Nova.Models.Capacitacion_stConvocatoria.ObtenTotalParticipantesCurso(id);

            return PartialView(ViewBag.TotalParticipantesCurso);
        }
        public ActionResult TotalParticipantesServicio(int id)
        {
            //int id = 0;
            //if (Request["IdConvocatoria"] != null)
            //    id = System.Convert.ToInt32(Request["IdConvocatoria"]);


            ViewBag.TotalParticipantesServicio = Nova.Models.Capacitacion_stConvocatoria.ObtenTotalParticipantesServicio(id);

            return PartialView(ViewBag.TotalParticipantesServicio);
        }

        public ActionResult TotalParticipantesSexo(int id)
        {
            //int id = 0;
            //if (Request["IdConvocatoria"] != null)
            //    id = System.Convert.ToInt32(Request["IdConvocatoria"]);


            ViewBag.TotalParticipantesSexo = Nova.Models.Capacitacion_stConvocatoria.ObtenTotalParticipantesSexo(id);

            return PartialView(ViewBag.TotalParticipantesSexo);
        }

    }
}