﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CapacitacionEmpresaController : Controller
    {
        //
        // GET: /CapacitacionEmpresa/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCapacitacionEmpresa()
        {
            var model = db.Capacitacion_ctEmpresa;
            return PartialView("_pvCapacitacionEmpresa", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionEmpresaAddNew(Nova.Models.Capacitacion_ctEmpresa item)
        {
            var model = db.Capacitacion_ctEmpresa;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCapacitacionEmpresa", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionEmpresaUpdate(Nova.Models.Capacitacion_ctEmpresa item)
        {
            var model = db.Capacitacion_ctEmpresa;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdEmpresa == item.IdEmpresa);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCapacitacionEmpresa", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionEmpresaDelete(System.Int16 IdEmpresa)
        {
            var model = db.Capacitacion_ctEmpresa;
            if (IdEmpresa != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdEmpresa == IdEmpresa);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                   


                }
            }
            return PartialView("_pvCapacitacionEmpresa", model.ToList());
        }
    }
}
