﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CapacitacionConvocatoriasCursosController : Controller
    {
        //
        // GET: /CapacitacionConvocatoriasCursos/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCapacitacionConvocatoriasCursos()
        {
            var model = db.Capacitacion_stConvocatoriasCursos.OrderByDescending(x => x.Capacitacion_stConvocatoria.FechaInicioConvocatoria);
            return PartialView("_pvCapacitacionConvocatoriasCursos", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionConvocatoriasCursosAddNew(Nova.Models.Capacitacion_stConvocatoriasCursos item)
        {
            DateTime fecha = new DateTime();
            fecha = item.FechaInicioCurso;
            item.Mes = Convert.ToByte(fecha.Date.Month);
            item.Año = Convert.ToInt16(fecha.Date.Year);

            var model = db.Capacitacion_stConvocatoriasCursos;
           if (item.ValidaModelo().IsValid)
            {

            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            }
           else
               //MessageBox.Show(ViewData, TipoMensaje.Warning, item.ValidaModelo().Mensaje);
               ViewData["EditError"] = item.ValidaModelo().Mensaje;
            return PartialView("_pvCapacitacionConvocatoriasCursos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionEmpresaUpdate(Nova.Models.Capacitacion_stConvocatoriasCursos item)
        {
            var model = db.Capacitacion_stConvocatoriasCursos;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvocatoriaCursos == item.IdConvocatoriaCursos);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCapacitacionConvocatoriasCursos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionConvocatoriasCursosDelete(System.Int16 IdConvocatoriaCursos)
        {
            var model = db.Capacitacion_stConvocatoriasCursos;
            if (IdConvocatoriaCursos != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdConvocatoriaCursos == IdConvocatoriaCursos);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvCapacitacionConvocatoriasCursos", model.ToList());
        }
    }
}
