﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

using Nova.Libraries;

using System.Net.Mail;
using System.Net;


namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionConvenioLaboralController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();


        // GET: CapacitacionCategoria
        public ActionResult Index()
        {
            return View();
        }

        // GET: CapacitacionCategoria
        public ActionResult Notificar(int id)
        {
            Capacitacion_PersonalPermitidoConvenioLaboral item = db.Capacitacion_PersonalPermitidoConvenioLaboral.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> trabajadores = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral == item.IdConvenioLaboral && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            ViewBag.trabajadores = trabajadores;
            return View(item);
        }

        [HttpPost]
        public ActionResult EnviarNotificacion(int id)
        {
            Capacitacion_PersonalPermitidoConvenioLaboral item = db.Capacitacion_PersonalPermitidoConvenioLaboral.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> correos = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral == item.IdConvenioLaboral && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            // ViewBag.trabajadores = trabajadores;
            UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

            string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Index", "Home");

            Nova.Models.Capacitacion_PersonalPermitidoCategoria.EnviarEmailInvitacion("jcmc2@hotmail.com", item.Capacitacion_stConvocatoriasCursos, url);

            MessageBox.Show(ViewData, TipoMensaje.Success, "Se han enviado los correos electrónicos exitosamente ");

            Capacitacion_PersonalPermitidoConvenioLaboral variable = db.Capacitacion_PersonalPermitidoConvenioLaboral.Find(id);

            List<Convenios_stConvenioLaboralTrabajadorCategoria> trabajadores = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral == item.IdConvenioLaboral && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
            ViewBag.trabajadores = trabajadores;


            return View("Notificar", variable);
        }

        [ValidateInput(false)]
        public ActionResult ConvenioLaboral()
        {
            var model = db.Capacitacion_PersonalPermitidoConvenioLaboral;
            return PartialView("_ConvenioLaboral", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult ConvenioLaboralAddNew(Nova.Models.Capacitacion_PersonalPermitidoConvenioLaboral item)
        {
            ViewData["Item"] = item;
            var model = db.Capacitacion_PersonalPermitidoConvenioLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_ConvenioLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult ConvenioLaboralUpdate(Nova.Models.Capacitacion_PersonalPermitidoConvenioLaboral item)
        {

            var model = db.Capacitacion_PersonalPermitidoConvenioLaboral;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPersonalPermitidoConvenioLaboral == item.IdPersonalPermitidoConvenioLaboral);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_ConvenioLaboral", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult ConvenioLaboralDelete(System.Byte IdPersonalPermitidoConvenioLaboral)
        {
            var model = db.Capacitacion_PersonalPermitidoConvenioLaboral;
            if (IdPersonalPermitidoConvenioLaboral != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPersonalPermitidoConvenioLaboral == IdPersonalPermitidoConvenioLaboral);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_ConvenioLaboral", model.ToList());
        }
    }
}