﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class CapacitacionCatalogoIncidenciasController : Controller
    {
        //
        // GET: /CapacitacionCatalogoIncidencias/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvCapacitacionCatalogoIncidencias()
        {
            var model = db.Capacitacion__ctIncidencias;
            return PartialView("_pvCapacitacionCatalogoIncidencias", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCatalogoIncidenciasAddNew(Nova.Models.Capacitacion__ctIncidencias item)
        {
            var model = db.Capacitacion__ctIncidencias;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvCapacitacionCatalogoIncidencias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCatalogoIncidenciasUpdate(Nova.Models.Capacitacion__ctIncidencias item)
        {
            var model = db.Capacitacion__ctIncidencias;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdIncidencia == item.IdIncidencia);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvCapacitacionCatalogoIncidencias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvCapacitacionCatalogoIncidenciasDelete(System.Int16 IdIncidencia)
        {
            var model = db.Capacitacion__ctIncidencias;
            if (IdIncidencia != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdIncidencia == IdIncidencia);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvCapacitacionCatalogoIncidencias", model.ToList());
        }
    }
}
