﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

using Nova.Libraries;

using System.Net.Mail;
using System.Net;

namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionAsesoriaController : Controller
    {
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        // GET: CapacitacionAsesoria
        public ActionResult Index()
        {
            return View();
        }

        // GET: CapacitacionAsesoria
        //public ActionResult Notificar(int id)
        //{
        //    Capacitacion_PersonalPermitidoAsesoria item = db.Capacitacion_PersonalPermitidoAsesoria.Find(id);

        //   List<Convenios_stConvenioLaboralTrabajadorAsesoria> trabajadores = db.Convenios_stConvenioLaboralTrabajadorAsesoria.Where(t => t.Plazas_stDistribucionPlazaAsesoria.IdAsesoria == item.IdAsesoria && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
        //   ViewBag.trabajadores = trabajadores;
        //    return View(item);
        //}

        //[HttpPost]
        // public ActionResult EnviarNotificacion(int id)
        // {
        //     Capacitacion_PersonalPermitidoAsesoria item = db.Capacitacion_PersonalPermitidoAsesoria.Find(id);

        //     List<Convenios_stConvenioLaboralTrabajadorAsesoria> correos = db.Convenios_stConvenioLaboralTrabajadorAsesoria.Where(t => t.Plazas_stDistribucionPlazaAsesoria.IdAsesoria == item.IdAsesoria && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
        //    // ViewBag.trabajadores = trabajadores;

        //     UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);

        //     string url = HttpContext.Request.Url.Scheme + "://" + HttpContext.Request.Url.Authority + u.Action("Index", "Home");

        //     Nova.Models.Capacitacion_PersonalPermitidoAsesoria.EnviarEmailInvitacion("jcmc2@hotmail.com", item.Capacitacion_stConvocatoriasCursos, url);


        //    MessageBox.Show(ViewData, TipoMensaje.Success, "Se han enviado los correos electrónicos exitosamente ");

        //    Capacitacion_PersonalPermitidoAsesoria variable = db.Capacitacion_PersonalPermitidoAsesoria.Find(id);

        //    List<Convenios_stConvenioLaboralTrabajadorAsesoria> trabajadores = db.Convenios_stConvenioLaboralTrabajadorAsesoria.Where(t => t.Plazas_stDistribucionPlazaAsesoria.IdAsesoria == item.IdAsesoria && (t.FechaTermino == null || DateTime.Now <= t.FechaTermino)).ToList();
        //    ViewBag.trabajadores = trabajadores;


        //    return View("Notificar", variable);
        // }

        [ValidateInput(false)]
        public ActionResult Asesoria()
        {
            var model = db.Capacitacion_PersonalPermitidoAsesoria;
            return PartialView("_Asesoria", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult AsesoriaAddNew(Nova.Models.Capacitacion_PersonalPermitidoAsesoria item)
        {
            ViewData["Item"] = item;
            var model = db.Capacitacion_PersonalPermitidoAsesoria;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                    model = db.Capacitacion_PersonalPermitidoAsesoria;
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                               .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);

            return PartialView("_Asesoria", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult AsesoriaUpdate(Nova.Models.Capacitacion_PersonalPermitidoAsesoria item)
        {

            var model = db.Capacitacion_PersonalPermitidoAsesoria;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdPersonalPermitidoAsesoria == item.IdPersonalPermitidoAsesoria);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_Asesoria", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult AsesoriaDelete(System.Byte IdPersonalPermitidoAsesoria)
        {
            var model = db.Capacitacion_PersonalPermitidoAsesoria;
            if (IdPersonalPermitidoAsesoria != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdPersonalPermitidoAsesoria == IdPersonalPermitidoAsesoria);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_Asesoria", model.ToList());
        }
    }

}