﻿using Nova.Libraries;
using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Helpers;
using System.Web.Mvc;

namespace Nova.Controllers.Capacitacion
{
    public class CapacitacionAltaAspiranteController : Controller
    {
        // GET: CapacitacionAltaAspirante

        private bdNovaEntities db = new bdNovaEntities();

        public ActionResult Index()
        {
            return View();
        }

        // GET: CapacitacionAltaAspirante/Details/5
        public ActionResult Details(int id)
        {
            return View();
        }

        // GET: CapacitacionAltaAspirante/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: CapacitacionAltaAspirante/Create
        [HttpPost]
        public ActionResult Index([Bind(Include = "IdKardex,IdeEmpleadoAnt,CURP,Nombre,ApellidoPaterno,ApellidoMaterno,FechaNacimiento,Sexo,RFC,Calle,NumeroInterior,Letra,NumeroExterior,Colonia,CodigoPostal,IdLocalidadVive,IdMunicipioVive,IdEstadoVive,Telefono,TelefonoCelular,CorreoElectronico,IdLocalidadNacimiento,IdMunicipioNacimiento,IdEstadoNacimiento,Fotografia,IdPais,LaboraFisicamente,Id,ProcesoCompletado,SinNumero,NSS,IdTipoSangre,FechaUltimaActualizacion,EsDocente")] Kardex_ctDatosPersonales kardex_ctDatosPersonales)
        {
            Kardex_ctDatosPersonales datos = new Kardex_ctDatosPersonales();

            try
            {
                Kardex_ctDatosPersonalesFotografias kdf = new Kardex_ctDatosPersonalesFotografias();
                kdf.IdKardex = kardex_ctDatosPersonales.IdKardex;

                // TODO: Add insert logic here
                if (Request.Files[0].FileName != "")
                {
                    var image = new WebImage(Request.Files[0].InputStream);

                    var Height = image.Height;
                    var Width = image.Width;

                    decimal Top = System.Convert.ToDecimal(Request["hfimgcrop_top"]);
                    decimal Left = System.Convert.ToDecimal(Request["hfimgcrop_left"]);
                    decimal Bottom = System.Convert.ToDecimal(Request["hfimgcrop_bottom"]);
                    decimal Right = System.Convert.ToDecimal(Request["hfimgcrop_right"]);



                    //      width: Math.round(rx * boundx) + 'px',
                    //height: Math.round(ry * boundy) + 'px',
                    //marginLeft: '-' + Math.round(rx * c.x) + 'px',
                    //marginTop: '-' + Math.round(ry * c.y) + 'px'


                    image.Crop((int)Top, (int)Left, (int)(Height - Bottom), (int)(Width - Right));

                    image.Resize(220, 228, true, true);


                    kdf.Fotografia = image.GetBytes();




                }
                else
                if (Request["hfUrlImage"] != null)
                    if (Request["hfUrlImage"] != "" && Request["hfUrlImage"].IndexOf("getFotografia") == -1)
                    {
                        kdf.Fotografia = StreamHelpers.FromFile(Request["hfUrlImage"].Replace("..", "~"));
                        ViewBag.urlimage = Request["hfUrlImage"];
                    }

                kardex_ctDatosPersonales.Calle = "SIN ESPECIFICAR";
                kardex_ctDatosPersonales.IdTipoSangre = 1;
                kardex_ctDatosPersonales.Colonia = "SIN ESPECIFICAR";
                kardex_ctDatosPersonales.CodigoPostal = 0;
                kardex_ctDatosPersonales.IdLocalidadVive = 1;
                kardex_ctDatosPersonales.IdMunicipioVive = 1;
                kardex_ctDatosPersonales.IdEstadoNacimiento = 1;
                kardex_ctDatosPersonales.IdPais = 1;

                ModelState["Calle"].Errors.Clear();
                ModelState["IdTipoSangre"].Errors.Clear();
                ModelState["Colonia"].Errors.Clear();
                ModelState["CodigoPostal"].Errors.Clear();
                

                if (ModelState.IsValid)
                {


                    db.Kardex_ctDatosPersonales.Add(kardex_ctDatosPersonales);
                    db.Kardex_ctDatosPersonalesFotografias.Add(kdf);

                    db.SaveChanges();

                    MessageBox.Show(ViewData, TipoMensaje.Success, "Registro Grabado con éxito ");

                }
                else
                {
                    var messages = string.Join("  ", ModelState.Values
                                        .SelectMany(x => x.Errors)
                                        .Select(x => x.ErrorMessage));

                    MessageBox.Show(ViewData, TipoMensaje.Warning, messages);
                }
                
            }
            catch (Exception e)
            {

                
                MessageBox.Show(ViewData, TipoMensaje.Warning, ExceptionExtensions.GetOriginalException(e).Message);
               
            }
            
            return View("Index", kardex_ctDatosPersonales);
        }

        // GET: CapacitacionAltaAspirante/Edit/5
        public ActionResult Edit(int id)
        {
            return View();
        }

        // POST: CapacitacionAltaAspirante/Edit/5
        [HttpPost]
        public ActionResult Edit(int id, FormCollection collection)
        {
            try
            {
                // TODO: Add update logic here

                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }

        // GET: CapacitacionAltaAspirante/Delete/5
        public ActionResult Delete(int id)
        {
            return View();
        }

        // POST: CapacitacionAltaAspirante/Delete/5
        [HttpPost]
        public ActionResult Delete(int id, FormCollection collection)
        {
            try
            {
                // TODO: Add delete logic here

                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }
    }
}
