﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;
using System.Transactions;
using Dapper;

namespace Nova.Controllers
{
    public class CambiarPlazaController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        private Kardex_stEstatusTrabajador kardex = new Kardex_stEstatusTrabajador();
        Seguridad.Convenios_stConvenioLaboralTrabajadorCategoria usuario =  Seguridad.Identidad.Usuario();
        //
        // GET: /CambiarPlaza/

        public ActionResult Index()
        {
            var convenios_stconveniolaboraltrabajadorcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Include(c => c.Catalogos_ctEstructuraOrganica).Include(c => c.Convenios_stConvenioLaboralTrabajador).Include(c => c.Plazas_stDistribucionPlazaCategoria);
            return View(convenios_stconveniolaboraltrabajadorcategoria.ToList());
        }

        //
        // GET: /CambiarPlaza/Details/5

        public ActionResult Details(int id = 0)
        {
            Convenios_stConvenioLaboralTrabajadorCategoria convenios_stconveniolaboraltrabajadorcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            if (convenios_stconveniolaboraltrabajadorcategoria == null)
            {
                return HttpNotFound();
            }
            return View(convenios_stconveniolaboraltrabajadorcategoria);
        }

        //
        // GET: /CambiarPlaza/Create

        public ActionResult Create(int idtrabajador)
        {
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador");
            ViewBag.IdDistribucionPlazaCategoria = new SelectList(db.Plazas_stDistribucionPlazaCategoria, "IdDistribucionPlazaCategoria", "IdDistribucionPlazaCategoria");
            Session["idtrabajador"] = idtrabajador;
            return View();
        }
        public ActionResult MostrarGridConveniolaboralTrabajadorCategoria()
        {
            int idtrabajador = Convert.ToInt32(Session["idtrabajador"]);
            Convenios_stConvenioLaboralTrabajadorCategoria Valida = new Convenios_stConvenioLaboralTrabajadorCategoria();
            var model = from a in db.Convenios_stConvenioLaboralTrabajadorCategoria
                        join b in db.Convenios_stConvenioLaboralTrabajador on a.IdConvenioLaboralTrabajador equals b.IdConvenioLaboralTrabajador
                        join c in db.Plazas_stDistribucionPlazaCategoria on a.IdDistribucionPlazaCategoria equals c.IdDistribucionPlazaCategoria
                        join j in db.Catalogos_ctEstructuraOrganica on c.IdEstructuraOrganica equals j.IdEstructuraOrganica
                        join d in db.Plazas_ctCategoria on c.IdCategoria equals d.IdCategoria
                        join e in db.Convenios_stRelacionConvenioLaboral on d.IdRelacionConvenioLaboral equals e.IdRelacionConvenioLaboral
                        join f in db.Catalogos_ctConvenioLaboral on e.IdConvenioLaboral equals f.IdConvenioLaboral
                        join g in db.Catalogos_ctRelacionLaboral on e.IdRelacionLaboral equals g.IdRelacionLaboral
                        join h in db.Kardex_ctTrabajador on b.IdTrabajador equals h.IdTrabajador
                        join i in db.Kardex_ctDatosPersonales on h.IdKardex equals i.IdKardex
                        join k in db.Catalogos_ctEstructuraOrganica on a.IdEstructuraOrganica equals k.IdEstructuraOrganica
                        where b.IdTrabajador == idtrabajador && a.EsCancelado == false
                        orderby a.IdConvenioLaboralTrabajadorCategoria descending
                        select new
                        {
                            IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria,
                            Nombre = i.Nombre,
                            ApellidoPaterno = i.ApellidoPaterno,
                            ApellidoMaterno = i.ApellidoMaterno,
                            IdTrabajador = b.IdTrabajador,
                            ConvenioLaboral = f.ConvenioLaboral,
                            RelacionLaboral = g.RelacionLaboral,
                            Categoria = d.Categoria,
                            EstructuraOrganica = j.EstructuraOrganica,
                            FechaInicioConvenioTrabajadorCategoria = a.FechaInicio,
                            FechaTerminoConvenioTrabajadorCategoria = a.FechaTermino,
                            IdConvenioLaboral = f.IdConvenioLaboral,
                            IdDistribucionPlazaCategoria = a.IdDistribucionPlazaCategoria,
                            IdRelacionConvenioLaboral = d.IdRelacionConvenioLaboral,
                            IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador,
                            Observacion = a.Observacion,
                            LaboraFisicamente = k.EstructuraOrganica
                        };
            //var model = db.vwIdConvenioLaboralTrabajadorCategoria.Where(s => s.IdTrabajador == idtrabajador && s.EsCancelado==false ).OrderByDescending(s => s.FechaInicioConvenioTrabajadorCategoria);
            //Nova.Models.ValidacionModelos.ResultadoValidacion resultado = new ValidacionModelos.ResultadoValidacion();
            //resultado = Valida.ValidaModelo(idtrabajador);
            if (model.Count() > 0)
            {
                Session["idCLTCAnterior"] = model.First().IdConvenioLaboralTrabajadorCategoria;
                Session["idCLTAnterior"] = model.First().IdConvenioLaboralTrabajador;
                Session["idDPCAnterior"] = model.First().IdDistribucionPlazaCategoria;
                Session["IdRCLAnterior"] = model.First().IdRelacionConvenioLaboral;
                Session["FechaInicioAnterior"] = model.First().FechaInicioConvenioTrabajadorCategoria;
                Session["EsCambioPlaza"] = "SI";

                if (!Valida.ValidaModelo(idtrabajador).IsValid)
                {
                    Session["EsCambioPlaza"] = "NO";
                    //MessageBox.Show(ViewData, TipoMensaje.Warning, "El convenio laboral del trabajador tiene fecha de término, no procede el cambio de plaza");
                    throw new ApplicationException   ("El convenio laboral del trabajador tiene fecha de término, no procede el cambio de plaza");
                }
                else
                {
                    int idclt = Convert.ToInt32(Valida.parenresult.Mensaje);
                    Session["idclt"] = idclt;
                    //var RelacionConvenios = from a in db.vwIdConvenioLaboralTrabajadorCategoria
                    //                        where a.IdConvenioLaboralTrabajador == idclt && a.EsCancelado == false
                    //                        orderby a.FechaInicioConvenio descending

                    //                        select new { IdRelacionConvenioLaboral = a.IdRelacionConvenioLaboral };
                    //foreach (var item in RelacionConvenios)
                    //{
                    //    Session["IdRelacionConvenioLaboral"] = item.IdRelacionConvenioLaboral;
                    //    break;

                    //}
                }
            }
            else
            {
                Session["EsCambioPlaza"] = "NO";
                MessageBox.Show(ViewData, TipoMensaje.Warning, "El trabajador no tiene una plaza asignada, no procede el cambio de plaza, verifíquelo");

            }
            return PartialView("MostrarGridConveniolaboralTrabajadorCategoria", model.ToList());
        }
        public ActionResult ObtenerEstructuraOrganica()
        {
            //var Model = from a in db.vwPlazasEstructuraOrganica
            //            select new { ID = a.IdEstructuraOrganica, ParentID=a.IdEstructuraOrganicaPadre,EstructuraOrganica= a.EstructuraOrganica };

            var Estructura = db.vwPlazasEstructuraOrganica.OrderBy(s => s.EstructuraOrganica);
            List<EstructuraCategoria> Model = new List<EstructuraCategoria>();
            foreach (var item in Estructura)
            {
                EstructuraCategoria plaza = new EstructuraCategoria();
                plaza.ID = item.IdEstructuraOrganica;
                plaza.ParentID = item.IdEstructuraOrganicaPadre;
                plaza.Categoria = "";
                plaza.IdDistribucionPlazaCategoria = 0;
                plaza.IdEstructuraOrganica = item.IdEstructuraOrganica;
                plaza.IdEstructuraOrganicaPadre = item.IdEstructuraOrganicaPadre;
                plaza.EstructuraOrganica = item.EstructuraOrganica;
                plaza.EsVacante = null;
                plaza.EsVigente = null;
                Model.Add(plaza);
            }

            return PartialView("_pvEstructuraOrganica", Model.ToList());
        }
        public ActionResult ObtenerPlazasVacantes()
        {

            List<Convenios_stConvenioLaboralTrabajadorCategoria> Universo = new List<Convenios_stConvenioLaboralTrabajadorCategoria>();


            string query = @"SELECT IdConvenioLaboralTrabajador  FROM  Convenios_stConvenioLaboralTrabajadorCategoria WHERE IdDistribucionPlazaCategoria=1849 
  GROUP BY IdConvenioLaboralTrabajador
  ORDER BY MAX(FechaInicio)DESC";

            Libraries.DapperQuery dp = new Libraries.DapperQuery("bdNovaEntities");
            var tempo = dp.connection.Query<ConvenioGrupo>(query).ToArray();
            var IdConveniosLaboralesActuales = tempo.Select(b => b.IdConvenioLaboralTrabajador).ToArray();

            Universo = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(p => (p.FechaTermino != null && p.FechaTermino < DateTime.Now ) && IdConveniosLaboralesActuales.Contains(p.IdConvenioLaboralTrabajadorCategoria)).ToList();
            if (Universo.Count() > 0)
            {
                db.Configuration.AutoDetectChangesEnabled = false;
                db.Configuration.ValidateOnSaveEnabled = false;
                //EntityFrameworkExtensions based = new EntityFrameworkExtensions ();
                List<Plazas_stDistribucionPlazaCategoria> listauni = new List<Plazas_stDistribucionPlazaCategoria>();
                foreach (var item in Universo.Where(p => p.Plazas_stDistribucionPlazaCategoria.EsVacante == false))
                {
                    Plazas_stDistribucionPlazaCategoria dpc = db.Plazas_stDistribucionPlazaCategoria.Where(t=> t.IdDistribucionPlazaCategoria== item.IdDistribucionPlazaCategoria).FirstOrDefault();
                    dpc.EsVacante = true;
                    dpc.EsVigente = true;
                    dpc.EsAutorizada = true;
                   // db.Entry(dpc).State = System.Data.Entity.EntityState.Modified;
                    dpc.Catalogos_ctEstructuraOrganica=null;
                    dpc.Convenios_stConvenioLaboralTrabajadorCategoria=null;
                    dpc.Plazas_ctCategoria=null;
                        
       
                    listauni.Add(dpc);
                }
                db.Plazas_stDistribucionPlazaCategoria.AddRange(listauni);

                foreach (var p in listauni)
                {
                    db.Entry(p).State = System.Data.Entity.EntityState.Modified;
                }
              

                db.SaveChanges();

              

            }

            int idrclt = Convert.ToInt32(Session["IdRCLAnterior"]);
            int idpadre = 0;
            var Plazas = from a in db.vwEstructuraOrganicaCambioPlaza
                         where a.EsVacante == true && a.EsVigente == true && a.IdRelacionConvenioLaboral == idrclt //incluir vacante y vigente
                         orderby a.EstructuraOrganica, a.Categoria
                         select new { ID = 0, ParentID = 0, IdEstructuraOrganica = a.IdEstructuraOrganica, Categoria = a.Categoria, IdEstructuraOrganicaPadre = a.IdEstructuraOrganicaPadre, EstructuraOrganica = a.EstructuraOrganica, IdDistribucionPlazaCategoria = a.IdDistribucionPlazaCategoria, EsVacante = a.EsVacante, EsVigente = a.IdRelacionConvenioLaboral == idrclt ? a.EsVigente : false };
            List<EstructuraCategoria> Model = new List<EstructuraCategoria>();
            List<EstructuraCategoria> LPlazasVacantesBase = new List<EstructuraCategoria>();

            foreach (var item in Plazas)
            {
                EstructuraCategoria plaza = new EstructuraCategoria();
                plaza.ID = item.ID;
                plaza.ParentID = item.ParentID;
                plaza.Categoria = item.Categoria;
                plaza.IdDistribucionPlazaCategoria = item.IdDistribucionPlazaCategoria;
                plaza.IdEstructuraOrganica = item.IdEstructuraOrganica;
                plaza.IdEstructuraOrganicaPadre = item.IdEstructuraOrganicaPadre;
                plaza.EstructuraOrganica = item.EstructuraOrganica;
                plaza.EsVacante = item.EsVacante;
                plaza.EsVigente = item.EsVigente;
                Model.Add(plaza);
            }
            int NuRegistro = 0;
            foreach (var item in Model)
            {
                NuRegistro = NuRegistro + 1;
                item.ID = NuRegistro;
            }
            LPlazasVacantesBase = Model;
            foreach (var item2 in Model)
            {
                if (item2.IdEstructuraOrganicaPadre != 0)
                {
                    //idpadre = LPlazasVacantesBase.FirstOrDefault(s => s.IdEstructuraOrganica == item2.IdEstructuraOrganicaPadre).ID;
                    if (LPlazasVacantesBase.FirstOrDefault(s => s.IdEstructuraOrganica == item2.IdEstructuraOrganicaPadre) == null)
                        item2.ParentID = 0;
                    else
                        idpadre = LPlazasVacantesBase.First(s => s.IdEstructuraOrganica == item2.IdEstructuraOrganicaPadre).ID;
                    item2.ParentID = idpadre;
                }
            }
            return PartialView("_pvPlazasVacantesConvenio", Model.ToList());

        }


        //
        // POST: /CambiarPlaza/Create

        [HttpPost]
        public ActionResult Create(Convenios_stConvenioLaboralTrabajadorCategoria convenios_stconveniolaboraltrabajadorcategoria)
        {
            //bdNovaEntities db = new bdNovaEntities();
            //Boolean resultado = false;
            //int idrcl = Convert.ToInt32(Session["IdRelacionConvenioLaboral"]);
            //var Nominas = from a in db.Nomina_ctPlantillaNomina
            //              join b in db.Nomina_stNomina on a.IdPlantillaNomina equals b.IdPlantillaNomina 
            //              where a.IdRelacionConvenioLaboral == idrcl && b.EsCerrada == true && (b.FechaInicio <= convenios_stconveniolaboraltrabajadorcategoria.FechaInicio && b.FechaTermino >= convenios_stconveniolaboraltrabajadorcategoria.FechaInicio)
            //              select new {b.IdPlantillaNomina};
            //if (Nominas.Count() > 0)
            //{
            //    resultado = true;
            //}
            Convenios_stConvenioLaboralTrabajadorCategoria ivalida = new Convenios_stConvenioLaboralTrabajadorCategoria();
            //int idrcl = Convert.ToInt32(Session["IdRelacionConvenioLaboral"]);
            //Session["idCLTCAnterior"] = model.First().IdConvenioLaboralTrabajadorCategoria;
            //Session["idCLTAnterior"] = model.First().IdConvenioLaboralTrabajador;
            //Session["idDPCAnterior"] = model.First().IdDistribucionPlazaCategoria;
            //Session["IdRCLAnterior"] = model.First().IdRelacionConvenioLaboral;
            //Session["FechaInicioAnterior"] = model.First().FechaInicioConvenioTrabajadorCategoria;
            Boolean EsCambioPlaza = true;
            if (convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria == Convert.ToInt32(Session["idDPCAnterior"]) || convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria == 0)
            {

                EsCambioPlaza = false;
                convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria = Convert.ToInt32(Session["idDPCAnterior"]);
                //ModelState.Clear();
            }
            int IdRCLNuevo = ivalida.ObtenerIdRCL(convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria);
            Boolean salida = ivalida.EstaFechaInicioPlazaEnNominaCerrada(convenios_stconveniolaboraltrabajadorcategoria.FechaInicio, IdRCLNuevo);
            if (salida)
            {
                ModelState.AddModelError("FechaInicio", "La fecha de inicio pertenece a una nómina cerrada, no aplica el cambio");
            }

            if (convenios_stconveniolaboraltrabajadorcategoria.FechaInicio != null && convenios_stconveniolaboraltrabajadorcategoria.FechaTermino != null)
            {
                if (convenios_stconveniolaboraltrabajadorcategoria.FechaInicio > convenios_stconveniolaboraltrabajadorcategoria.FechaTermino)
                {
                    ModelState.AddModelError("FechaTermino", "La fecha de término debe ser mayor que la fecha de inicio");
                }
            }
            DateTime fechaaterior = Convert.ToDateTime(Session["FechaInicioAnterior"]);
            if (convenios_stconveniolaboraltrabajadorcategoria.FechaInicio != null)
            {
                if (convenios_stconveniolaboraltrabajadorcategoria.FechaInicio < fechaaterior)
                {
                    ModelState.AddModelError("FechaInicio", "La fecha de inicio debe ser mayor que la fecha de inicio de la última plaza asignada al trabajador");
                }
            }

            if (ModelState.IsValid)
            {
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                {
                    try
                    {
                        //inicia transacción
                        convenios_stconveniolaboraltrabajadorcategoria.FechaCreacion = DateTime.Now;
                        convenios_stconveniolaboraltrabajadorcategoria.IdConvenioLaboralTrabajador = Convert.ToInt16(Session["idclt"]);
                        convenios_stconveniolaboraltrabajadorcategoria.EsCancelado = false;
                        var Resultado = from a in db.Plazas_stDistribucionPlazaCategoria
                                        where a.IdDistribucionPlazaCategoria == convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria
                                        select new { a.IdEstructuraOrganica };
                        int IdEstruOrgNuevo = Resultado.First().IdEstructuraOrganica;
                        if (IdEstruOrgNuevo == convenios_stconveniolaboraltrabajadorcategoria.IdEstructuraOrganica)
                        {
                            convenios_stconveniolaboraltrabajadorcategoria.EsComisionado = false;
                        }
                        else
                        {
                            convenios_stconveniolaboraltrabajadorcategoria.EsComisionado = true;
                        }
                        convenios_stconveniolaboraltrabajadorcategoria.UserId = usuario.IdConvenioLaboralTrabajadorCategoria;
                        Session["FechaInicioNuevaPlaza"] = convenios_stconveniolaboraltrabajadorcategoria.FechaInicio;

                        // Graba el convenio laboral trabajador categoria
                        db.Convenios_stConvenioLaboralTrabajadorCategoria.Add(convenios_stconveniolaboraltrabajadorcategoria);
                        db.SaveChanges();
                        if (EsCambioPlaza)
                        {
                            // hacer plaza anterior en distribución plaza  vacante
                            int idpcA = Convert.ToInt32(Session["idDPCAnterior"]);
                            using (bdNovaEntities context = new bdNovaEntities())
                            {
                                try
                                {
                                    Plazas_stDistribucionPlazaCategoria coof = context.Plazas_stDistribucionPlazaCategoria.First(i => i.IdDistribucionPlazaCategoria == idpcA);
                                    coof.EsVacante = true;
                                    coof.Codigo = "1";
                                    context.Entry(coof).State = System.Data.Entity.EntityState.Modified;
                                    context.SaveChanges();
                                    //context.Dispose();
                                }
                                catch (Exception e)
                                {

                                    throw ExceptionExtensions.GetOriginalException(e);
                                }
                            }
                            // hacer plaza nueva en distribución plaza no vacante
                            using (bdNovaEntities context = new bdNovaEntities())
                            {
                                try
                                {
                                    Plazas_stDistribucionPlazaCategoria coof2 = context.Plazas_stDistribucionPlazaCategoria.First(i => i.IdDistribucionPlazaCategoria == convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria);
                                    coof2.EsVacante = false;
                                    coof2.Codigo = "1";
                                    context.Entry(coof2).State = System.Data.Entity.EntityState.Modified;
                                    context.SaveChanges();
                                    //context.Dispose();
                                }
                                catch (Exception e)
                                {

                                    throw ExceptionExtensions.GetOriginalException(e);
                                }
                            }
                        }
                        // Hacer fecha de término del ConvenioLaboralTrabajadorCategoría anterior a la fecha de inicio del nuevo convenio laboral tranajador menos un día
                        int idcltcaa = Convert.ToInt32(Session["idCLTCAnterior"]);
                        DateTime fechaInicioNuevaPlaza = Convert.ToDateTime(Session["FechaInicioNuevaPlaza"]);
                        using (bdNovaEntities context = new bdNovaEntities())
                        {
                            try
                            {
                                Convenios_stConvenioLaboralTrabajadorCategoria conLTC = context.Convenios_stConvenioLaboralTrabajadorCategoria.First(i => i.IdConvenioLaboralTrabajadorCategoria == idcltcaa);
                                if (conLTC.FechaTermino == DateTime.Now)
                                {
                                    conLTC.FechaTermino = DateTime.Now;
                                }
                                else
                                {
                                    conLTC.FechaTermino = fechaInicioNuevaPlaza.Subtract(System.TimeSpan.FromDays(1));

                                }
                                context.Entry(conLTC).State = System.Data.Entity.EntityState.Modified;
                                context.SaveChanges();
                                //context.Dispose();
                            }
                            catch (Exception e)
                            {

                                throw ExceptionExtensions.GetOriginalException(e);
                            }
                        }

                        //si existen nómina abiertas recalcular
                        //if (Session["NominaAbierta"] == "SI")
                        //{
                        //    //int IdRCLNuevo = ivalida.ObtenerIdRCL(convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria);
                        //    var NominasAbiertas = from a in db.Nomina_ctPlantillaNomina
                        //                          join b in db.Nomina_stNomina on a.IdPlantillaNomina equals b.IdPlantillaNomina
                        //                          where b.EsCerrada == false   && (b.FechaInicio <= convenios_stconveniolaboraltrabajadorcategoria.FechaInicio && b.FechaTermino >= convenios_stconveniolaboraltrabajadorcategoria.FechaInicio)
                        //                          select new { b.IdNomina };
                        //    int idt = Convert.ToInt16(Session["idtrabajador"]);
                        //    foreach (var item in NominasAbiertas)
                        //    {

                        //        //BorraNominaTrabajador(item.IdNomina,idcltc)
                        //        int idCoLtcAnterior = Convert.ToInt32(Session["idCLTCAnterior"]);
                        //        using (bdNovaEntities context = new bdNovaEntities())
                        //        {
                        //            try
                        //            {
                        //                Nomina_stNominaTrabajador nominatrabajador = context.Nomina_stNominaTrabajador.First(i => i.IdConvenioLaboralTrabajadorCategoria == idCoLtcAnterior && i.IdNomina == item.IdNomina);
                        //                context.Entry(nominatrabajador).State = System.Data.Entity.EntityState.Deleted;
                        //                context.Nomina_stNominaTrabajador.Remove(nominatrabajador);
                        //                context.SaveChanges();
                        //            }
                        //            catch (Exception e)
                        //            {

                        //                throw ExceptionExtensions.GetOriginalException(e);
                        //            }
                        //        }
                        //        //CaculaNominaTrabajador(item.IdNomina,idt);
                        //    }
                        //}
                       // Checa tipo de cambio
                        if (EsCambioPlaza)
                        {
                            kardex.GrabaEstatusTrabajadorPorNombre(convenios_stconveniolaboraltrabajadorcategoria.IdConvenioLaboralTrabajadorCategoria, "CAMBIO DE PLAZA");
                        }
                        else
                        {
                            kardex.GrabaEstatusTrabajadorPorNombre(convenios_stconveniolaboraltrabajadorcategoria.IdConvenioLaboralTrabajadorCategoria, "CAMBIO DE ADSCRIPCIÓN");
                        }
                        // commit
                        trans.Complete();
                    }
                    catch (Exception e)
                    {
                        throw ExceptionExtensions.GetOriginalException(e);

                        //ViewData["EditError"] = e.Message;
                        // all changes will be rolled back
                    }

                } // transaction scope end
                // termina transacción

                //return ("vConfirmarCambioPlaza","CambiarPlaza", convenios_stconveniolaboraltrabajadorcategoria);
                //return RedirectToAction("Index");
                return View(convenios_stconveniolaboraltrabajadorcategoria);
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", convenios_stconveniolaboraltrabajadorcategoria.IdEstructuraOrganica);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", convenios_stconveniolaboraltrabajadorcategoria.IdConvenioLaboralTrabajador);
            ViewBag.IdDistribucionPlazaCategoria = new SelectList(db.Plazas_stDistribucionPlazaCategoria, "IdDistribucionPlazaCategoria", "IdDistribucionPlazaCategoria", convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria);
            return View(convenios_stconveniolaboraltrabajadorcategoria);
        }
        [HttpPost]
        [OutputCache(Location = System.Web.UI.OutputCacheLocation.None, NoStore = true)]
        public JsonResult ValidaFechaInicioEnNominaAbierta(string FI, string IdDPC)
        {
            DateTime fi = Convert.ToDateTime(FI);
            //   valido fecha de inicio de la nueva plaza con las nominas abiertas
            Convenios_stConvenioLaboralTrabajadorCategoria ivalida = new Convenios_stConvenioLaboralTrabajadorCategoria();
            int IdDPCNnuevo = Convert.ToInt32(IdDPC);

            int idrcl2 = ivalida.ObtenerIdRCL(IdDPCNnuevo);

            Session["NominaAbierta"] = "NO";
            Boolean validaFinicioNominaAbierta = ivalida.EstaFechaInicioPlazaEnNominaAbierta(fi, idrcl2);
            if (validaFinicioNominaAbierta)
            {
                Session["NominaAbierta"] = "SI";
            }

            return Json(new
            {
                status = Session["NominaAbierta"]
            });
        }

        public ActionResult EjecutaCambioPlaza(Convenios_stConvenioLaboralTrabajadorCategoria convenios_stconveniolaboraltrabajadorcategoria)
        {
            convenios_stconveniolaboraltrabajadorcategoria.FechaCreacion = DateTime.Now;
            convenios_stconveniolaboraltrabajadorcategoria.IdConvenioLaboralTrabajador = Convert.ToSByte(Session["idclt"]);
            convenios_stconveniolaboraltrabajadorcategoria.EsCancelado = false;
            convenios_stconveniolaboraltrabajadorcategoria.EsComisionado = false;
            convenios_stconveniolaboraltrabajadorcategoria.UserId = 1;
            //convenios_stconveniolaboraltrabajadorcategoria.IdEstructuraOrganica = Request.
            db.Convenios_stConvenioLaboralTrabajadorCategoria.Add(convenios_stconveniolaboraltrabajadorcategoria);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        public ActionResult Edit(int id = 0)
        {
            Convenios_stConvenioLaboralTrabajadorCategoria convenios_stconveniolaboraltrabajadorcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            if (convenios_stconveniolaboraltrabajadorcategoria == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", convenios_stconveniolaboraltrabajadorcategoria.IdEstructuraOrganica);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", convenios_stconveniolaboraltrabajadorcategoria.IdConvenioLaboralTrabajador);
            ViewBag.IdDistribucionPlazaCategoria = new SelectList(db.Plazas_stDistribucionPlazaCategoria, "IdDistribucionPlazaCategoria", "IdDistribucionPlazaCategoria", convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria);
            return View(convenios_stconveniolaboraltrabajadorcategoria);
        }

        //
        // POST: /CambiarPlaza/Edit/5

        [HttpPost]
        public ActionResult Edit(Convenios_stConvenioLaboralTrabajadorCategoria convenios_stconveniolaboraltrabajadorcategoria)
        {
            if (ModelState.IsValid)
            {
                db.Entry(convenios_stconveniolaboraltrabajadorcategoria).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica, "IdEstructuraOrganica", "EstructuraOrganica", convenios_stconveniolaboraltrabajadorcategoria.IdEstructuraOrganica);
            ViewBag.IdConvenioLaboralTrabajador = new SelectList(db.Convenios_stConvenioLaboralTrabajador, "IdConvenioLaboralTrabajador", "IdConvenioLaboralTrabajador", convenios_stconveniolaboraltrabajadorcategoria.IdConvenioLaboralTrabajador);
            ViewBag.IdDistribucionPlazaCategoria = new SelectList(db.Plazas_stDistribucionPlazaCategoria, "IdDistribucionPlazaCategoria", "IdDistribucionPlazaCategoria", convenios_stconveniolaboraltrabajadorcategoria.IdDistribucionPlazaCategoria);
            return View(convenios_stconveniolaboraltrabajadorcategoria);
        }

        //
        // GET: /CambiarPlaza/Delete/5

        public ActionResult Delete(int id = 0)
        {
            Convenios_stConvenioLaboralTrabajadorCategoria convenios_stconveniolaboraltrabajadorcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            if (convenios_stconveniolaboraltrabajadorcategoria == null)
            {
                return HttpNotFound();
            }
            return View(convenios_stconveniolaboraltrabajadorcategoria);
        }

        //
        // POST: /CambiarPlaza/Delete/5

        [HttpPost, ActionName("Delete")]
        public ActionResult DeleteConfirmed(int id)
        {
            Convenios_stConvenioLaboralTrabajadorCategoria convenios_stconveniolaboraltrabajadorcategoria = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(id);
            db.Convenios_stConvenioLaboralTrabajadorCategoria.Remove(convenios_stconveniolaboraltrabajadorcategoria);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            db.Dispose();
            base.Dispose(disposing);
        }
    }
}