﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.Calculos
{
    public class ConcentradoNominaTrabajadorController : Controller
    {
        // GET: ConcentradoNominaTrabajador
        bdNovaEntities db = new bdNovaEntities();
        //public ActionResult Index()
        //{
            //var model = db.Nomina_stNominaTrabajador.ToList();
            //return View(model);
        //}
        public ActionResult ConcentradoTrabajador(int IdNomina, int IdConvenioLaboralTrabajadorCategoria) 
        {
            var model = db.Nomina_stNominaTrabajador.Where(i => i.IdNomina == IdNomina && i.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
            if (model.Count()>0)
                
                return PartialView(model);
            else
                throw new InvalidOperationException("No existen datos para el trabajador");
        
        }
        public JsonResult PercepcionDetalle(Int64 IdNominaTrabajador)
        {
            var model = db.Percepciones_stNominaTrabajadorPercepciones.Where(n=>n.IdNominaTrabajador==IdNominaTrabajador).Select(x=> new
            {
             IdNominaTrabajador= x.IdNominaTrabajador,
             Percepcion = (x.EsAjusteHorasExcedentes || x.EsAjusteHorasInterinas) ? "AJUSTE " + x.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion : x.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion,
             Importe=x.Importe
            }).ToArray();
            //return PartialView("pvPercepcionesDetail", model);
            var JsonPercepciones = Json(model, JsonRequestBehavior.AllowGet);
            return JsonPercepciones;
        }
        public JsonResult DeduccionDetalle(Int64 IdNominaTrabajador) 
        {

            var model = db.Deducciones_stNominaTrabajadorDeduccion.Where(d => d.IdNominaTrabajador == IdNominaTrabajador).Select(x => new
            {
                x.IdNominaTrabajador,
                x.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion.Deduccion,
                x.Importe
            }).ToArray();

            var creditos = db.Creditos_stNominaCreditoTrabajador.Where(d => d.IdNominaTrabajador == IdNominaTrabajador).Select(x => new
            {
             IdNominaTrabajador=   x.IdNominaTrabajador,
             Deduccion=   x.Creditos_stCreditoTrabajador.Catalogos_ctTipoCredito.TipoCredito,
            Importe=    x.Importe
            }).ToArray();

            int total = model.Count();
            Array.Resize(ref model, total + creditos.Count());

            foreach (var item in creditos)
            {
                
                model[total] = new { IdNominaTrabajador = item.IdNominaTrabajador, Deduccion= item.Deduccion, Importe= item.Importe };
                total++;
            }


            var pensiones = db.Pensiones_stNominaPensionTrabajador.Where(d => d.IdNominaTrabajador == IdNominaTrabajador).Select(x => new
            {
                IdNominaTrabajador = x.IdNominaTrabajador,
                Deduccion = "PENSIÓN ALIMENTICIA",
                Importe = x.Importe
            }).ToArray();

            int total2 = model.Count();
            Array.Resize(ref model, total + pensiones.Count());

            foreach (var item in pensiones)
            {

                model[total2] = new { IdNominaTrabajador = item.IdNominaTrabajador, Deduccion = item.Deduccion, Importe = item.Importe };
                total2++;
            }


            var JsonDeducciones = Json(model, JsonRequestBehavior.AllowGet);
            return JsonDeducciones;
        }
    }
}