﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Nova.Libraries;
using Nova.Models;
using Nova.Models.Calculos;
using DevExpress.Web.Mvc;
using Nova.Models.Designpattern;

namespace Nova.Controllers.Calculos
{
    public class CalcularNominaTrabajadorController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();
        //
        // GET: /CalcularNominaTrabajador/

        public ActionResult Index(int IdConvenioLaboralTrabajadorCategoria = 0)
        {
            
            DateTime FechaActual = DateTime.Today;
            int ComparaFecha = 0;
            if (IdConvenioLaboralTrabajadorCategoria > 0)
            {
               
               
                var model = from a in db.Nomina_stNomina
                            join b in db.Nomina_ctPlantillaNomina on a.IdPlantillaNomina equals b.IdPlantillaNomina
                            join c in db.Catalogos_ctParametrosRelacionLaboral on b.IdParametroRelacionLaboral equals c.IdParametroRelacionLaboral
                           // join d in db.Catalogos_ctConvenioLaboral on c.IdConvenioLaboral equals d.IdConvenioLaboral
                            join k in db.Convenios_stRelacionConvenioLaboral on c.IdRelacionConvenioLaboral equals k.IdRelacionConvenioLaboral
                            join e in db.Plazas_ctCategoria on k.IdRelacionConvenioLaboral equals e.IdRelacionConvenioLaboral
                            join f in db.Plazas_stDistribucionPlazaCategoria on e.IdCategoria equals f.IdCategoria
                            join g in db.Convenios_stConvenioLaboralTrabajadorCategoria on f.IdDistribucionPlazaCategoria equals g.IdDistribucionPlazaCategoria
                            join h in db.Catalogos_ctMes on a.IdMesGeneracion equals h.IdMes
                            join i in db.Catalogos_ctQuincenaMes on a.IdQuincenaMes equals i.IdQuincenaMes
                            join j in db.Configuracion_stIsrGrupo on a.IdIsrGrupo equals j.IdIsrGrupo
                            where a.EsCerrada == false && g.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria
                            orderby a.Año,a.Catalogos_ctQuincenaMes descending 
                            select new { g.IdConvenioLaboralTrabajador, a.IdNomina, a.IdPlantillaNomina, b.Plantilla, a.Año, g.FechaInicio, g.FechaTermino, h.Mes, i.QuincenaMes, a.AliasNomina, j.IsrGrupo, a.EsCerrada, a.UniversoTrabajadores, a.TrabajadoresProcesados };

                 if (model.Count() != 0)
                {
                    int plantillas = model.Count();
                    int IdConvenioLaboralTrabajador=model.Take(1).SingleOrDefault().IdConvenioLaboralTrabajador;
                    Session["IdConvenioLaboralTrabajadorCategoria"] = IdConvenioLaboralTrabajadorCategoria;
                    Session["IdConvenioLaboralTrabajador"] = IdConvenioLaboralTrabajador;
                     //var FechaConvenioTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(t => t.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).Select(s => s.FechaTermino).SingleOrDefault().;
                     var fechas= model.Take(1).SingleOrDefault();
                    if (fechas!=null)
                  //  DateTime FechaConvenioTrabajador =   fechas.FechaTermino.Value;
                    if (!fechas.FechaTermino.HasValue)
                        //ComparaFecha = String.Compare(FechaConvenioTrabajador.ToShortDateString(), FechaActual.ToShortDateString());
                        return View(model.ToList());
                   
                    if (fechas.FechaTermino.Value >= FechaActual)
                        return View(model.ToList());
                       
                    else
                    {
                       
                        throw new InvalidOperationException("No hay un convenio laboral vigente para este trabajador");
                         
                    }
                }
                else
                    throw new InvalidOperationException("No hay plantillas o nóminas configuradas para este trabajador");
            }
            else
                throw new InvalidOperationException("No hay un convenio laboral vigente para este trabajador");

           
        } ///INDEX
         
       // [HttpPost]
        public ActionResult ObtenInformacionNomina(int IdNomina)
        
        {
            var model = from a in db.Nomina_stNomina
                        join b in db.Nomina_ctPlantillaNomina on a.IdPlantillaNomina equals b.IdPlantillaNomina
                        join c in db.Configuracion_stIsrGrupo on a.IdIsrGrupo equals c.IdIsrGrupo
                        where a.EsCerrada == false && a.IdNomina == IdNomina
                        select new {a.IdNomina, b.Plantilla, a.Año, a.FechaInicio, a.FechaTermino, a.AliasNomina, c.IsrGrupo, a.EsCerrada };

            return PartialView("_pvInformacionNomina",model.ToList());
        }

        [ValidateInput(false)]
        public ActionResult DatosTrabajdor()
        {

            Int16 id = System.Convert.ToInt16(Session["IdConvenioLaboralTrabajador"]);
            var model = db.vwDatosAspirantesTrabajadores.Where(d => d.IdConvenioLaboralTrabajador == id).ToList();
            return PartialView("_pvDatosTrabajador", model);
        }
        [HttpPost]
        public ActionResult CalcularNominaTrabajador(int IdNomina)
        {
           
            
            try
            {
                //int idn = Convert.ToInt32(Session["IdNomina"]);
                //int idclt = Convert.ToInt32(Session["IdConvenioLaboralTrabajadorCategoria"]);
                //Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(idn, idclt);

                //CalculosNomina calculosnomina = new CalculosNomina(ref nt);

                
                //Int16 IdConvenioLaboralTrabajador = System.Convert.ToInt16(Session["IdConvenioLaboralTrabajador"]);
                //CalcularNomina Nomina = new CalcularNomina(IdNomina, IdConvenioLaboralTrabajador);
              ;
                 
                Session["ErrorCalculos"] = "Cálculos realizados correctamente, valide el reporte correspondiente.";
                return new HttpStatusCodeResult(0, "Cálculos realizados correctamente, valide el reporte correspondiente.");
            }
            catch (Exception e)
            {

                Session["ErrorCalculos"] = ExceptionExtensions.GetOriginalException(e).Message;
                //throw new InvalidOperationException(e.Message);
                return new HttpStatusCodeResult(400, ExceptionExtensions.GetOriginalException(e).Message);
            }

            //return PartialView("_pvEstatusCalculoTrabajador");
        }

    }
}

