﻿using DevExpress.Data.Filtering;
using DevExpress.Web.Mvc;
using DevExpress.XtraReports.UI;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using Nova.Models;

namespace Nova.Controllers.Busqueda
{
    public class BusquedaController : BaseController
    {
        bdNovaEntities bd = new bdNovaEntities();

        public ActionResult getMenuTrabajador(int id,int idcltc=0)
        {
            vwDatosAspirantesTrabajadores model = new vwDatosAspirantesTrabajadores();
            if (idcltc > 0)
                model = bd.vwDatosAspirantesTrabajadores.Where(t => t.IdKardex == id && t.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();
            else
                model = bd.vwDatosAspirantesTrabajadores.Where(t => t.IdKardex == id).FirstOrDefault();

            return PartialView("_getMenuTrabajador",model);
        }
        public ActionResult getMenuTrabajadorLicencias(int id, int idcltc)
        {
            var model = bd.vwDatosAspirantesTrabajadores.Where(t => t.IdKardex == id && t.IdConvenioLaboralTrabajadorCategoria == idcltc).FirstOrDefault();
            return PartialView("_getMenuTrabajadorLicencias", model);
        }

        public ActionResult ExportTo(string filterString)
        {


            return GridViewExtension.ExportToXls(GridViewHelper.ExportGridViewSettings, Nova.Models.Busqueda.BuscarTrabajadoresExportar(filterString));



        }

        public ActionResult ExportTjhkjho(string filterString)
        {
            //CriteriaOperator filterCriteria = CriteriaOperator.Parse(filterString);
            IList<Nova.Models.vwDatosAspirantesTrabajadores> products = Nova.Models.Busqueda.BuscarTrabajadoresExportar(filterString);

            XtraReport report = new XtraReport();
            report.DataSource = products;
            ExportReport(report, "largeData", true, "Xlsx");
            return PartialView("_pvGridTrabajadores");
        }

        public void ExportReport(XtraReport report, string fileName, bool saveAsFile, string fileFormat)
        {
            using (MemoryStream stream = new MemoryStream())
            {
                report.ExportToXlsx(stream);

                string disposition = saveAsFile ? "attachment" : "inline";

                Response.Clear();
                Response.Buffer = false;
                Response.AppendHeader("Content-Type", string.Format("application/{0}", fileFormat));
                Response.AppendHeader("Content-Transfer-Encoding", "binary");
                Response.AppendHeader("Content-Disposition", string.Format("{0}; filename={1}.{2}", disposition, HttpUtility.UrlEncode(fileName).Replace("+", "%20"), fileFormat));
                Response.BinaryWrite(stream.ToArray());
                Response.End();
            }
        }

        //
        // GET: /Busqueda/
       
        public ActionResult Index(string Id = "")
        {
            ViewData["Id"] = Id;
            // BUSCAR TRABAJADORES SEGUN POR ESTRUCTURA ORGANICA
            //if (Session["Busqueda"].ToString().ToUpper() == "INCIDENCIAS")
            //{
            //    return View("_buscarincidencias");
            //}

            //else 
            if (Session["Aplicacion"] != null)
            { if (Session["Aplicacion"].ToString().ToUpper() == "CAPACITACIÓN")
                {
                    return View("_buscarcapacitacion");
                }
                else

                    return View();
            }
            else

                return View();
        }
        


        public ActionResult BuscarCapacitacion(string Id = "")
        {
            ViewData["Id"] = Id;

            return PartialView("_pvGridCapacitacion");
        }

        public ActionResult BuscarIncidencias(string Id = "")
        {
            ViewData["Id"] = Id;

            return PartialView("_pvGridIncidencias");
        }

        public ActionResult DetalleCapacitacion(int id)
        {
            ViewData["idkardex"] = Request.Form["Id"];
            ViewBag.cons  = bd.Capacitacion_stConstanciasImpresas.ToList(); 

            return PartialView("_DetalleCapacitacion", bd.Capacitacion_stParticipantes.Where(f => f.IdKardex== id  ).ToList());
        }


        public ActionResult BuscarTrabajadores(string Id = "")
        {
            ViewData["Id"] = Id;

            return PartialView("_pvGridTrabajadores", Nova.Models.Busqueda.BuscarTrabajadores(Id));
        }

        public ActionResult BuscarNominas(string Id = "")
        {
            ViewData["Id"] = Request.Form["Id"];

            return PartialView("_pvGridNominas");
        }

        public ActionResult BuscarProcesos(string Id = "")
        {
            ViewData["Id"] = Request.Form["Id"];

            return PartialView("_pvGridProcesos");
        }

        [HttpPost]
        public ActionResult Redirect(FormCollection form)
        {

            string[] parameters = form["Url"].Split('/');
            var rutas = new RouteValueDictionary();


            if (parameters.Length > 2)
                for (int i = 2; i < parameters.Length; i++)
                {
                    string controlname = "hf" + parameters[i] + "Busquedactrl";
                    rutas[parameters[i]] = form[controlname];
                }


            return RedirectToAction(parameters[1], parameters[0], rutas);
            //return Redirect(form
        }


    }

    public static class GridViewHelper
    {
        private static GridViewSettings exportGridViewSettings;

        public static GridViewSettings ExportGridViewSettings
        {
            get
            {
                if (exportGridViewSettings == null)
                    exportGridViewSettings = CreateExportGridViewSettings();
                return exportGridViewSettings;
            }
        }

        private static GridViewSettings CreateExportGridViewSettings()
        {
            GridViewSettings settings = new GridViewSettings();

            settings.Name = "trabajadores";
            settings.CallbackRouteValues = new { Controller = "Busqueda", Action = "BuscarTrabajadores" };

            settings.KeyFieldName = "IdKardex";
            settings.Settings.ShowFilterRow = true;

            settings.Columns.Add("IdTrabajador");
            settings.Columns.Add("CURP");
            settings.Columns.Add("Nombre");
            settings.Columns.Add("ApellidoPaterno");
            settings.Columns.Add("ApellidoMaterno");
            settings.Columns.Add("RFC");
            settings.Columns.Add("Sexo");
            settings.Columns.Add("ConvenioLaboral");
            settings.Columns.Add("RelacionLaboral");
            settings.Columns.Add("EstructuraOrganicaPadre", "Area");
            settings.Columns.Add("EstructuraOrganica", "Adscripción");
            settings.Columns.Add("UbicacionFisica", "Labora Fisicamente");
            settings.Columns.Add("Categoria");
            settings.Columns.Add("EstatusTrabajador");



            settings.Columns.Add("ConvenioLaboral");
            settings.Columns.Add("RelacionLaboral");
            settings.Columns.Add("Categoria");
            settings.Columns.Add("EstructuraOrganica");
            settings.Columns.Add("EstructuraOrganicaPadre");
            settings.Columns.Add("EsComisionado");
            settings.Columns.Add("FechaInicio");
            settings.Columns.Add("FechaTermino");

            settings.Columns.Add("EstatusTrabajador");

            settings.Columns.Add("NSS");
            settings.Columns.Add("CorreoElectronico");


            return settings;
        }

       
    }
}
