﻿using Nova.Models;
using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova
{

    public class BaseController : System.Web.Mvc.Controller
    {
        public enum TypePushNotification
        {
            success, info, warning, error
        }

        private void GrabaBitacora(string usuario, string msj, string app)
        {
            string actionName = this.ControllerContext.RouteData.Values["action"].ToString();
            string controllerName = this.ControllerContext.RouteData.Values["controller"].ToString();

            bdNovaEntities db = new bdNovaEntities();
            Sistema_Bitacora bt = new Sistema_Bitacora();
            bt.Notificacion = msj;
            bt.Accion = actionName;
            bt.Controlador = controllerName;
            bt.Fecha = System.DateTime.Now;
            bt.Usuario = usuario;
            bt.Aplicacion = app;
            db.Sistema_Bitacora.Add(bt);
            db.SaveChanges();
        }
        public void SendPushNotification(string message, TypePushNotification typemsg = TypePushNotification.info, string DirigidoAplicacion = null)
        {
            string usuario = "";

            if (Seguridad.Identidad.Usuario() != null)
            {
                usuario = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno;
            }



            if (DirigidoAplicacion != null)
            {
                var Dirigidoa = DirigidoAplicacion.Split(',');

                foreach (var item in Dirigidoa)
                {
                    var roles = Seguridad.Identidad.Roles();
                    var existe = roles.Find(w => item.Contains(w.ApplicationName));

                    //if (existe != null)
                    //{
                    //    HubPush.Static_Send(usuario, message, typemsg.ToString(), null);

                    //}
                }

            }
            //else
            //    HubPush.Static_Send(usuario, message, typemsg.ToString(), null);

            if (DirigidoAplicacion != null)
            {
                var Dirigidoa = DirigidoAplicacion.Split(',');

                foreach (var item in Dirigidoa)
                {
                    GrabaBitacora(usuario, message, item);
                }
            }
            else
                GrabaBitacora(usuario, message, DirigidoAplicacion);
        }

        [AllowAnonymous]
        public ActionResult Footer(string titulo)
        {
            ViewBag.titulo = titulo;
            return View("_footerRotativa2018");
        }

        [AllowAnonymous]
        public ActionResult Header(string area, string titulo)
        {
            ViewBag.rotativatitulo = titulo;
            ViewBag.rotativaarea = area;
            return View("_headerRotativa2018");
        }

        public JsonResult JsonView(bool success, string msj = null, string viewName = null, object model = null, string Url = null, string id = null, string errorCode = null)
        {
            return Json(new { Valid = success, Errors = GetErrorsFromModelState(), Message = msj, View = RenderPartialView(viewName, model), Url = Url, Model = model, Id = id, ErrorCode = errorCode }, JsonRequestBehavior.AllowGet);
        }


        public string RenderPartialView(string viewName = null, object model = null)
        {
            if (viewName != null)
            {
                ViewData.Model = model;
                using (var sw = new StringWriter())
                {
                    var viewResult =
                        ViewEngines.Engines.FindPartialView(ControllerContext, viewName);
                    var viewContext = new ViewContext(ControllerContext,
                        viewResult.View, ViewData, TempData, sw);
                    viewResult.View.Render(viewContext, sw);

                    return sw.GetStringBuilder().ToString();
                }
            }
            return "";
        }

        // This method helps to get the error information from the MVC "ModelState".
        // We can not directly send the ModelState to the client in Json. The "ModelState"
        // object has some circular reference that prevents it to be serialized to Json.
        //public Dictionary<string, object> GetErrorsFromModelState()
        //{
        //    var errors = new Dictionary<string, object>();
        //    foreach (var key in ModelState.Keys)
        //    {
        //        // Only send the errors to the client.
        //        if (ModelState[key].Errors.Count > 0)
        //        {
        //            errors[key] = ModelState[key].Errors;
        //        }
        //    }

        //    return errors;
        //}
        public IEnumerable GetErrorsFromModelState()
        {
            if (!this.ModelState.IsValid)
            {
                return this.ModelState.ToDictionary(kvp => kvp.Key,
                    kvp => kvp.Value.Errors
                                    .Select(e => e.ErrorMessage).ToArray())
                                    .Where(m => m.Value.Count() > 0);
            }
            return null;
        }
    }

}