﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Models.Designpattern;
using System.Transactions;

namespace Nova.Controllers.AmonestacionTrabajador
{
    public class AmonestacionTrabajadorController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: AmonestacionTrabajador
        public ActionResult Index(int IdConvenioLaboralTrabajadorCategoria)
        {
            var idcltc = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
            Session["IdConvenioLaboralTrabajadorCategoria"] = IdConvenioLaboralTrabajadorCategoria;

            var lista_AmonestacionTrabajador = db.Juridico_stAmonestacionTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();

            var juridico_stAmonestacionTrabajador = db.Juridico_stAmonestacionTrabajador.Include(j => j.Convenios_stConvenioLaboralTrabajadorCategoria).Include(j => j.Juridico_ctAmonestacion);
            return View(lista_AmonestacionTrabajador.ToList());
        }

        // GET: AmonestacionTrabajador/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_stAmonestacionTrabajador juridico_stAmonestacionTrabajador = db.Juridico_stAmonestacionTrabajador.Find(id);
            if (juridico_stAmonestacionTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(juridico_stAmonestacionTrabajador);
        }

        // GET: AmonestacionTrabajador/Create
         [HttpPost]
        public ActionResult Crear()
        {
            ViewBag.IdConvenioLaboralTrabajadorCategoria2 = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion");
            ViewBag.IdConvenioLaboralTrabajadorCategoria = Session["IdConvenioLaboralTrabajadorCategoria"];
            ViewBag.IdAmonestacion = new SelectList(db.Juridico_ctAmonestacion, "IdAmonestacion", "Descripcion");
            return View("Create");
        }

        // POST: AmonestacionTrabajador/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdAmonestacionTrabajador,IdAmonestacion,IdConvenioLaboralTrabajadorCategoria,Amonestacion,Acta,ObservacionAmo,FechaInicioAmonestacion,FechaTerminoAmonestacion")] Juridico_stAmonestacionTrabajador juridico_stAmonestacionTrabajador)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int) Session["IdConvenioLaboralTrabajadorCategoria"]; 
           
            if (ModelState.IsValid)
            {
                var lista_Amonestacion = db.Juridico_stAmonestacionTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
                juridico_stAmonestacionTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                db.Juridico_stAmonestacionTrabajador.Add(juridico_stAmonestacionTrabajador);
                db.SaveChanges();
                return RedirectToAction("Index", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
            }

            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", juridico_stAmonestacionTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdAmonestacion = new SelectList(db.Juridico_ctAmonestacion, "IdAmonestacion", "Descripcion", juridico_stAmonestacionTrabajador.IdAmonestacion);
            return View(juridico_stAmonestacionTrabajador);
        }

        // GET: AmonestacionTrabajador/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_stAmonestacionTrabajador juridico_stAmonestacionTrabajador = db.Juridico_stAmonestacionTrabajador.Find(id);
            if (juridico_stAmonestacionTrabajador == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", juridico_stAmonestacionTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdAmonestacion = new SelectList(db.Juridico_ctAmonestacion, "IdAmonestacion", "Descripcion", juridico_stAmonestacionTrabajador.IdAmonestacion);
            return View(juridico_stAmonestacionTrabajador);
        }

        // POST: AmonestacionTrabajador/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdAmonestacionTrabajador,IdAmonestacion,IdConvenioLaboralTrabajadorCategoria,Amonestacion,Acta,ObservacionAmo,FechaInicioAmonestacion,FechaTerminoAmonestacion")] Juridico_stAmonestacionTrabajador juridico_stAmonestacionTrabajador)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"]; 
            if (ModelState.IsValid)
            {
                juridico_stAmonestacionTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                db.Entry(juridico_stAmonestacionTrabajador).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", juridico_stAmonestacionTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdAmonestacion = new SelectList(db.Juridico_ctAmonestacion, "IdAmonestacion", "Descripcion", juridico_stAmonestacionTrabajador.IdAmonestacion);
            return View(juridico_stAmonestacionTrabajador);
        }


        public ActionResult Edit2(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_stAmonestacionTrabajador juridico_stAmonestacionTrabajador = db.Juridico_stAmonestacionTrabajador.Find(id);
            if (juridico_stAmonestacionTrabajador == null)
            {
                return HttpNotFound();
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", juridico_stAmonestacionTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdAmonestacion = new SelectList(db.Juridico_ctAmonestacion, "IdAmonestacion", "Descripcion", juridico_stAmonestacionTrabajador.IdAmonestacion);
            return View(juridico_stAmonestacionTrabajador);
        }



        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit2([Bind(Include = "IdAmonestacionTrabajador,IdAmonestacion,IdConvenioLaboralTrabajadorCategoria,Amonestacion,Acta,ObservacionAmo,FechaInicioAmonestacion,FechaTerminoAmonestacion")] Juridico_stAmonestacionTrabajador juridico_stAmonestacionTrabajador)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
            if (ModelState.IsValid)
            {
                
                juridico_stAmonestacionTrabajador.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                db.Entry(juridico_stAmonestacionTrabajador).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index", new { IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria });
            }
            ViewBag.IdConvenioLaboralTrabajadorCategoria = new SelectList(db.Convenios_stConvenioLaboralTrabajadorCategoria, "IdConvenioLaboralTrabajadorCategoria", "Observacion", juridico_stAmonestacionTrabajador.IdConvenioLaboralTrabajadorCategoria);
            ViewBag.IdAmonestacion = new SelectList(db.Juridico_ctAmonestacion, "IdAmonestacion", "Descripcion", juridico_stAmonestacionTrabajador.IdAmonestacion);
            return View(juridico_stAmonestacionTrabajador);
        }


        // GET: AmonestacionTrabajador/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_stAmonestacionTrabajador juridico_stAmonestacionTrabajador = db.Juridico_stAmonestacionTrabajador.Find(id);
            if (juridico_stAmonestacionTrabajador == null)
            {
                return HttpNotFound();
            }
            return View(juridico_stAmonestacionTrabajador);
        }

        // POST: AmonestacionTrabajador/Delete/5
        [HttpPost, ActionName("DeleteConfirmed")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(short id)
        {
            int IdConvenioLaboralTrabajadorCategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
            Juridico_stAmonestacionTrabajador juridico_stAmonestacionTrabajador = db.Juridico_stAmonestacionTrabajador.Find(id);
            db.Juridico_stAmonestacionTrabajador.Remove(juridico_stAmonestacionTrabajador);
            db.SaveChanges();
             return new JsonResult() { Data = "Registro eliminado exitosamente"};
        }
 

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
